<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:cc="http://www.redhat.com/CcTsfiMap"
  exclude-result-prefixes="cc">

  <xsl:output method="xml" indent="yes" />
  
  <!--  TODO: don't use absolute path -->
  <xsl:variable name="results" select="document('output/reports/TESTS-TestSuites.xml')" />
  <xsl:param name="fail.text" select="'failed'"/>
  <xsl:param name="pass.text" select="'passed'"/>
  <xsl:param name="not.covered.text" select="'not covered'"/>

  <xsl:template match="/">
    <xsl:for-each select="cc:testCaseMapping">
    <xsl:element name="cc-results">
    <xsl:for-each select="testSuite">
      <xsl:for-each select="testCase">
        <xsl:for-each select="test">
         
          <xsl:variable name="package" select=""/>
          <xsl:variable name="classname" select="../@name"/>
          <xsl:variable name="testname" select="@name"/>
          
          <xsl:element name="test">
            <xsl:attribute name="testSuite">
              <xsl:value-of select="../../@name"/>
            </xsl:attribute>
            <xsl:attribute name="testCase">
              <xsl:value-of select="$classname"/>
            </xsl:attribute>
            <xsl:attribute name="name">
              <xsl:value-of select="$testname"/>
            </xsl:attribute>  
            <xsl:for-each select="TSFI">
              <xsl:element name="tsfi"><xsl:value-of select="."/></xsl:element>
            </xsl:for-each>
            <xsl:element name="result">
              <xsl:choose>
                <xsl:when test="$results/testsuites/testsuite/testcase[@classname=$classname and @name=$testname]/failure[not(@message='')]"><xsl:value-of select="$fail.text"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$pass.text"/></xsl:otherwise>
              </xsl:choose>
            </xsl:element>
          <!--   
          <test>
            <xsl:value-of select="../../@name"/>|<xsl:value-of select="../@name"/>|<xsl:value-of select="@name"/>
          </test>
          -->  
          </xsl:element>
        </xsl:for-each>
      </xsl:for-each>
      
    </xsl:for-each>
    </xsl:element>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>