/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp584.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class MyLoginModule extends UsernamePasswordLoginModule
{
   private void addMemberOrWarn(Group group, String name)
   {
      Principal p = createIdentityOrWarn(name);
      if(p != null)
         group.addMember(p);
   }
   
   private Principal createIdentityOrWarn(String username)
   {
      try
      {
         return createIdentity(username);
      }
      catch(Exception e)
      {
         log.warn("Failed to create identity for '" + username + "'", e);
         return null;
      }
   }
   
   @Override
   protected String getUsersPassword() throws LoginException
   {
      return "jbpapp584";
   }

   @Override
   protected Group[] getRoleSets() throws LoginException
   {
      String username = getUsername();
      List<Group> groups = new ArrayList<Group>();
      Group rolesGroup = new SimpleGroup("Roles");
      groups.add(rolesGroup);
      
      addMemberOrWarn(rolesGroup, username);
      addMemberOrWarn(rolesGroup, "User");
      
      // http://www.jboss.org/community/docs/DOC-12517
      Group callerPrincipal = new SimpleGroup("CallerPrincipal");
      groups.add(callerPrincipal);
      callerPrincipal.addMember(getIdentity());
      
      return groups.toArray(new Group[0]);
   }

   @SuppressWarnings("unchecked")
   @Override
   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
   {
      super.initialize(subject, callbackHandler, sharedState, options);
   }

}
