/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp584;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;

import org.jboss.annotation.security.SecurityDomain;
import org.jboss.ejb3.test.jbpapp584.jaas.MyPrincipal;

/**
 * Based on the option specified in the custom principal you'll see different results.
 * 
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
@Stateless
@SecurityDomain("jbpapp584")
@RolesAllowed("User")
@Remote(DynamicViewRemote.class)
public class DynamicViewBean implements DynamicViewRemote
{
   @Resource
   private SessionContext ctx;
   
   public String[] getResults()
   {
      Principal caller = ctx.getCallerPrincipal();
      List<String> list = new ArrayList<String>();
      list.add(caller.getClass().getName());
      list.add(caller.getName());
      if(ctx.isCallerInRole("User"))
         list.add("User");
      if(ctx.isCallerInRole("Manager"))
         list.add("Manager");
      if(caller instanceof MyPrincipal)
      {
         MyPrincipal p = (MyPrincipal) caller;
         String option = p.getOption();
         if(option != null)
            list.add(option);
      }
      return list.toArray(new String[0]);
   }
}
