/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1186;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.annotation.ejb.cache.simple.CacheConfig;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
@Stateful
@Remote(AnInterface.class)
@CacheConfig(idleTimeoutSeconds = 30, maxSize = 2, removalTimeoutSeconds = 60)
public class AnInterfaceImpl implements AnInterface
{
   private static final Logger log = Logger.getLogger(AnInterfaceImpl.class);
   
   private Exception destroyed = null;
   
   protected static int failures = 0;
   
   @PostActivate
   public void activate()
   {
      log.info("Called activate on " + this);
   }

   @PostConstruct
   public void construct()
   {
      log.info("Called construct on " + this);
   }
   
   @PreDestroy
   public void destroy()
   {
      if(destroyed != null)
      {
         log.error("Bean " + this + " was already destroyed here", destroyed);
         failures++;
         // Note that it's actually useless to throw an exception from pre destroy
         // because if it's used in a SessionSynchronization, the TM will ignore it.
         throw new IllegalStateException("Bean " + this + " was already destroyed");
      }
      log.info("Called destroy on " + this);
      destroyed = new Exception("destroy");
   }

   @Remove
   public void discard()
   {
      log.info("Called discard on " + this);
   }

   public AnInterface getAnInterface()
   {
      try
      {
         InitialContext ctx = new InitialContext();
         AnInterface intf = (AnInterface) ctx.lookup("AnInterfaceImpl/remote");
         Register.register(intf);
         return intf;
      }
      catch (NamingException e)
      {
         throw new RuntimeException(e);
      }
   }

   @PrePassivate
   public void passivate()
   {
      log.info("Called passivate on " + this);
   }

}
