/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jaccpropagation.servlets;

import java.io.IOException;
import java.security.Principal;

import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.FilterChain;

import org.jboss.logging.Logger;

import org.jboss.security.SecurityAssociation;

import org.jboss.ejb3.test.jaccpropagation.Client;

/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
public class SecurityFilter implements Filter
{
   private static final Logger log = Logger.getLogger(SecurityFilter.class);
   
   public void init(FilterConfig filterConfig) throws ServletException
   {

   }

   public void doFilter(ServletRequest request, ServletResponse response,
      FilterChain filterChain)
      throws IOException, ServletException
   {
      HttpServletRequest httpRequest = (HttpServletRequest) request;
      
      Principal principal = (Principal)httpRequest.getSession().getAttribute(Client.SESSION_PRINCIPAL);
      Object credential = httpRequest.getSession().getAttribute(Client.SESSION_CREDENTIAL);
      
      log.info("*************** doFilter " + SecurityAssociation.getPrincipal() + " " + principal + " " + credential);
      
      if (principal != null)
      {
         Subject subject = new Subject();
         SecurityAssociation.pushSubjectContext(subject, principal, credential);
      }
      
      filterChain.doFilter(request, response);
   }

   public void destroy()
   {
   }
}
