/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.ejbthree1239.unit;

import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;

import junit.framework.Test;

import org.jboss.ejb3.test.ejbthree1239.Controller;
import org.jboss.test.JBossTestCase;

/**
 * @author <a href="mailto:carlo.dewolf@jboss.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class StopDeliveryUnitTestCase extends JBossTestCase
{
   public StopDeliveryUnitTestCase(String name)
   {
      super(name);
   }

   @Override
   protected void setUp() throws Exception
   {
      super.setUp();
      serverFound();
   }
   
   public void test1() throws Exception
   {
      InitialContext ctx = new InitialContext();
      Queue queue = (Queue) ctx.lookup("queue/ejbthree1239");
      QueueConnectionFactory factory = (QueueConnectionFactory) ctx.lookup("ConnectionFactory");
      QueueConnection connection = factory.createQueueConnection();
      try
      {
         connection.start();
         
         QueueSession session = connection.createQueueSession(false, QueueSession.AUTO_ACKNOWLEDGE);
         
         TemporaryQueue replyQueue = session.createTemporaryQueue();
         QueueReceiver receiver = session.createReceiver(replyQueue);
         
         QueueSender sender = session.createSender(queue);
         TextMessage message = session.createTextMessage("Hello world");
         message.setJMSReplyTo(replyQueue);
         sender.send(message);
         sender.close();
         
         MBeanServerConnection server = getServer();
         ObjectName name = new ObjectName("jboss.j2ee:jar=ejbthree1239.jar,name=FailingMDB,service=EJB3");
         assertTrue((Boolean) server.getAttribute(name, "DeliveryActive"));

         Message msg = receiver.receive(5000);
         assertNotNull(msg);
         
         receiver.close();
         session.close();
      }
      finally
      {
         connection.close();
      }
   }
   
   public void testRuntimeException() throws Exception
   {
      InitialContext ctx = new InitialContext();
      
      Controller controller = (Controller) ctx.lookup("ControllerBean/remote");
      
      Queue queue = (Queue) ctx.lookup("queue/ejbthree1239");
      QueueConnectionFactory factory = (QueueConnectionFactory) ctx.lookup("ConnectionFactory");
      QueueConnection connection = factory.createQueueConnection();
      try
      {
         connection.start();
         
         QueueSession session = connection.createQueueSession(false, QueueSession.AUTO_ACKNOWLEDGE);
         
         TemporaryQueue replyQueue = session.createTemporaryQueue();
         QueueReceiver receiver = session.createReceiver(replyQueue);
         
         controller.setFail(true);
         
         QueueSender sender = session.createSender(queue);
         TextMessage message = session.createTextMessage("Hello world");
         message.setJMSReplyTo(replyQueue);
         sender.send(message);
         sender.close();
         
         Message msg = receiver.receive(5000);
         assertNull(msg);
         
         MBeanServerConnection server = getServer();
         ObjectName name = new ObjectName("jboss.j2ee:jar=ejbthree1239.jar,name=FailingMDB,service=EJB3");
         assertFalse((Boolean) server.getAttribute(name, "DeliveryActive"));

         controller.setFail(false);
         
         server.invoke(name, "startDelivery", null, null);
         assertTrue((Boolean) server.getAttribute(name, "DeliveryActive"));
         
         msg = receiver.receive(5000);
         assertNotNull(msg);
         
         receiver.close();
         session.close();
      }
      finally
      {
         connection.close();
      }
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(StopDeliveryUnitTestCase.class, "ejbthree1239.jar");
   }
}
