/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.junit;

import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.util.CollectionsFactory;

public class MicrocontainerTestDelegate
extends AbstractTestDelegate {
    protected Kernel kernel;
    protected BeanXMLDeployer deployer;
    protected List deployments = CollectionsFactory.createCopyOnWriteList();

    public MicrocontainerTestDelegate(Class clazz) throws Exception {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            AbstractBootstrap abstractBootstrap = this.getBootstrap();
            abstractBootstrap.run();
            this.kernel = abstractBootstrap.getKernel();
            this.deployer = new BeanXMLDeployer(this.kernel);
            this.deploy();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.undeploy();
    }

    protected AbstractBootstrap getBootstrap() throws Exception {
        return new BasicBootstrap();
    }

    protected Object getBean(Object object, ControllerState controllerState) {
        KernelControllerContext kernelControllerContext = this.getControllerContext(object, controllerState);
        return kernelControllerContext.getTarget();
    }

    protected KernelControllerContext getControllerContext(Object object, ControllerState controllerState) {
        KernelController kernelController = this.kernel.getController();
        KernelControllerContext kernelControllerContext = (KernelControllerContext)kernelController.getContext(object, controllerState);
        if (kernelControllerContext == null) {
            throw new IllegalStateException("Bean not found " + object);
        }
        return kernelControllerContext;
    }

    protected void validate() throws Exception {
        try {
            this.deployer.validate();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected KernelDeployment deploy(URL uRL) throws Exception {
        try {
            this.log.debug((Object)("Deploying " + uRL));
            KernelDeployment kernelDeployment = this.deployer.deploy(uRL);
            this.deployments.add(kernelDeployment);
            this.log.debug((Object)("Deployed " + uRL));
            return kernelDeployment;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected void undeploy(KernelDeployment kernelDeployment) {
        this.log.debug((Object)("Undeploying " + kernelDeployment.getName()));
        this.deployments.remove(kernelDeployment);
        try {
            this.deployer.undeploy(kernelDeployment);
            this.log.debug((Object)("Undeployed " + kernelDeployment.getName()));
        }
        catch (Throwable throwable) {
            this.log.warn((Object)("Error during undeployment: " + kernelDeployment.getName()), throwable);
        }
    }

    protected void deploy() throws Exception {
        String string = this.clazz.getName();
        string = string.replace('.', '/') + ".xml";
        URL uRL = this.clazz.getClassLoader().getResource(string);
        if (uRL != null) {
            this.deploy(uRL);
        } else {
            this.log.debug((Object)("No test specific deployment " + string));
        }
    }

    protected void undeploy() {
        ListIterator listIterator = this.deployments.listIterator(this.deployments.size());
        while (listIterator.hasPrevious()) {
            KernelDeployment kernelDeployment = (KernelDeployment)listIterator.previous();
            this.undeploy(kernelDeployment);
        }
    }
}

