/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.classloading.plugins.SystemDomainClassLoader;
import org.jboss.classloading.spi.ClassLoadingDomain;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.util.ClassLoading;
import org.jboss.util.CollectionsFactory;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractClassLoadingDomain
extends JBossObject
implements ClassLoadingDomain,
KernelRegistryPlugin {
    protected boolean java2ClassLoadingCompliance;
    protected ClassLoadingDomain parent;
    protected Map pkgToCLs = CollectionsFactory.createConcurrentReaderMap();
    protected Map cachedClasses = CollectionsFactory.createConcurrentReaderMap();
    protected Map failedClasses = CollectionsFactory.createConcurrentReaderMap();
    protected Map cachedResources = CollectionsFactory.createConcurrentReaderMap();
    protected Set failedResources = CollectionsFactory.createCopyOnWriteSet();
    protected static AbstractClassLoadingDomain root = new AbstractClassLoadingDomain(true, null);

    public AbstractClassLoadingDomain() {
        this(true, root);
    }

    public AbstractClassLoadingDomain(boolean bl) {
        this(bl, root);
    }

    public AbstractClassLoadingDomain(ClassLoadingDomain classLoadingDomain) {
        this(true, classLoadingDomain);
    }

    public AbstractClassLoadingDomain(boolean bl, ClassLoadingDomain classLoadingDomain) {
        this.java2ClassLoadingCompliance = bl;
        this.parent = classLoadingDomain;
    }

    public synchronized void addDomainClassLoader(DomainClassLoader domainClassLoader) {
        boolean bl = this.log.isTraceEnabled();
        domainClassLoader.setDomain(this);
        Set set = domainClassLoader.getPackageNames();
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " adding classloader " + domainClassLoader + " packages " + set));
        }
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = string.replace('.', '/');
                List list = (List)this.pkgToCLs.get(string2);
                if (list == null) {
                    list = CollectionsFactory.createCopyOnWriteList();
                    this.pkgToCLs.put(string2, list);
                }
                list.add(domainClassLoader);
            }
        }
        this.toString = null;
        this.flushFailures();
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " added classloader " + domainClassLoader + " packageMap=" + this.pkgToCLs));
        }
    }

    public synchronized void removeDomainClassLoader(DomainClassLoader domainClassLoader) {
        boolean bl = this.log.isTraceEnabled();
        Set set = domainClassLoader.getPackageNames();
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " removing classloader " + domainClassLoader + " packages " + set));
        }
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = string.replace('.', '/');
                List list = (List)this.pkgToCLs.get(string2);
                if (list == null) continue;
                list.remove(domainClassLoader);
                if (!list.isEmpty()) continue;
                this.pkgToCLs.remove(string2);
            }
        }
        domainClassLoader.setDomain(null);
        this.toString = null;
        this.flushCache();
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " removed classloader " + domainClassLoader + " packageMap=" + this.pkgToCLs));
        }
    }

    public void flushCache() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.toShortString() + " flushing the cache"));
        }
        this.cachedClasses.clear();
        this.cachedResources.clear();
    }

    public void flushFailures() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.toShortString() + " flushing the failures cache"));
        }
        this.failedClasses.clear();
        this.failedResources.clear();
    }

    public KernelRegistryEntry getEntry(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        String string2 = string.replace('.', '/');
        List list = (List)this.pkgToCLs.get(string2);
        if (list != null) {
            DomainClassLoader domainClassLoader = (DomainClassLoader)list.get(0);
            return new AbstractKernelRegistryEntry(object, domainClassLoader.getPackage(string));
        }
        if (this.parent != null && this.parent instanceof KernelRegistryPlugin) {
            KernelRegistryPlugin kernelRegistryPlugin = (KernelRegistryPlugin)((Object)this.parent);
            return kernelRegistryPlugin.getEntry(object);
        }
        return null;
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public ClassLoadingDomain getParent() {
        return this.parent;
    }

    public synchronized Class loadClass(String string, boolean bl, DomainClassLoader domainClassLoader) throws ClassNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean bl2 = this.log.isTraceEnabled();
        if (bl2) {
            this.log.trace((Object)(this.toShortString() + " loading class " + string + " resolve=" + bl + " classLoader=" + domainClassLoader));
        }
        Class clazz = null;
        if (this.java2ClassLoadingCompliance && this.parent != null) {
            clazz = this.loadClassFromParent(bl2, string, bl, domainClassLoader);
        }
        if (clazz == null) {
            this.checkLoadClassFailed(bl2, string, bl, domainClassLoader);
        }
        if (clazz == null) {
            clazz = this.loadClassFromCache(bl2, string, bl, domainClassLoader);
        }
        if (clazz == null) {
            clazz = this.loadClassFromClassLoaders(bl2, string, bl, domainClassLoader);
        }
        if (clazz == null && !this.java2ClassLoadingCompliance && this.parent != null) {
            clazz = this.loadClassFromParent(bl2, string, bl, domainClassLoader);
        }
        if (clazz == null) {
            this.loadClassFailed(bl2, string, bl, domainClassLoader);
        }
        return clazz;
    }

    public URL loadResource(String string, DomainClassLoader domainClassLoader) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean bl = this.log.isTraceEnabled();
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + string + " classLoader=" + domainClassLoader));
        }
        URL uRL = null;
        if (domainClassLoader != null) {
            this.loadResourceFromClassLoader(bl, string, domainClassLoader);
        }
        if (uRL == null && this.java2ClassLoadingCompliance && this.parent != null) {
            uRL = this.loadResourceFromParent(bl, string, domainClassLoader);
        }
        if (uRL == null && this.checkLoadResourceFailed(bl, string, domainClassLoader)) {
            return null;
        }
        if (uRL == null) {
            uRL = this.loadResourceFromCache(bl, string, domainClassLoader);
        }
        if (uRL == null) {
            uRL = this.loadResourceFromClassLoaders(bl, string, domainClassLoader);
        }
        if (uRL == null && !this.java2ClassLoadingCompliance && this.parent != null) {
            uRL = this.loadResourceFromParent(bl, string, domainClassLoader);
        }
        if (uRL == null) {
            this.loadResourceFailed(bl, string, domainClassLoader);
        }
        return uRL;
    }

    protected void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("packages=").append(this.pkgToCLs.keySet());
        if (this.parent != null) {
            jBossStringBuilder.append(" parent=").append(this.parent.toShortString());
        }
    }

    public void toShortString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append(this.getClassShortName()).append('@');
        jBossStringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
    }

    protected Class loadClassFromParent(boolean bl, String string, boolean bl2, DomainClassLoader domainClassLoader) {
        try {
            if (bl) {
                this.log.trace((Object)(this.toShortString() + " loading class " + string + " from parent " + this.parent.toShortString()));
            }
            Class clazz = this.parent.loadClass(string, bl2, null);
            if (bl) {
                this.log.trace((Object)(this.toShortString() + " loaded " + clazz + " from parent " + this.parent.toShortString()));
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                this.log.trace((Object)(this.toShortString() + " loading class " + string + " failed for parent " + this.parent.toShortString()));
            }
            return null;
        }
    }

    protected Class loadClassFromClassLoaders(boolean bl, String string, boolean bl2, DomainClassLoader domainClassLoader) {
        String string2 = string.replace('.', '/');
        List list = (List)this.pkgToCLs.get(ClassLoading.getPackageName(string2));
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " loading class " + string + " from classloaders " + list));
        }
        if (list == null) {
            return null;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            DomainClassLoader domainClassLoader2 = (DomainClassLoader)listIterator.next();
            try {
                Class clazz = domainClassLoader2.loadClassLocally(string, bl2);
                if (bl) {
                    this.log.trace((Object)(this.toShortString() + " loaded " + clazz + " from classloader " + domainClassLoader2));
                }
                this.cachedClasses.put(string, clazz);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!bl) continue;
                this.log.trace((Object)(this.toShortString() + " loading class " + string + " failed for classloader " + domainClassLoader2), (Throwable)classNotFoundException);
            }
        }
        return null;
    }

    protected Class loadClassFromCache(boolean bl, String string, boolean bl2, DomainClassLoader domainClassLoader) {
        Class clazz = (Class)this.cachedClasses.get(string);
        if (bl && clazz != null) {
            this.log.trace((Object)(this.toShortString() + " loaded from cache " + clazz));
        }
        return clazz;
    }

    protected void checkLoadClassFailed(boolean bl, String string, boolean bl2, DomainClassLoader domainClassLoader) throws ClassNotFoundException {
        ClassNotFoundException classNotFoundException = (ClassNotFoundException)this.failedClasses.get(string);
        if (classNotFoundException != null) {
            if (bl) {
                this.log.trace((Object)(this.toShortString() + " loading class " + string + " already failed"));
            }
            throw new ClassNotFoundException("Class " + string + " not found", classNotFoundException);
        }
    }

    protected void loadClassFailed(boolean bl, String string, boolean bl2, DomainClassLoader domainClassLoader) throws ClassNotFoundException {
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " loading class " + string + " failed"));
        }
        ClassNotFoundException classNotFoundException = new ClassNotFoundException("Class " + string + " not found ");
        this.failedClasses.put(string, classNotFoundException);
        throw classNotFoundException;
    }

    protected URL loadResourceFromParent(boolean bl, String string, DomainClassLoader domainClassLoader) {
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + string + " from parent " + this.parent.toShortString()));
        }
        URL uRL = this.parent.loadResource(string, null);
        if (bl) {
            if (uRL != null) {
                this.log.trace((Object)(this.toShortString() + " loaded resource " + uRL + " from parent " + this.parent.toShortString()));
            } else {
                this.log.trace((Object)(this.toShortString() + " loading resource " + string + " failed from parent " + this.parent.toShortString()));
            }
        }
        return uRL;
    }

    protected URL loadResourceFromClassLoader(boolean bl, String string, DomainClassLoader domainClassLoader) {
        URL uRL;
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + string + " from classloader " + domainClassLoader));
        }
        if ((uRL = domainClassLoader.loadResourceLocally(string)) != null) {
            if (bl) {
                this.log.trace((Object)(this.toShortString() + " loaded resource " + uRL + " from classloader " + domainClassLoader));
            }
            return uRL;
        }
        return null;
    }

    protected URL loadResourceFromClassLoaders(boolean bl, String string, DomainClassLoader domainClassLoader) {
        List list = (List)this.pkgToCLs.get(ClassLoading.getPackageName(string));
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + string + " from classloaders " + list));
        }
        if (list == null) {
            return null;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            DomainClassLoader domainClassLoader2 = (DomainClassLoader)listIterator.next();
            URL uRL = domainClassLoader2.loadResourceLocally(string);
            if (uRL != null) {
                if (bl) {
                    this.log.trace((Object)(this.toShortString() + " loaded resource " + uRL + " from classloader " + domainClassLoader2));
                }
                this.cachedResources.put(string, uRL);
                return uRL;
            }
            if (!bl) continue;
            this.log.trace((Object)(this.toShortString() + " loading resource " + string + " failed from classloader " + domainClassLoader2));
        }
        return null;
    }

    protected URL loadResourceFromCache(boolean bl, String string, DomainClassLoader domainClassLoader) {
        URL uRL = (URL)this.cachedResources.get(string);
        if (bl && uRL != null) {
            this.log.trace((Object)(this.toShortString() + " loaded resource " + uRL + " from cache "));
        }
        return uRL;
    }

    protected boolean checkLoadResourceFailed(boolean bl, String string, DomainClassLoader domainClassLoader) {
        if (this.failedResources.contains(string)) {
            if (bl) {
                this.log.trace((Object)(this.toShortString() + " loading resource " + string + " already failed"));
            }
            return true;
        }
        return false;
    }

    protected void loadResourceFailed(boolean bl, String string, DomainClassLoader domainClassLoader) {
        this.failedResources.add(string);
        if (bl) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + string + " failed"));
        }
    }

    static {
        SystemDomainClassLoader systemDomainClassLoader = new SystemDomainClassLoader();
        root.addDomainClassLoader(systemDomainClassLoader);
    }
}

