/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.Collection;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.ClassIterator;
import xjavadoc.MethodIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XJavaDoc;
import xjavadoc.XMember;
import xjavadoc.XMethod;

public class MethodTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$XDocletMessages;
    static /* synthetic */ Class class$xdoclet$tagshandler$MethodTagsHandler;

    public static String getMethodTypeFor(XMethod method) {
        return method.getReturnType().getQualifiedName() + method.getReturnDimensionAsString();
    }

    public static String getMethodNameWithoutPrefixFor(XMethod currentMethod) {
        String name = currentMethod.getName();
        if (name.startsWith("get") || name.startsWith("set")) {
            return name.substring(3);
        }
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        return name;
    }

    public static String getPropertyNameFor(XMethod method) {
        String name = MethodTagsHandler.getMethodNameWithoutPrefixFor(method);
        int len = name.length();
        if (len == 0) {
            return name;
        }
        if (len == 1) {
            return name.toLowerCase();
        }
        char c = name.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32) + name.substring(1);
        }
        return name;
    }

    public static boolean isGetter(String str) {
        boolean bl = false;
        if (str.startsWith("get") || str.startsWith("is")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isSetter(String str) {
        return str.startsWith("set");
    }

    public static boolean isGetterMethod(XMethod method) {
        String str = method.getName();
        return (str.startsWith("get") || str.startsWith("is")) && !method.getReturnType().equals(XJavaDoc.getInstance().getXClass("void")) && method.getParameters().size() == 0;
    }

    public static boolean isSetterMethod(XMethod method) {
        String str = method.getName();
        return str.startsWith("set") && method.getReturnType().equals(XJavaDoc.getInstance().getXClass("void")) && method.getParameters().size() == 1;
    }

    public static boolean hasMethod(XClass clazz, String methodName, String[] parameters, boolean setCurrentMethod) throws XDocletException {
        return MethodTagsHandler.hasExecutableMember(clazz, methodName, parameters, setCurrentMethod, 1);
    }

    public String getterPrefix() throws XDocletException {
        if (MethodTagsHandler.getCurrentMethod().getName().startsWith("get")) {
            return "get";
        }
        if (MethodTagsHandler.getCurrentMethod().getName().startsWith("is")) {
            return "is";
        }
        if (MethodTagsHandler.getCurrentMethod().getName().startsWith("set")) {
            String[] params = new String[]{MethodTagsHandler.getCurrentMethod().getReturnType().getQualifiedName()};
            if (MethodTagsHandler.hasMethod(MethodTagsHandler.getCurrentClass(), "is" + this.methodNameWithoutPrefix(), params, false)) {
                return "is";
            }
            return "get";
        }
        return "";
    }

    public String getterMethod() throws XDocletException {
        return this.getterPrefix() + this.methodNameWithoutPrefix();
    }

    public String setterMethod() throws XDocletException {
        return "set" + this.methodNameWithoutPrefix();
    }

    public void setCurrentMethod(String template, Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        XMethod oldMethod = MethodTagsHandler.getCurrentMethod();
        if (MethodTagsHandler.hasMethod(MethodTagsHandler.getCurrentClass(), methodName, parameters, true)) {
            this.generate(template);
        }
        MethodTagsHandler.setCurrentMethod(oldMethod);
    }

    public String modifiers() throws XDocletException {
        return this.modifiers(1);
    }

    public String methodComment(Properties attributes) throws XDocletException {
        return this.memberComment(attributes, 1);
    }

    public void ifHasMethodComment(String template) throws XDocletException {
        Properties attributes = new Properties();
        attributes.setProperty("no-comment-signs", "true");
        String comment = this.methodComment(attributes);
        if (!comment.trim().equals("")) {
            this.generate(template);
        }
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        return this.exceptionList(attributes, 1);
    }

    public void ifIsAbstract(String template, Properties attributes) throws XDocletException {
        if (this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void ifIsNotAbstract(String template, Properties attributes) throws XDocletException {
        if (!this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void ifReturnsVoid(String template, Properties attributes) throws XDocletException {
        if (this.returnsVoid(attributes)) {
            this.generate(template);
        }
    }

    public void ifDoesntReturnVoid(String template, Properties attributes) throws XDocletException {
        if (!this.returnsVoid(attributes)) {
            this.generate(template);
        }
    }

    public void forAllClassMethods(String template, Properties attributes) throws XDocletException {
        String typeName = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        Collection classes = MethodTagsHandler.getAllClasses();
        TreeSet methods = new TreeSet();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz = i.next();
            if (typeName != null && !TypeTagsHandler.isOfType(clazz, typeName, extent)) continue;
            Collection classMethods = clazz.getMethods();
            methods.addAll(classMethods);
        }
        MethodIterator methodIterator = XCollections.methodIterator(methods);
        while (methodIterator.hasNext()) {
            XMethod current = methodIterator.next();
            MethodTagsHandler.setCurrentClass(current.getContainingClass());
            MethodTagsHandler.setCurrentMethod(current);
            this.generate(template);
        }
    }

    public void forAllMethods(String template, Properties attributes) throws XDocletException {
        this.forAllMembers(template, attributes, 1);
    }

    public void ifDoesntHaveMethodTag(String template, Properties attributes) throws XDocletException {
        if (!MethodTagsHandler.hasTag(attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasMethodTag(String template, Properties attributes) throws XDocletException {
        if (MethodTagsHandler.hasTag(attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreMethod(String template, Properties attributes) throws XDocletException {
        XMethod method = MethodTagsHandler.getCurrentMethod();
        this.generate(template);
        MethodTagsHandler.setCurrentMethod(method);
    }

    public void ifMethodTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (MethodTagsHandler.isTagValueEqual(attributes, 1)) {
            this.generate(template);
        }
    }

    public void ifMethodNameEquals(String template, Properties attributes) throws XDocletException {
        this.ifMethodNameEquals_Impl(template, attributes, true);
    }

    public void ifMethodNameNotEquals(String template, Properties attributes) throws XDocletException {
        this.ifMethodNameEquals_Impl(template, attributes, false);
    }

    public void ifMethodTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!MethodTagsHandler.isTagValueEqual(attributes, 1)) {
            this.generate(template);
        }
    }

    public String methodTagValue(Properties attributes) throws XDocletException {
        return MethodTagsHandler.getExpandedDelimitedTagValue(attributes, 1);
    }

    public void forAllMethodTags(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTags(template, attributes, 1, "ONLY_CALL_METHOD_NOT_NULL", new String[]{"forAllMethodTags"});
    }

    public void forAllMethodTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 1);
    }

    public String firstSentenceDescriptionOfCurrentMethod() throws XDocletException {
        return this.firstSentenceDescriptionOfCurrentMember((XMember)MethodTagsHandler.getCurrentMethod());
    }

    public String methodType(Properties attributes) throws XDocletException {
        boolean full_qualified_format = TypeConversionUtil.stringToBoolean(attributes.getProperty("fullQualifiedFormat"), false);
        return MethodTagsHandler.getMethodTypeFor(MethodTagsHandler.getCurrentMethod());
    }

    public void ifIsOfType(String template, Properties attributes) throws XDocletException {
        if (this.ifIsOfTypeImpl(template, attributes)) {
            this.generate(template);
        }
    }

    public void ifIsNotOfType(String template, Properties attributes) throws XDocletException {
        if (!this.ifIsOfTypeImpl(template, attributes)) {
            this.generate(template);
        }
    }

    public boolean ifIsOfTypeImpl(String template, Properties attributes) throws XDocletException {
        return this.methodType(attributes).equals(attributes.getProperty("type"));
    }

    public String methodName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)attributes.get("value")) != null) {
            String m = MethodTagsHandler.getCurrentMethod().getName().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return MethodTagsHandler.getCurrentMethod() != null ? MethodTagsHandler.getCurrentMethod().getName() : "";
    }

    public String methodNameWithoutPrefix() throws XDocletException {
        return MethodTagsHandler.getMethodNameWithoutPrefixFor(MethodTagsHandler.getCurrentMethod());
    }

    public String currentMethodName() throws XDocletException {
        return MethodTagsHandler.getCurrentMethod().getName();
    }

    public String propertyName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor(MethodTagsHandler.getCurrentMethod());
    }

    public void ifHasMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, true);
    }

    public void ifDoesntHaveMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, false);
    }

    public void ifIsGetter(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name != null) {
            if (MethodTagsHandler.isGetter(method_name)) {
                this.generate(template);
            }
        } else if (MethodTagsHandler.isGetterMethod(MethodTagsHandler.getCurrentMethod())) {
            this.generate(template);
        }
    }

    public void ifIsSetter(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name != null) {
            if (MethodTagsHandler.isSetter(method_name)) {
                this.generate(template);
            }
        } else if (MethodTagsHandler.isSetterMethod(MethodTagsHandler.getCurrentMethod())) {
            this.generate(template);
        }
    }

    public void ifIsPublic(String template) throws XDocletException {
        if (MethodTagsHandler.getCurrentMethod().isPublic()) {
            this.generate(template);
        }
    }

    private final boolean isAbstract(Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("method");
        if (methodName == null) {
            return MethodTagsHandler.getCurrentMethod().isAbstract();
        }
        XMethod method = (XMethod)this.getXExecutableMemberForMemberName(methodName, true, 1);
        if (method == null) {
            Class clazz = class$xdoclet$XDocletMessages;
            if (clazz == null) {
                clazz = class$xdoclet$XDocletMessages = MethodTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            throw new XDocletException(Translator.getString(clazz, "METHOD_NOT_FOUND", new String[]{methodName}));
        }
        return method.isAbstract();
    }

    private final boolean returnsVoid(Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("method");
        if (methodName == null) {
            return "void".equals(MethodTagsHandler.getMethodTypeFor(MethodTagsHandler.getCurrentMethod()));
        }
        XMethod method = (XMethod)this.getXExecutableMemberForMemberName(methodName, true, 1);
        if (method == null) {
            Class clazz = class$xdoclet$XDocletMessages;
            if (clazz == null) {
                clazz = class$xdoclet$XDocletMessages = MethodTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            throw new XDocletException(Translator.getString(clazz, "METHOD_NOT_FOUND", new String[]{methodName}));
        }
        return "void".equals(MethodTagsHandler.getMethodTypeFor(method));
    }

    private final void ifMethodNameEquals_Impl(String template, Properties attributes, boolean condition) throws XDocletException {
        String method_name = attributes.getProperty("name");
        if (MethodTagsHandler.getCurrentMethod().getName().equals(method_name) == condition) {
            this.generate(template);
        }
    }

    private final void ifHasMethod_Impl(String template, Properties attributes, boolean hasMethod) throws XDocletException {
        Class clazz = class$xdoclet$tagshandler$MethodTagsHandler;
        if (clazz == null) {
            clazz = class$xdoclet$tagshandler$MethodTagsHandler = MethodTagsHandler.class$("[Lxdoclet.tagshandler.MethodTagsHandler;", false);
        }
        Log log = LogUtil.getLog(clazz, "ifHasMethod_Impl");
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("methodName=" + methodName));
            log.debug((Object)("parametersStr=" + parametersStr));
            log.debug((Object)("delimiter=" + delimiter));
            log.debug((Object)("hasMethod=" + hasMethod));
            log.debug((Object)("getCurrentClass()=" + MethodTagsHandler.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parameters.length=" + parameters.length));
                if (parameters.length > 0) {
                    log.debug((Object)("parameters[0]=" + parameters[0]));
                }
            }
        }
        if (MethodTagsHandler.hasMethod(MethodTagsHandler.getCurrentClass(), methodName, parameters, false) == hasMethod) {
            log.debug((Object)"method found.");
            this.generate(template);
        } else {
            log.debug((Object)"method not found.");
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

