/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui.table.renderer;

import webwork.view.taglib.ui.table.WebTable;
import webwork.view.taglib.ui.table.renderer.AbstractCellRenderer;
import webwork.view.taglib.ui.table.renderer.CellRenderer;
import webwork.view.taglib.ui.table.renderer.DefaultCellRenderer;

public class LinkCellRenderer
extends AbstractCellRenderer {
    protected CellRenderer _delegateRenderer = new DefaultCellRenderer();
    protected String _link = null;
    protected String _param = null;
    protected String _target = null;
    protected int _paramColumn = -1;
    protected String _paramValue = null;

    public String getCellValue(WebTable table, Object data, int row, int col) {
        String value = this._delegateRenderer.renderCell(table, data, row, col);
        StringBuffer cell = new StringBuffer(256);
        cell.append("<a href='").append(this._link);
        if (this._param != null) {
            cell.append("?").append(this._param).append("=");
            if (this._paramValue != null) {
                cell.append(this._paramValue);
            } else if (this._paramColumn >= 0) {
                cell.append(table.getModel().getValueAt(row, this._paramColumn).toString());
            }
        }
        cell.append("'");
        if (this._target != null && !"".equals(this._target)) {
            cell.append(" target='").append(this._target).append("'");
        }
        cell.append(">").append(value).append("</a>");
        return cell.toString();
    }

    public void setLink(String link) {
        this._link = link;
    }

    public void setParam(String param) {
        this._param = param;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public void setParamColumn(int paramColumn) {
        this._paramColumn = paramColumn;
    }

    public void setRenderer(CellRenderer delegateRenderer) {
        this._delegateRenderer = delegateRenderer;
        if (this._delegateRenderer instanceof AbstractCellRenderer) {
            this.setAlignment(((AbstractCellRenderer)this._delegateRenderer).getAlignment());
        }
    }

    public void setParamValue(String paramValue) {
        this._paramValue = paramValue;
    }
}

