/*
 * Decompiled with CFR 0.152.
 */
package webwork.test.view.taglib;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.util.Hashtable;
import javax.servlet.http.HttpUtils;
import junit.framework.Assert;
import junit.textui.TestRunner;
import org.xml.sax.SAXException;
import webwork.test.view.taglib.WebViewTestCase;

public class UrlTestCase
extends WebViewTestCase {
    static /* synthetic */ Class class$webwork$test$view$taglib$UrlTestCase;

    public UrlTestCase(String testName) {
        super(testName);
    }

    public void testNoParameters() {
        WebConversation conversation = new WebConversation();
        GetMethodWebRequest request = new GetMethodWebRequest("http://localhost:8080/webwork/tests/url.jsp");
        WebResponse response = null;
        try {
            response = conversation.getResponse((WebRequest)request);
        }
        catch (Exception e) {
            this.fail(e);
        }
        String[][] table = null;
        try {
            table = response.getTables()[0].asText();
        }
        catch (SAXException e) {
            this.fail(e);
        }
        ParsedURL parsedUrl = new ParsedURL(table[0][1]);
        Assert.assertEquals((String)"test 1 had an invalid url", (String)"/webwork/tests/url.jsp", (String)parsedUrl.getTarget());
        Assert.assertNull((String)"test 1 shouldn't have any parameters", (Object)parsedUrl.getParameters());
        parsedUrl = new ParsedURL(table[1][1]);
        Assert.assertEquals((String)"test 2 had an invalid url", (String)"next.action", (String)parsedUrl.getTarget());
        Assert.assertNull((String)"test 2 shouldn't have any parameters", (Object)parsedUrl.getParameters());
        parsedUrl = new ParsedURL(table[2][1]);
        Assert.assertEquals((String)"test 3 had an invalid url", (String)"http://www.google.com/search", (String)parsedUrl.getTarget());
        Assert.assertEquals((String)"test 3 - invalid nbr of parameters", (int)3, (int)parsedUrl.getParameters().size());
        this.checkParameters(parsedUrl.getParameters());
        parsedUrl = new ParsedURL(table[3][1]);
        Assert.assertEquals((String)"test 4 had an invalid url", (String)"next.action", (String)parsedUrl.getTarget());
        Assert.assertEquals((String)"test 4 - invalid nbr of parameters", (int)3, (int)parsedUrl.getParameters().size());
        this.checkParameters(parsedUrl.getParameters());
        parsedUrl = new ParsedURL(table[4][1]);
        Assert.assertEquals((String)"test 5 had an invalid url", (String)"/webwork/tests/url.jsp", (String)parsedUrl.getTarget());
        Assert.assertEquals((String)"test 5 - invalid nbr of parameters", (int)3, (int)parsedUrl.getParameters().size());
        this.checkParameters(parsedUrl.getParameters());
    }

    private void checkParameters(Hashtable parameters) {
        Assert.assertEquals((String)"param1 is invalid", (String)"value1", (String)((String[])parameters.get("param1"))[0]);
        Assert.assertEquals((String)"param2 is invalid", (String)"value2", (String)((String[])parameters.get("param2"))[0]);
        Assert.assertEquals((String)"param3 is invalid", (String)"value3", (String)((String[])parameters.get("param3"))[0]);
    }

    public void testParameters() {
        WebConversation conversation = new WebConversation();
        GetMethodWebRequest request = new GetMethodWebRequest("http://localhost:8080/webwork/tests/url.jsp?foo=bar");
        WebResponse response = null;
        try {
            response = conversation.getResponse((WebRequest)request);
        }
        catch (Exception e) {
            this.fail(e);
        }
        String[][] table = null;
        try {
            table = response.getTables()[0].asText();
        }
        catch (SAXException e) {
            this.fail(e);
        }
        ParsedURL parsedUrl = new ParsedURL(table[0][1]);
        Assert.assertEquals((String)"test 1 had an invalid url", (String)"/webwork/tests/url.jsp", (String)parsedUrl.getTarget());
        Assert.assertEquals((String)"test 1 shouldn't have any parameters", (int)1, (int)parsedUrl.getParameters().size());
        Assert.assertEquals((String)"parameter foo is invalid", (String)"bar", (String)((String[])parsedUrl.getParameters().get("foo"))[0]);
        parsedUrl = new ParsedURL(table[1][1]);
        Assert.assertEquals((String)"test 2 had an invalid url", (String)"next.action", (String)parsedUrl.getTarget());
        Assert.assertNull((String)"test 2 shouldn't have any parameters", (Object)parsedUrl.getParameters());
        parsedUrl = new ParsedURL(table[2][1]);
        Assert.assertEquals((String)"test 3 had an invalid url", (String)"http://www.google.com/search", (String)parsedUrl.getTarget());
        Assert.assertEquals((String)"test 3 - invalid nbr of parameters", (int)3, (int)parsedUrl.getParameters().size());
        this.checkParameters(parsedUrl.getParameters());
        parsedUrl = new ParsedURL(table[3][1]);
        Assert.assertEquals((String)"test 4 had an invalid url", (String)"next.action", (String)parsedUrl.getTarget());
        Assert.assertEquals((String)"test 4 - invalid nbr of parameters", (int)3, (int)parsedUrl.getParameters().size());
        this.checkParameters(parsedUrl.getParameters());
        parsedUrl = new ParsedURL(table[4][1]);
        Assert.assertEquals((String)"test 5 had an invalid url", (String)"/webwork/tests/url.jsp", (String)parsedUrl.getTarget());
        Assert.assertEquals((String)"test 5 - invalid nbr of parameters", (int)4, (int)parsedUrl.getParameters().size());
        this.checkParameters(parsedUrl.getParameters());
        Assert.assertEquals((String)"parameter foo is invalid", (String)"bar", (String)((String[])parsedUrl.getParameters().get("foo"))[0]);
    }

    private String parseUrl(String url) {
        if ((url = url.trim()).indexOf(59) > 0) {
            StringBuffer newUrl = new StringBuffer(url.substring(0, url.indexOf(59)));
            if (url.indexOf(63) > 0) {
                newUrl.append(url.substring(url.indexOf(63), url.length()));
            }
            return newUrl.toString();
        }
        return url;
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$webwork$test$view$taglib$UrlTestCase == null ? (class$webwork$test$view$taglib$UrlTestCase = UrlTestCase.class$("webwork.test.view.taglib.UrlTestCase")) : class$webwork$test$view$taglib$UrlTestCase));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParsedURL {
        private String target;
        private Hashtable parameters;

        public Hashtable getParameters() {
            return this.parameters;
        }

        public String getTarget() {
            return this.target;
        }

        public ParsedURL(String url) {
            url = url.trim();
            if (url.indexOf(59) > -1) {
                StringBuffer buffer = new StringBuffer(url.substring(0, url.indexOf(59)));
                if (url.indexOf(63) > -1) {
                    buffer.append(url.substring(url.indexOf(63), url.length()));
                }
                url = buffer.toString();
            }
            if (url.indexOf(63) > -1) {
                this.target = url.substring(0, url.indexOf(63));
                String params = url.substring(url.indexOf(63) + 1, url.length());
                this.parameters = HttpUtils.parseQueryString((String)params);
            } else {
                this.target = url;
            }
        }
    }
}

