/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import webwork.config.Configuration;

public class XMLActionConfiguration
extends Configuration {
    Map actionMappings = null;
    Log log = LogFactory.getLog(this.getClass());
    private File file;
    private long lastModified;

    public XMLActionConfiguration(String aName) {
        URL fileUrl = Thread.currentThread().getContextClassLoader().getResource(aName + ".xml");
        if (fileUrl == null) {
            throw new IllegalArgumentException("No such XML file:" + aName + ".xml");
        }
        this.actionMappings = this.getMappingsFromResource(fileUrl);
        this.file = new File(fileUrl.getFile());
        if (!this.file.exists() || !this.file.canRead()) {
            this.file = null;
        }
        if (this.file != null) {
            this.lastModified = this.file.lastModified();
        }
    }

    private Map getMappingsFromResource(URL url) {
        HashMap<String, String> actionMap = new HashMap<String, String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document document = factory.newDocumentBuilder().parse(url.toString());
            this.log.debug((Object)("Found XML view configuration " + url));
            NodeList actions = document.getElementsByTagName("action");
            int i = 0;
            while (i < actions.getLength()) {
                Element action = (Element)actions.item(i);
                String actionName = action.getAttribute("name");
                String actionAlias = action.getAttribute("alias");
                NodeList views = action.getElementsByTagName("view");
                int j = 0;
                while (j < views.getLength()) {
                    String actionViewName;
                    Element view = (Element)views.item(j);
                    if (!view.getParentNode().equals(action)) break;
                    NodeList viewMapping = view.getChildNodes();
                    StringBuffer mapping = new StringBuffer();
                    int k = 0;
                    while (k < viewMapping.getLength()) {
                        Node mappingNode = viewMapping.item(k);
                        if (mappingNode instanceof Text) {
                            mapping.append(mappingNode.getNodeValue());
                        }
                        ++k;
                    }
                    if ("".equals(actionAlias)) {
                        actionViewName = !"".equals(actionName) ? actionName + "." + view.getAttribute("name") : view.getAttribute("name");
                    } else {
                        actionViewName = actionAlias + "." + view.getAttribute("name");
                        this.log.debug((Object)("Adding action alias " + actionAlias + "=" + actionName));
                        actionMap.put(actionAlias + ".action", actionName);
                    }
                    String actionViewMapping = mapping.toString().trim();
                    this.log.debug((Object)("Adding view mapping " + actionViewName + "=" + actionViewMapping));
                    actionMap.put(actionViewName, actionViewMapping);
                    ++j;
                }
                NodeList commands = action.getElementsByTagName("command");
                j = 0;
                while (j < commands.getLength()) {
                    Element command = (Element)commands.item(j);
                    String commandName = command.getAttribute("name");
                    String commandAlias = command.getAttribute("alias");
                    if (!commandAlias.equals("")) {
                        this.log.debug((Object)("Adding command alias " + commandAlias + "=" + actionName + "!" + commandName));
                        actionMap.put(commandAlias + ".action", actionName + "!" + commandName);
                    }
                    NodeList views2 = command.getElementsByTagName("view");
                    int k = 0;
                    while (k < views2.getLength()) {
                        Element view = (Element)views2.item(k);
                        NodeList viewMapping = view.getChildNodes();
                        StringBuffer mapping = new StringBuffer();
                        int l = 0;
                        while (l < viewMapping.getLength()) {
                            Node mappingNode = viewMapping.item(l);
                            if (mappingNode instanceof Text) {
                                mapping.append(mappingNode.getNodeValue());
                            }
                            ++l;
                        }
                        String commandViewName = commandAlias.equals("") ? (actionAlias.equals("") ? actionName + "!" + commandName + "." + view.getAttribute("name") : actionAlias + "!" + commandName + "." + view.getAttribute("name")) : commandAlias + "." + view.getAttribute("name");
                        String commandViewMapping = mapping.toString().trim();
                        this.log.debug((Object)("Adding command view mapping " + commandViewName + "=" + commandViewMapping));
                        actionMap.put(commandViewName, commandViewMapping);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SAXException e) {
            this.log.error((Object)"SAX exception", (Throwable)e);
            throw new IllegalArgumentException("Could not parse XML action configuration");
        }
        catch (IOException e) {
            this.log.error((Object)"IO exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)"Parser conf exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
        catch (DOMException e) {
            this.log.error((Object)"DOM exception", (Throwable)e);
            throw new IllegalArgumentException("Could not load XML action configuration");
        }
        return actionMap;
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        String mappingName;
        Object mapping;
        boolean reloadEnabled = false;
        if (!"webwork.configuration.xml.reload".equals(aName)) {
            try {
                reloadEnabled = "true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (reloadEnabled && this.file != null && this.lastModified < this.file.lastModified()) {
            this.lastModified = this.file.lastModified();
            this.log.debug((Object)("Reloading " + this.file));
            try {
                Map newMappings;
                this.actionMappings = newMappings = this.getMappingsFromResource(this.file.toURL());
            }
            catch (MalformedURLException e) {
                this.log.error((Object)"Something horrible happened", (Throwable)e);
            }
        }
        if ((mapping = this.actionMappings.get(mappingName = this.replaceExtension(aName))) == null) {
            throw new IllegalArgumentException("No such view mapping:" + mappingName);
        }
        return mapping;
    }

    private String replaceExtension(String actionName) {
        String ext = "." + Configuration.getString("webwork.action.extension");
        if (actionName != null && !".action".equals(ext)) {
            int idx;
            if (actionName.endsWith(ext)) {
                actionName = actionName.substring(0, actionName.lastIndexOf(ext)) + ".action";
            }
            if ((idx = actionName.indexOf(ext + "?")) > 0) {
                actionName = actionName.substring(0, idx) + ".action?" + actionName.substring(idx + ext.length() + 1);
            }
        }
        return actionName;
    }

    public void setImpl(String aName, Object aValue) {
        throw new UnsupportedOperationException("May not update XML view mapping");
    }

    public Iterator listImpl() {
        return this.actionMappings.keySet().iterator();
    }
}

