/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.LogFactory;
import webwork.config.Configuration;
import webwork.config.DelegatingConfiguration;
import webwork.config.PropertiesConfiguration;
import webwork.config.XMLActionConfiguration;

public class DefaultConfiguration
extends Configuration {
    Configuration config;

    public DefaultConfiguration() {
        String name;
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        try {
            list.add(new PropertiesConfiguration("webwork"));
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Could not find webwork.properties");
        }
        try {
            list.add(new PropertiesConfiguration("webwork/default"));
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)"Could not find webwork/default.properties", (Throwable)e);
        }
        Configuration[] configList = new Configuration[list.size()];
        this.config = new DelegatingConfiguration(list.toArray(configList));
        list = new ArrayList();
        StringTokenizer configFiles = new StringTokenizer((String)this.config.getImpl("webwork.configuration.properties"), ",");
        while (configFiles.hasMoreTokens()) {
            name = configFiles.nextToken();
            try {
                list.add(new PropertiesConfiguration(name));
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)("Could not find " + name + ".properties. Skipping"));
            }
        }
        configFiles = new StringTokenizer((String)this.config.getImpl("webwork.configuration.xml"), ",");
        while (configFiles.hasMoreTokens()) {
            name = configFiles.nextToken();
            try {
                list.add(new XMLActionConfiguration(name));
            }
            catch (IllegalArgumentException e) {
                LogFactory.getLog(this.getClass()).warn((Object)("Skipping XML action configuration for " + name + ".xml"));
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)"Could not create XML action configuration", (Throwable)e);
            }
        }
        configList = new Configuration[list.size()];
        this.config = new DelegatingConfiguration(list.toArray(configList));
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        return this.config.getImpl(aName);
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        this.config.setImpl(aName, aValue);
    }

    public Iterator listImpl() {
        return this.config.listImpl();
    }
}

