/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.test.TestDeployer;
import org.jboss.wsf.test.TestDeployerJBoss;

public class JBossWSTestHelper {
    private static Logger log = Logger.getLogger(JBossWSTestHelper.class);
    private static MBeanServerConnection server;
    private static String integrationTarget;
    private static String implVendor;
    private static String implTitle;
    private static String implVersion;
    private static LoginContext loginContext;
    private static String user;
    private static String pass;

    public void deploy(String archive) throws Exception {
        URL url = this.getArchiveURL(archive);
        this.getDeployer().deploy(url);
    }

    public void undeploy(String archive) throws Exception {
        URL url = this.getArchiveURL(archive);
        this.getDeployer().undeploy(url);
    }

    public boolean isTargetJBoss50() {
        String target = this.getIntegrationTarget();
        return "jboss50".equals(target);
    }

    public boolean isTargetJBoss42() {
        String target = this.getIntegrationTarget();
        return "jboss42".equals(target);
    }

    public boolean isTargetJBoss40() {
        String target = this.getIntegrationTarget();
        return "jboss40".equals(target);
    }

    public boolean isIntegrationNative() {
        String vendor = this.getImplementationVendor();
        return vendor.indexOf("JBoss") != -1;
    }

    public boolean isIntegrationSunRI() {
        String vendor = this.getImplementationVendor();
        return vendor.indexOf("Sun") != -1;
    }

    public boolean isIntegrationXFire() {
        String vendor = this.getImplementationVendor();
        return vendor.indexOf("Apache") != -1;
    }

    private String getImplementationVendor() {
        if (implVendor == null) {
            Service service = Service.create((QName)new QName("dummyService"));
            HandlerResolver obj = service.getHandlerResolver();
            if (obj == null) {
                service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
                obj = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
            }
            implVendor = obj.getClass().getPackage().getImplementationVendor();
            implTitle = obj.getClass().getPackage().getImplementationTitle();
            implVersion = obj.getClass().getPackage().getImplementationVersion();
            System.out.println(implVendor + ", " + implTitle + ", " + implVersion);
        }
        return implVendor;
    }

    public static String getServerHost() {
        String hostName = System.getProperty("jboss.bind.address", "localhost");
        return hostName;
    }

    public static MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    public static void login() {
        try {
            if (loginContext == null) {
                loginContext = new LoginContext("Login", new AppCallbackHandler(user, pass));
            }
            loginContext.login();
        }
        catch (LoginException le) {
            throw new RuntimeException("Cannot login to server with username:[" + user + "], password:[" + pass + "]", le);
        }
    }

    public static void logout() {
        if (loginContext != null) {
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
    }

    private TestDeployer getDeployer() {
        return new TestDeployerJBoss(JBossWSTestHelper.getServer());
    }

    public String getIntegrationTarget() {
        if (integrationTarget == null) {
            integrationTarget = System.getProperty("jbossws.integration.target");
            if (integrationTarget == null) {
                throw new IllegalStateException("Cannot obtain jbossws.integration.target");
            }
            String jbossVersion = null;
            try {
                ObjectName oname = ObjectNameFactory.create("jboss.system:type=ServerConfig");
                jbossVersion = (String)JBossWSTestHelper.getServer().getAttribute(oname, "SpecificationVersion");
                if (jbossVersion.startsWith("5.0")) {
                    jbossVersion = "jboss50";
                } else if (jbossVersion.startsWith("4.2")) {
                    jbossVersion = "jboss42";
                } else if (jbossVersion.startsWith("4.0")) {
                    jbossVersion = "jboss40";
                } else {
                    log.warn((Object)("Unsupported jboss version: " + jbossVersion));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (jbossVersion != null && !jbossVersion.equals(integrationTarget)) {
                log.warn((Object)("Integration target mismatch, using: " + integrationTarget));
            }
        }
        return integrationTarget;
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        File file;
        URL url = null;
        try {
            url = new URL(archive);
        }
        catch (MalformedURLException ignore) {
            // empty catch block
        }
        if (url == null && (file = new File(archive)).exists()) {
            url = file.toURL();
        }
        if (url == null && (file = new File("libs/" + archive)).exists()) {
            url = file.toURL();
        }
        if (url == null) {
            throw new IllegalArgumentException("Cannot obtain URL for: " + archive);
        }
        return url;
    }

    static {
        user = System.getProperty("jmx.authentication.username");
        pass = System.getProperty("jmx.authentication.password");
    }

    public static class AppCallbackHandler
    implements CallbackHandler {
        private String username;
        private String password;

        public AppCallbackHandler(String usern, String passw) {
            this.username = usern;
            this.password = passw;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    if (this.password == null) {
                        nc.setName("anonymous");
                        continue;
                    }
                    nc.setName(this.username);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    if (this.password == null) continue;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

