/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static Logger log = Logger.getLogger(DOMUtils.class);
    private static final String DISABLE_DEFERRED_NODE_EXPANSION = "org.jboss.ws.disable_deferred_node_expansion";
    private static ThreadLocal<Document> documentThreadLocal = new ThreadLocal();
    private static ThreadLocal<DocumentBuilder> builderThreadLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                boolean disableDeferredNodeExpansion = Boolean.getBoolean(DOMUtils.DISABLE_DEFERRED_NODE_EXPANSION);
                if (disableDeferredNodeExpansion) {
                    factory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                }
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.setEntityResolver(builder);
                return builder;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }

        private void setEntityResolver(DocumentBuilder builder) {
            String[] resolvers = new String[]{"org.jboss.ws.core.utils.JBossWSEntityResolver", "org.jboss.util.xml.JBossEntityResolver"};
            EntityResolver entityResolver = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (String resolver : resolvers) {
                try {
                    Class<?> resolverClass = loader.loadClass(resolver);
                    entityResolver = (EntityResolver)resolverClass.newInstance();
                }
                catch (Exception ex) {
                    log.debug((Object)("Cannot load: " + resolver));
                }
            }
            if (entityResolver != null) {
                builder.setEntityResolver(entityResolver);
            }
        }
    };

    public static void clearThreadLocals() {
        documentThreadLocal.remove();
        builderThreadLocal.remove();
    }

    private DOMUtils() {
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = builderThreadLocal.get();
        return builder;
    }

    public static Element parse(String xmlString) throws IOException {
        try {
            return DOMUtils.parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
        }
        catch (IOException e) {
            log.error((Object)("Cannot parse: " + xmlString));
            throw e;
        }
    }

    public static Element parse(InputStream xmlStream) throws IOException {
        try {
            Document doc = DOMUtils.getDocumentBuilder().parse(xmlStream);
            Element root = doc.getDocumentElement();
            return root;
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    public static Element parse(InputSource source) throws IOException {
        try {
            Document doc = DOMUtils.getDocumentBuilder().parse(source);
            Element root = doc.getDocumentElement();
            return root;
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    public static Element createElement(String localPart) {
        Document doc = DOMUtils.getOwnerDocument();
        log.trace((Object)("createElement {}" + localPart));
        return doc.createElement(localPart);
    }

    public static Element createElement(String localPart, String prefix) {
        Document doc = DOMUtils.getOwnerDocument();
        log.trace((Object)("createElement {}" + prefix + ":" + localPart));
        return doc.createElement(prefix + ":" + localPart);
    }

    public static Element createElement(String localPart, String prefix, String uri) {
        Document doc = DOMUtils.getOwnerDocument();
        if (prefix == null || prefix.length() == 0) {
            log.trace((Object)("createElement {" + uri + "}" + localPart));
            return doc.createElementNS(uri, localPart);
        }
        log.trace((Object)("createElement {" + uri + "}" + prefix + ":" + localPart));
        return doc.createElementNS(uri, prefix + ":" + localPart);
    }

    public static Element createElement(QName qname) {
        return DOMUtils.createElement(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
    }

    public static Text createTextNode(String value) {
        Document doc = DOMUtils.getOwnerDocument();
        return doc.createTextNode(value);
    }

    public static QName getElementQName(Element el) {
        String qualifiedName = el.getNodeName();
        return DOMUtils.resolveQName(el, qualifiedName);
    }

    public static QName resolveQName(Element el, String qualifiedName) {
        String prefix = "";
        String namespaceURI = "";
        String localPart = qualifiedName;
        int colIndex = qualifiedName.indexOf(":");
        if (colIndex > 0) {
            prefix = qualifiedName.substring(0, colIndex);
            localPart = qualifiedName.substring(colIndex + 1);
            if ("xmlns".equals(prefix)) {
                namespaceURI = "URI:XML_PREDEFINED_NAMESPACE";
            } else {
                Element nsElement = el;
                while (namespaceURI.equals("") && nsElement != null) {
                    namespaceURI = nsElement.getAttribute("xmlns:" + prefix);
                    if (!namespaceURI.equals("")) continue;
                    nsElement = DOMUtils.getParentElement(nsElement);
                }
            }
            if (namespaceURI.equals("")) {
                throw new IllegalArgumentException("Cannot find namespace uri for: " + qualifiedName);
            }
        } else {
            Element nsElement = el;
            while (namespaceURI.equals("") && nsElement != null) {
                namespaceURI = nsElement.getAttribute("xmlns");
                if (!namespaceURI.equals("")) continue;
                nsElement = DOMUtils.getParentElement(nsElement);
            }
        }
        QName qname = new QName(namespaceURI, localPart, prefix);
        return qname;
    }

    public static String getAttributeValue(Element el, String attrName) {
        return DOMUtils.getAttributeValue(el, new QName(attrName));
    }

    public static String getAttributeValue(Element el, QName attrName) {
        String attr = null;
        attr = "".equals(attrName.getNamespaceURI()) ? el.getAttribute(attrName.getLocalPart()) : el.getAttributeNS(attrName.getNamespaceURI(), attrName.getLocalPart());
        if ("".equals(attr)) {
            attr = null;
        }
        return attr;
    }

    public static QName getAttributeValueAsQName(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsQName(el, new QName(attrName));
    }

    public static QName getAttributeValueAsQName(Element el, QName attrName) {
        QName qname = null;
        String qualifiedName = DOMUtils.getAttributeValue(el, attrName);
        if (qualifiedName != null) {
            qname = DOMUtils.resolveQName(el, qualifiedName);
        }
        return qname;
    }

    public static boolean getAttributeValueAsBoolean(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsBoolean(el, new QName(attrName));
    }

    public static boolean getAttributeValueAsBoolean(Element el, QName attrName) {
        String attrVal = DOMUtils.getAttributeValue(el, attrName);
        boolean ret = "true".equalsIgnoreCase(attrVal) || "1".equalsIgnoreCase(attrVal);
        return ret;
    }

    public static Integer getAttributeValueAsInteger(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsInteger(el, new QName(attrName));
    }

    public static Integer getAttributeValueAsInteger(Element el, QName attrName) {
        String attrVal = DOMUtils.getAttributeValue(el, attrName);
        return attrVal != null ? new Integer(attrVal) : null;
    }

    public static Map getAttributes(Element el) {
        HashMap<QName, String> attmap = new HashMap<QName, String>();
        NamedNodeMap attribs = el.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            String name = attr.getName();
            QName qname = DOMUtils.resolveQName(el, name);
            String value = attr.getNodeValue();
            attmap.put(qname, value);
        }
        return attmap;
    }

    public static void copyAttributes(Element destElement, Element srcElement) {
        NamedNodeMap attribs = srcElement.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            String uri = attr.getNamespaceURI();
            String qname = attr.getName();
            String value = attr.getNodeValue();
            if (uri == null && qname.startsWith("xmlns")) {
                log.trace((Object)("Ignore attribute: [uri=" + uri + ",qname=" + qname + ",value=" + value + "]"));
                continue;
            }
            destElement.setAttributeNS(uri, qname, value);
        }
    }

    public static boolean hasChildElements(Node node) {
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Iterator getChildElements(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            list.add(child);
        }
        return list.iterator();
    }

    public static String getTextContent(Node node) {
        boolean hasTextContent = false;
        StringBuffer buffer = new StringBuffer();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 3) continue;
            buffer.append(child.getNodeValue());
            hasTextContent = true;
        }
        return hasTextContent ? buffer.toString() : null;
    }

    public static Element getFirstChildElement(Node node) {
        return DOMUtils.getFirstChildElementIntern(node, null);
    }

    public static Element getFirstChildElement(Node node, String nodeName) {
        return DOMUtils.getFirstChildElementIntern(node, new QName(nodeName));
    }

    public static Element getFirstChildElement(Node node, QName nodeName) {
        return DOMUtils.getFirstChildElementIntern(node, nodeName);
    }

    private static Element getFirstChildElementIntern(Node node, QName nodeName) {
        Element childElement = null;
        Iterator it = DOMUtils.getChildElementsIntern(node, nodeName);
        if (it.hasNext()) {
            childElement = (Element)it.next();
        }
        return childElement;
    }

    public static Iterator getChildElements(Node node, String nodeName) {
        return DOMUtils.getChildElementsIntern(node, new QName(nodeName));
    }

    public static Iterator getChildElements(Node node, QName nodeName) {
        return DOMUtils.getChildElementsIntern(node, nodeName);
    }

    private static Iterator getChildElementsIntern(Node node, QName nodeName) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            if (nodeName == null) {
                list.add(child);
                continue;
            }
            QName qname = nodeName.getNamespaceURI().length() > 0 ? new QName(child.getNamespaceURI(), child.getLocalName()) : new QName(child.getLocalName());
            if (!qname.equals(nodeName)) continue;
            list.add(child);
        }
        return list.iterator();
    }

    public static Element getParentElement(Node node) {
        Node parent = node.getParentNode();
        return parent instanceof Element ? (Element)parent : null;
    }

    public static Document peekOwnerDocument() {
        return documentThreadLocal.get();
    }

    public static void setOwnerDocument(Document doc) {
        documentThreadLocal.set(doc);
    }

    public static Document getOwnerDocument() {
        Document doc = documentThreadLocal.get();
        if (doc == null) {
            doc = DOMUtils.getDocumentBuilder().newDocument();
            documentThreadLocal.set(doc);
        }
        return doc;
    }

    public static Element sourceToElement(Source source) throws IOException {
        Element retElement;
        block9: {
            retElement = null;
            try {
                if (source instanceof StreamSource) {
                    StreamSource streamSource = (StreamSource)source;
                    InputStream ins = streamSource.getInputStream();
                    if (ins != null) {
                        retElement = DOMUtils.parse(ins);
                    } else {
                        Reader reader = streamSource.getReader();
                        retElement = DOMUtils.parse(new InputSource(reader));
                    }
                    break block9;
                }
                if (source instanceof DOMSource) {
                    DOMSource domSource = (DOMSource)source;
                    Node node = domSource.getNode();
                    if (node instanceof Element) {
                        retElement = (Element)node;
                        break block9;
                    }
                    if (node instanceof Document) {
                        retElement = ((Document)node).getDocumentElement();
                        break block9;
                    }
                    throw new RuntimeException("Unsupported Node type: " + node.getClass().getName());
                }
                if (source instanceof SAXSource) {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    Transformer transformer = tf.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(source, new StreamResult(baos));
                    retElement = DOMUtils.parse(new ByteArrayInputStream(baos.toByteArray()));
                    break block9;
                }
                throw new RuntimeException("Source type not implemented: " + source.getClass().getName());
            }
            catch (TransformerException ex) {
                IOException ioex = new IOException();
                ioex.initCause(ex);
                throw ioex;
            }
        }
        return retElement;
    }
}

