/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import java.sql.SQLException;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;

class Function {
    private Channel cChannel;
    private String sFunction;
    private Method mMethod;
    private int iReturnType;
    private int iArgCount;
    private int[] iArgType;
    private boolean[] bArgNullable;
    private Object[] oArg;
    private Expression[] eArg;
    private boolean bConnection;

    Function(String function, Channel channel) throws SQLException {
        this.cChannel = channel;
        this.sFunction = function;
        int i = function.lastIndexOf(46);
        Trace.check(i != -1, 10, function);
        String classname = function.substring(0, i);
        channel.check("CLASS \"" + classname + "\"", 15);
        String methodname = function.substring(i + 1);
        Class<?> classinstance = null;
        try {
            classinstance = Class.forName(classname);
        }
        catch (Exception e) {
            throw Trace.error(40, classname + " " + e);
        }
        Method[] method = classinstance.getMethods();
        i = 0;
        while (i < method.length) {
            Method m = method[i];
            if (m.getName().equals(methodname)) {
                Trace.check(this.mMethod == null, 12, methodname);
                this.mMethod = m;
            }
            ++i;
        }
        Trace.check(this.mMethod != null, 12, methodname);
        Class<?> returnclass = this.mMethod.getReturnType();
        this.iReturnType = Column.getTypeNr(returnclass.getName());
        Class<?>[] arg = this.mMethod.getParameterTypes();
        this.iArgCount = arg.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        i = 0;
        while (i < arg.length) {
            Class<?> a = arg[i];
            String type = a.getName();
            if (i == 0 && type.equals("java.sql.Connection")) {
                this.bConnection = true;
            } else {
                if (type.equals("[B")) {
                    type = "byte[]";
                }
                this.iArgType[i] = Column.getTypeNr(type);
                this.bArgNullable[i] = !a.isPrimitive();
            }
            ++i;
        }
        this.eArg = new Expression[this.iArgCount];
        this.oArg = new Object[this.iArgCount];
    }

    Object getValue() throws SQLException {
        int i = 0;
        if (this.bConnection) {
            this.oArg[i] = new jdbcConnection(this.cChannel);
            ++i;
        }
        while (i < this.iArgCount) {
            Expression e = this.eArg[i];
            Object o = null;
            if (e != null) {
                o = e.getValue(this.iArgType[i]);
            }
            if (o == null && !this.bArgNullable[i]) {
                return null;
            }
            this.oArg[i] = o;
            ++i;
        }
        try {
            return this.mMethod.invoke(null, this.oArg);
        }
        catch (Exception e) {
            String s = this.sFunction + ": " + e.toString();
            throw Trace.getError(19, s);
        }
    }

    int getArgCount() {
        return this.iArgCount - (this.bConnection ? 1 : 0);
    }

    void resolve(TableFilter f) throws SQLException {
        int i = 0;
        while (i < this.iArgCount) {
            if (this.eArg[i] != null) {
                this.eArg[i].resolve(f);
            }
            ++i;
        }
    }

    void checkResolved() throws SQLException {
        int i = 0;
        while (i < this.iArgCount) {
            if (this.eArg[i] != null) {
                this.eArg[i].checkResolved();
            }
            ++i;
        }
    }

    int getArgType(int i) {
        return this.iArgType[i];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    void setArgument(int i, Expression e) {
        if (this.bConnection) {
            ++i;
        }
        this.eArg[i] = e;
    }
}

