/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.util.Stack;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.login.Configuration;
import org.jboss.security.plugins.SecurityConfigMBean;
import org.jboss.system.ServiceMBeanSupport;

public class SecurityConfig
extends ServiceMBeanSupport
implements SecurityConfigMBean {
    private String loginConfigName;
    private Stack loginConfigStack = new Stack();

    public String getName() {
        return "SecurityIntialization";
    }

    public String getLoginConfig() {
        return this.loginConfigName;
    }

    public void setLoginConfig(String name) throws MalformedObjectNameException {
        this.loginConfigName = name;
    }

    public void startService() throws Exception {
        this.pushLoginConfig(this.loginConfigName);
    }

    public void stopService() throws Exception {
        if (!this.loginConfigStack.empty()) {
            this.popLoginConfig();
        }
    }

    public synchronized void pushLoginConfig(String objectName) throws JMException, MalformedObjectNameException {
        ObjectName name = new ObjectName(objectName);
        Configuration prevConfig = null;
        if (!this.loginConfigStack.empty()) {
            ConfigInfo prevInfo = (ConfigInfo)this.loginConfigStack.peek();
            prevConfig = prevInfo.config;
        }
        ConfigInfo info = this.installConfig(name, prevConfig);
        this.loginConfigStack.push(info);
    }

    public synchronized void popLoginConfig() throws JMException {
        ConfigInfo info = (ConfigInfo)this.loginConfigStack.pop();
        Configuration prevConfig = null;
        if (!this.loginConfigStack.empty()) {
            ConfigInfo prevInfo = (ConfigInfo)this.loginConfigStack.peek();
            prevConfig = prevInfo.config;
        }
        this.installConfig(info.name, prevConfig);
    }

    private ConfigInfo installConfig(ObjectName name, Configuration prevConfig) throws JMException {
        MBeanServer server = super.getServer();
        Object[] args = new Object[]{prevConfig};
        String[] signature = new String[]{"javax.security.auth.login.Configuration"};
        Configuration config = (Configuration)server.invoke(name, "getConfiguration", args, signature);
        Configuration.setConfiguration(config);
        ConfigInfo info = new ConfigInfo(name, config);
        this.log.debug("Installed JAAS Configuration service=" + name + ", config=" + config);
        return info;
    }

    static class ConfigInfo {
        ObjectName name;
        Configuration config;

        ConfigInfo(ObjectName name, Configuration config) {
            this.name = name;
            this.config = config;
        }
    }
}

