/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;

class SecurityAssociationActions {
    SecurityAssociationActions() {
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static void popPrincipalInfo() {
        PopPrincipalInfoAction action = new PopPrincipalInfoAction();
        AccessController.doPrivileged(action);
    }

    static void setServer() {
        AccessController.doPrivileged(SetServerAction.ACTION);
    }

    static void clear() {
        AccessController.doPrivileged(ClearAction.ACTION);
    }

    static Subject getSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static Principal getPrincipal() {
        Principal principal = (Principal)AccessController.doPrivileged(GetPrincipalAction.ACTION);
        return principal;
    }

    static Object getCredential() {
        Object credential = AccessController.doPrivileged(GetCredentialAction.ACTION);
        return credential;
    }

    private static class GetCredentialAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetCredentialAction();

        private GetCredentialAction() {
        }

        public Object run() {
            Object credential = SecurityAssociation.getCredential();
            return credential;
        }
    }

    private static class GetPrincipalAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetPrincipalAction();

        private GetPrincipalAction() {
        }

        public Object run() {
            Principal principal = SecurityAssociation.getPrincipal();
            return principal;
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }

    private static class ClearAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new ClearAction();

        private ClearAction() {
        }

        public Object run() {
            SecurityAssociation.clear();
            return null;
        }
    }

    private static class SetServerAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new SetServerAction();

        private SetServerAction() {
        }

        public Object run() {
            SecurityAssociation.setServer();
            return null;
        }
    }

    private static class PopPrincipalInfoAction
    implements PrivilegedAction {
        private PopPrincipalInfoAction() {
        }

        public Object run() {
            SecurityAssociation.popSubjectContext();
            return null;
        }
    }

    private static class SetPrincipalInfoAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;
        Subject subject;

        SetPrincipalInfoAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        public Object run() {
            SecurityAssociation.pushSubjectContext(this.subject, this.principal, this.credential);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

