/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.jrmp.server.JRMPProxyFactoryMBean;
import org.jboss.naming.ENCFactory;
import org.jboss.naming.NamingServiceMBean;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.util.threadpool.ThreadPool;
import org.jnp.interfaces.MarshalledValuePair;
import org.jnp.interfaces.Naming;
import org.jnp.server.Main;

public class NamingService
extends ServiceMBeanSupport
implements NamingServiceMBean {
    private Main naming;
    private Map marshalledInvocationMapping = new HashMap();
    private JRMPProxyFactoryMBean proxyFactory;

    public NamingService() {
        this.naming = new Main(this.getClass().getName());
    }

    public void setLookupPool(BasicThreadPoolMBean poolMBean) {
        ThreadPool lookupPool = poolMBean.getInstance();
        this.naming.setLookupPool(lookupPool);
    }

    public boolean getCallByValue() {
        return !MarshalledValuePair.getEnableCallByReference();
    }

    public void setCallByValue(boolean flag) {
        boolean callByValue = !flag;
        MarshalledValuePair.setEnableCallByReference(callByValue);
    }

    public void setPort(int port) {
        this.naming.setPort(port);
    }

    public int getPort() {
        return this.naming.getPort();
    }

    public void setRmiPort(int port) {
        this.naming.setRmiPort(port);
    }

    public int getRmiPort() {
        return this.naming.getRmiPort();
    }

    public String getBindAddress() {
        return this.naming.getBindAddress();
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.naming.setBindAddress(host);
    }

    public String getRmiBindAddress() {
        return this.naming.getRmiBindAddress();
    }

    public void setRmiBindAddress(String host) throws UnknownHostException {
        this.naming.setRmiBindAddress(host);
    }

    public int getBacklog() {
        return this.naming.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.naming.setBacklog(backlog);
    }

    public boolean getInstallGlobalService() {
        return this.naming.getInstallGlobalService();
    }

    public void setInstallGlobalService(boolean flag) {
        this.naming.setInstallGlobalService(flag);
    }

    public String getClientSocketFactory() {
        return this.naming.getClientSocketFactory();
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.naming.setClientSocketFactory(factoryClassName);
    }

    public String getServerSocketFactory() {
        return this.naming.getServerSocketFactory();
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.naming.setServerSocketFactory(factoryClassName);
    }

    public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.naming.setJNPServerSocketFactory(factoryClassName);
    }

    public void setInvokerProxyFactory(JRMPProxyFactoryMBean proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void createAlias(String fromName, String toName) throws Exception {
        Util.createLinkRef(fromName, toName);
        this.log.info("Created alias " + fromName + "->" + toName);
    }

    public void removeAlias(String name) throws Exception {
        this.log.info("Removing alias " + name);
        Util.removeLinkRef(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream("jndi.properties");
        if (is == null) {
            throw new RuntimeException("Cannot find jndi.properties, it should be at conf/jndi.properties by default.");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            this.log.debug("System.setProperty, key=" + key + ", value=" + value);
            System.setProperty(key, value);
        }
        if (this.proxyFactory != null) {
            this.naming.setNamingProxy(this.proxyFactory.getProxy());
        }
        this.naming.start();
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        this.log.debug("InitialContext Environment: ");
        Object providerURL = null;
        Enumeration<?> keys2 = env.keys();
        while (keys2.hasMoreElements()) {
            Object key = keys2.nextElement();
            Object value = env.get(key);
            String type = value == null ? "" : value.getClass().getName();
            this.log.debug("key=" + key + ", value(" + type + ")=" + value);
            if (!key.equals("java.naming.provider.url")) continue;
            providerURL = value;
        }
        if (providerURL != null) {
            this.log.warn("Context.PROVIDER_URL in server jndi.properties, url=" + providerURL);
        }
        ClassLoader topLoader = Thread.currentThread().getContextClassLoader();
        ENCFactory.setTopClassLoader(topLoader);
        StringRefAddr refAddr = new StringRefAddr("nns", "ENC");
        Reference envRef = new Reference("javax.naming.Context", refAddr, ENCFactory.class.getName(), null);
        Context ctx = (Context)iniCtx.lookup("java:");
        ctx.rebind("comp", (Object)envRef);
        this.log.debug("Listening on port " + this.naming.getPort());
        ctx.close();
        iniCtx.close();
        HashMap<Long, Method> tmpMap = new HashMap<Long, Method>(13);
        Method[] methods = Naming.class.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method method = methods[m];
            Long hash = new Long(MarshalledInvocation.calculateHash(method));
            tmpMap.put(hash, method);
        }
        this.marshalledInvocationMapping = Collections.unmodifiableMap(tmpMap);
    }

    protected void stopService() throws Exception {
        this.naming.stop();
        this.log.debug("JNP server stopped");
    }

    protected Main getNamingServer() {
        return this.naming;
    }

    public Map getMethodMap() {
        return this.marshalledInvocationMapping;
    }

    public Object invoke(Invocation invocation) throws Exception {
        Naming theServer = this.naming.getServer();
        if (invocation instanceof MarshalledInvocation) {
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            mi.setMethodMap(this.marshalledInvocationMapping);
        }
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        Object value = null;
        try {
            value = method.invoke((Object)theServer, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t, method.toString());
        }
        return value;
    }
}

