/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.server;

import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.pooled.interfaces.PooledInvokerProxy;
import org.jboss.invocation.pooled.interfaces.PooledMarshalledInvocation;
import org.jboss.invocation.pooled.interfaces.ServerAddress;
import org.jboss.invocation.pooled.server.LRUPool;
import org.jboss.invocation.pooled.server.PooledInvokerMBean;
import org.jboss.invocation.pooled.server.ServerThread;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.jboss.proxy.TransactionInterceptor;
import org.jboss.security.SecurityDomain;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.jboss.tm.TransactionPropagationContextUtil;
import org.jboss.util.UnreachableStatementException;

public class PooledInvoker
extends ServiceMBeanSupport
implements PooledInvokerMBean,
Runnable {
    protected static final Logger log = Logger.getLogger(PooledInvoker.class);
    protected boolean enableTcpNoDelay = false;
    protected String serverBindAddress = null;
    protected int serverBindPort = 0;
    protected String clientConnectAddress = null;
    protected int clientConnectPort = 0;
    protected int clientRetryCount = 1;
    protected int backlog = 200;
    protected String clientSocketFactoryName;
    protected String serverSocketFactoryName;
    protected SocketFactory clientSocketFactory;
    protected ServerSocketFactory serverSocketFactory;
    protected ServerSocket serverSocket = null;
    protected String sslDomain;
    protected int timeout = 60000;
    protected int maxPoolSize = 300;
    protected int clientMaxPoolSize = 300;
    protected int numAcceptThreads = 1;
    protected Thread[] acceptThreads;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected boolean running = true;
    protected boolean trace = false;
    protected ObjectName transactionManagerService;
    protected PooledInvokerProxy optimizedInvokerProxy = null;
    private MBeanServerAction serverAction = new MBeanServerAction();
    protected static TransactionPropagationContextFactory tpcFactory;
    protected static TransactionPropagationContextImporter tpcImporter;

    protected void jmxBind() {
        Registry.bind(this.getServiceName(), this.optimizedInvokerProxy);
    }

    public void startService() throws Exception {
        this.trace = log.isTraceEnabled();
        InitialContext ctx = new InitialContext();
        tpcFactory = TransactionPropagationContextUtil.getTPCFactory();
        tpcImporter = TransactionPropagationContextUtil.getTPCImporter();
        TransactionInterceptor.setTransactionManager((TransactionManager)ctx.lookup("java:/TransactionManager"));
        InetAddress bindAddress = this.serverBindAddress == null || this.serverBindAddress.length() == 0 ? null : InetAddress.getByName(this.serverBindAddress);
        this.clientConnectAddress = this.clientConnectAddress == null || this.clientConnectAddress.length() == 0 ? InetAddress.getLocalHost().getHostName() : this.clientConnectAddress;
        this.clientConnectAddress = ServerConfigUtil.fixRemoteAddress(this.clientConnectAddress);
        this.loadCustomSocketFactories();
        this.clientpool = new LRUPool(2, this.maxPoolSize);
        this.clientpool.create();
        this.threadpool = new LinkedList();
        try {
            this.serverSocket = this.serverSocketFactory != null ? this.serverSocketFactory.createServerSocket(this.serverBindPort, this.backlog, bindAddress) : new ServerSocket(this.serverBindPort, this.backlog, bindAddress);
        }
        catch (BindException be) {
            throw new Exception("Port " + this.serverBindPort + " is already in use", be);
        }
        this.serverBindPort = this.serverSocket.getLocalPort();
        this.clientConnectPort = this.clientConnectPort == 0 ? this.serverSocket.getLocalPort() : this.clientConnectPort;
        ServerAddress sa = new ServerAddress(this.clientConnectAddress, this.clientConnectPort, this.enableTcpNoDelay, this.timeout, this.clientSocketFactory);
        this.optimizedInvokerProxy = new PooledInvokerProxy(sa, this.clientMaxPoolSize, this.clientRetryCount);
        this.jmxBind();
        log.debug("Bound invoker for JMX node");
        ctx.close();
        this.acceptThreads = new Thread[this.numAcceptThreads];
        for (int i = 0; i < this.numAcceptThreads; ++i) {
            String name = "PooledInvokerAcceptor#" + i + "-" + this.serverBindPort;
            this.acceptThreads[i] = new Thread((Runnable)this, name);
            this.acceptThreads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            try {
                Object object;
                Socket socket = this.serverSocket.accept();
                if (this.trace) {
                    log.trace("Accepted: " + socket);
                }
                ServerThread thread = null;
                boolean newThread = false;
                while (thread == null) {
                    object = this.threadpool;
                    synchronized (object) {
                        if (this.threadpool.size() > 0) {
                            thread = (ServerThread)this.threadpool.removeFirst();
                        }
                    }
                    if (thread != null) continue;
                    object = this.clientpool;
                    synchronized (object) {
                        if (this.clientpool.size() < this.maxPoolSize) {
                            thread = new ServerThread(socket, this, this.clientpool, this.threadpool, this.timeout);
                            newThread = true;
                        }
                        if (thread == null) {
                            this.clientpool.evict();
                            if (this.trace) {
                                log.trace("Waiting for a thread...");
                            }
                            this.clientpool.wait();
                            if (this.trace) {
                                log.trace("Notified of available thread");
                            }
                        }
                    }
                }
                object = this.clientpool;
                synchronized (object) {
                    this.clientpool.insert(thread, thread);
                }
                if (newThread) {
                    if (this.trace) {
                        log.trace("Created a new thread, t=" + thread);
                    }
                    thread.start();
                    continue;
                }
                if (this.trace) {
                    log.trace("Reusing thread t=" + thread);
                }
                thread.wakeup(socket, this.timeout);
            }
            catch (Throwable ex) {
                if (!this.running) continue;
                log.error("Failed to accept socket connection", ex);
            }
        }
    }

    public void stopService() throws Exception {
        int i;
        this.running = false;
        this.maxPoolSize = 0;
        for (i = 0; i < this.acceptThreads.length; ++i) {
            try {
                this.acceptThreads[i].interrupt();
                continue;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        this.clientpool.flush();
        for (i = 0; i < this.threadpool.size(); ++i) {
            ServerThread thread = (ServerThread)this.threadpool.removeFirst();
            thread.shutdown();
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void destroyService() throws Exception {
        Registry.unbind(this.getServiceName());
    }

    public Object invoke(Invocation invocation) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCl = currentThread.getContextClassLoader();
        try {
            Object obj;
            PooledMarshalledInvocation mi = (PooledMarshalledInvocation)invocation;
            invocation.setTransaction(this.importTPC(mi.getTransactionPropagationContext()));
            ObjectName mbean = (ObjectName)Registry.lookup(invocation.getObjectName());
            Object object = obj = this.serverAction.invoke(mbean, "invoke", new Object[]{invocation}, Invocation.INVOKE_SIGNATURE);
            return object;
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow(e);
            throw new UnreachableStatementException();
        }
        finally {
            currentThread.setContextClassLoader(oldCl);
        }
    }

    protected Transaction importTPC(Object tpc) {
        if (tpc != null) {
            return tpcImporter.importTransactionPropagationContext(tpc);
        }
        return null;
    }

    public int getNumAcceptThreads() {
        return this.numAcceptThreads;
    }

    public void setNumAcceptThreads(int size) {
        this.numAcceptThreads = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getClientMaxPoolSize() {
        return this.clientMaxPoolSize;
    }

    public void setClientMaxPoolSize(int clientMaxPoolSize) {
        this.clientMaxPoolSize = clientMaxPoolSize;
    }

    public int getSocketTimeout() {
        return this.timeout;
    }

    public void setSocketTimeout(int time) {
        this.timeout = time;
    }

    public int getCurrentClientPoolSize() {
        return this.clientpool.size();
    }

    public int getCurrentThreadPoolSize() {
        return this.threadpool.size();
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public String getClientConnectAddress() {
        return this.clientConnectAddress;
    }

    public void setClientConnectAddress(String clientConnectAddress) {
        this.clientConnectAddress = clientConnectAddress;
    }

    public int getClientConnectPort() {
        return this.clientConnectPort;
    }

    public void setClientConnectPort(int clientConnectPort) {
        this.clientConnectPort = clientConnectPort;
    }

    public int getClientRetryCount() {
        return this.clientRetryCount;
    }

    public void setClientRetryCount(int clientRetryCount) {
        this.clientRetryCount = clientRetryCount;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public boolean isEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    public void setServerBindAddress(String serverBindAddress) {
        this.serverBindAddress = serverBindAddress;
    }

    public String getClientSocketFactoryName() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactoryName(String clientSocketFactoryName) {
        this.clientSocketFactoryName = clientSocketFactoryName;
    }

    public String getServerSocketFactoryName() {
        return this.serverSocketFactoryName;
    }

    public void setServerSocketFactoryName(String serverSocketFactoryName) {
        this.serverSocketFactoryName = serverSocketFactoryName;
    }

    public SocketFactory getClientSocketFactory() {
        return this.clientSocketFactory;
    }

    public void setClientSocketFactory(SocketFactory clientSocketFactory) {
        this.clientSocketFactory = clientSocketFactory;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public String getSslDomain() {
        return this.sslDomain;
    }

    public void setSslDomain(String sslDomain) {
        this.sslDomain = sslDomain;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public ObjectName getTransactionManagerService() {
        return this.transactionManagerService;
    }

    public void setTransactionManagerService(ObjectName transactionManagerService) {
        this.transactionManagerService = transactionManagerService;
    }

    public PooledInvokerProxy getOptimizedInvokerProxy() {
        return this.optimizedInvokerProxy;
    }

    protected void loadCustomSocketFactories() {
        block17: {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                if (this.clientSocketFactoryName != null) {
                    Class<?> csfClass = loader.loadClass(this.clientSocketFactoryName);
                    this.clientSocketFactory = (SocketFactory)csfClass.newInstance();
                }
            }
            catch (Exception e) {
                log.error("Failed to load client socket factory", e);
                this.clientSocketFactory = null;
            }
            try {
                if (this.serverSocketFactory != null) break block17;
                if (this.serverSocketFactoryName != null) {
                    Class<?> ssfClass = loader.loadClass(this.serverSocketFactoryName);
                    this.serverSocketFactory = (ServerSocketFactory)ssfClass.newInstance();
                    if (this.serverBindAddress != null) {
                        try {
                            Class[] parameterTypes = new Class[]{String.class};
                            Method m = ssfClass.getMethod("setBindAddress", parameterTypes);
                            Object[] args = new Object[]{this.serverBindAddress};
                            m.invoke((Object)this.serverSocketFactory, args);
                        }
                        catch (NoSuchMethodException e) {
                            log.warn("Socket factory does not support setBindAddress(String)");
                        }
                        catch (Exception e) {
                            log.warn("Failed to setBindAddress=" + this.serverBindAddress + " on socket factory", e);
                        }
                    }
                    if (this.sslDomain != null) {
                        try {
                            InitialContext ctx = new InitialContext();
                            SecurityDomain domain = (SecurityDomain)ctx.lookup(this.sslDomain);
                            Class[] parameterTypes = new Class[]{SecurityDomain.class};
                            Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                            Object[] args = new Object[]{domain};
                            m.invoke((Object)this.serverSocketFactory, args);
                        }
                        catch (NoSuchMethodException e) {
                            log.error("Socket factory does not support setSecurityDomain(SecurityDomain)");
                        }
                        catch (Exception e) {
                            log.error("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory", e);
                        }
                    }
                    break block17;
                }
                if (this.serverBindAddress != null) {
                    DefaultSocketFactory defaultFactory = new DefaultSocketFactory(this.backlog);
                    this.serverSocketFactory = defaultFactory;
                    try {
                        defaultFactory.setBindAddress(this.serverBindAddress);
                    }
                    catch (UnknownHostException e) {
                        log.error("Failed to setBindAddress=" + this.serverBindAddress + " on socket factory", e);
                    }
                }
            }
            catch (Exception e) {
                log.error("operation failed", e);
                this.serverSocketFactory = null;
            }
        }
    }

    class MBeanServerAction
    implements PrivilegedExceptionAction {
        private ObjectName target;
        String method;
        Object[] args;
        String[] sig;

        MBeanServerAction() {
        }

        MBeanServerAction(ObjectName target, String method, Object[] args, String[] sig) {
            this.target = target;
            this.method = method;
            this.args = args;
            this.sig = sig;
        }

        public Object run() throws Exception {
            Object rtnValue = PooledInvoker.this.server.invoke(this.target, this.method, this.args, this.sig);
            return rtnValue;
        }

        Object invoke(ObjectName target, String method, Object[] args, String[] sig) throws Exception {
            SecurityManager sm = System.getSecurityManager();
            Object rtnValue = null;
            if (sm == null) {
                rtnValue = PooledInvoker.this.server.invoke(target, method, args, sig);
            } else {
                try {
                    MBeanServerAction action = new MBeanServerAction(target, method, args, sig);
                    rtnValue = AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    throw ex;
                }
            }
            return rtnValue;
        }
    }
}

