/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import javax.ejb.EJBObject;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.stateless.StatelessHandleImpl;
import org.jboss.ejb3.stateless.StatelessRemoteProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

public class StatelessRemoteProxyFactory
extends BaseStatelessProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessRemoteProxyFactory.class);
    protected RemoteBinding binding;
    protected InvokerLocator locator;

    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class[] getInterfaces() {
        Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this.container);
        Class[] interfaces = new Class[remoteInterfaces.length + 2];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        interfaces[remoteInterfaces.length + 1] = EJBObject.class;
        return interfaces;
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.container, this.binding);
    }

    public void init() throws Exception {
        super.init();
        String clientBindUrl = this.binding.clientBindUrl();
        this.locator = new InvokerLocator(clientBindUrl);
    }

    public void start() throws Exception {
        super.start();
        StatelessContainer statelessContainer = (StatelessContainer)this.container;
        RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null) {
            Object homeProxy = this.createHomeProxy(remoteHome.value());
            try {
                Util.bind((Context)this.container.getInitialContext(), this.jndiName + "Home", homeProxy);
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind stateless home proxy with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName + "Home");
                namingException.setRootCause(e);
                throw namingException;
            }
        }
    }

    public void stop() throws Exception {
        super.stop();
        StatelessContainer statelessContainer = (StatelessContainer)this.container;
        RemoteHome remoteHome = (RemoteHome)statelessContainer.resolveAnnotation(RemoteHome.class);
        if (remoteHome != null) {
            Util.unbind((Context)this.container.getInitialContext(), this.jndiName + "Home");
        }
    }

    protected StatelessHandleImpl getHandle() {
        StatelessHandleImpl handle = new StatelessHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)this.advisor.resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    public Object createHomeProxy(Class homeInterface) {
        try {
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "StatelessSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            StatelessRemoteProxy proxy = new StatelessRemoteProxy(containerId, stack.createInterceptors((Advisor)((Object)this.container), null), this.locator);
            this.setEjb21Objects(proxy);
            Class[] interfaces = new Class[]{homeInterface};
            return Proxy.newProxyInstance(this.container.getBeanClass().getClassLoader(), interfaces, (InvocationHandler)proxy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Object createProxy() {
        try {
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "StatelessSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            StatelessRemoteProxy proxy = new StatelessRemoteProxy(containerId, stack.createInterceptors((Advisor)((Object)this.container), null), this.locator);
            this.setEjb21Objects(proxy);
            Object[] args = new Object[]{proxy};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }
}

