/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.MetaDataLibraryMBean;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class MetaDataLibrary
extends ServiceMBeanSupport
implements MetaDataLibraryMBean {
    private final Hashtable typeMappings = new Hashtable();

    public JDBCTypeMappingMetaData findTypeMappingMetaData(String name) {
        return (JDBCTypeMappingMetaData)this.typeMappings.get(name);
    }

    public Set getTypeMappingNames() {
        return Collections.unmodifiableSet(this.typeMappings.keySet());
    }

    public void startService() throws Exception {
        Element stdJDBCElement;
        Element typeMaps;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL stdJDBCUrl = classLoader.getResource("standardjbosscmp-jdbc.xml");
        if (stdJDBCUrl == null) {
            throw new DeploymentException("No standardjbosscmp-jdbc.xml found");
        }
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug("Loading standardjbosscmp-jdbc.xml : " + stdJDBCUrl.toString());
        }
        if ((typeMaps = MetaData.getOptionalChild(stdJDBCElement = XmlFileLoader.getDocument(stdJDBCUrl, true).getDocumentElement(), "type-mappings")) != null) {
            Iterator i = MetaData.getChildrenByTagName(typeMaps, "type-mapping");
            while (i.hasNext()) {
                Element typeMappingElement = (Element)i.next();
                JDBCTypeMappingMetaData typeMapping = new JDBCTypeMappingMetaData(typeMappingElement);
                this.typeMappings.put(typeMapping.getName(), typeMapping);
                this.log.debug("added type-mapping: " + typeMapping.getName());
            }
        }
    }

    public void stopService() throws Exception {
        this.typeMappings.clear();
    }
}

