/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.proxy.container.ProxyAdvisorDomain;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.MethodHashing;
import org.jboss.repository.spi.MetaDataContext;

public class ClassProxyContainer
extends ClassContainer {
    public ClassProxyContainer(String name, AspectManager manager) {
        super(name, manager);
    }

    protected void createConstructorTables() {
        Class useClass = this.clazz;
        if (this.clazz.getName().startsWith("AOPContainerProxy$") && this.clazz != null && this.clazz.getSuperclass() != null) {
            useClass = this.clazz.getSuperclass();
        }
        if (useClass != null) {
            this.constructors = useClass.getDeclaredConstructors();
            for (int i = 0; i < this.constructors.length; ++i) {
                this.constructors[i].setAccessible(true);
            }
            Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
        }
    }

    protected void createMethodMap() {
        try {
            int i;
            Method[] declaredMethods = this.clazz.getMethods();
            Class superclass = this.clazz.getSuperclass();
            for (i = 0; i < declaredMethods.length; ++i) {
                Method method = declaredMethods[i];
                if (!ClassAdvisor.isAdvisable(method)) continue;
                long hash = MethodHashing.methodHash(method);
                try {
                    if (method.getDeclaringClass().getName().indexOf("AOPContainerProxy$") >= 0 && superclass != null) {
                        method = superclass.getMethod(method.getName(), method.getParameterTypes());
                    }
                }
                catch (NoSuchMethodException ignored) {
                    // empty catch block
                }
                this.advisedMethods.put(hash, (Object)method);
            }
            for (i = 0; i < this.interfaceIntroductions.size(); ++i) {
                InterfaceIntroduction ii = (InterfaceIntroduction)this.interfaceIntroductions.get(i);
                String[] intf = ii.getInterfaces();
                this.addMethodsFromInterfaces(intf);
                ArrayList mixins = ii.getMixins();
                if (mixins.size() <= 0) continue;
                Iterator it = mixins.iterator();
                while (it.hasNext()) {
                    InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)it.next();
                    String[] mintf = mixin.getInterfaces();
                    this.addMethodsFromInterfaces(mintf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addMethodsFromInterfaces(String[] intf) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (int j = 0; intf != null && j < intf.length; ++j) {
            Class<?> iface = cl.loadClass(intf[j]);
            Method[] ifaceMethods = iface.getMethods();
            for (int k = 0; k < ifaceMethods.length; ++k) {
                long hash = MethodHashing.methodHash(ifaceMethods[k]);
                if (this.advisedMethods.get(hash) != null) continue;
                this.advisedMethods.put(hash, (Object)ifaceMethods[k]);
            }
        }
    }

    public InstanceProxyContainer createInstanceProxyContainer(InterfaceIntroduction introduction, MetaDataContext metaDataContext) {
        ProxyAdvisorDomain domain = new ProxyAdvisorDomain(this.manager, this.clazz, false);
        domain.setInheritsBindings(true);
        domain.setInheritsDeclarations(true);
        if (introduction != null) {
            domain.addInterfaceIntroduction(introduction);
        }
        InstanceProxyContainer ia = new InstanceProxyContainer(super.getName(), domain, this, metaDataContext);
        return ia;
    }

    public InstanceProxyContainer createInstanceProxyContainer() {
        return this.createInstanceProxyContainer(null, null);
    }

    public void initialise(Class proxiedClass) {
        this.setClass(proxiedClass);
        ((ProxyAdvisorDomain)this.manager).attachAdvisor();
        this.initializeInterfaceIntroductions(proxiedClass);
        super.initializeClassContainer();
    }

    protected Advisor getParentAdvisor() {
        return null;
    }

    public void addPerClassAspect(AspectDefinition def) {
        Advisor parentAdvisor = this.getParentAdvisor();
        if (parentAdvisor != null) {
            parentAdvisor.addPerClassAspect(def);
            return;
        }
        super.addPerClassAspect(def);
    }

    public Object getPerClassAspect(AspectDefinition def) {
        Object aspect;
        Advisor parentAdvisor = this.getParentAdvisor();
        if (parentAdvisor != null && (aspect = parentAdvisor.getPerClassAspect(def)) != null) {
            return aspect;
        }
        return super.getPerClassAspect(def);
    }

    protected boolean chainOverridingForInheritedMethods() {
        return false;
    }
}

