/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.standalone.Compiler;

public class TransformerCommon {
    static final URL[] NO_URLS = new URL[0];
    static final CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
    static final String WEAK_REFERENCE = WeakReference.class.getName();

    public static boolean isCompileTime() {
        return Compiler.loader != null;
    }

    public static void compileOrLoadClass(CtClass classForPackage, CtClass newClass) {
        TransformerCommon.compileOrLoadClass(classForPackage, newClass, TransformerCommon.isCompileTime());
    }

    public static void compileOrLoadClass(CtClass classForPackage, CtClass newClass, boolean compile) {
        try {
            ((AOPClassPool)newClass.getClassPool()).registerGeneratedClass(newClass.getName());
            if (compile) {
                URLClassLoader loader = Compiler.loader;
                if (loader == null) {
                    loader = new URLClassLoader(NO_URLS, Thread.currentThread().getContextClassLoader());
                }
                URL url = loader.getResource(classForPackage.getName().replace('.', '/') + ".class");
                String path = url.toString();
                path = path.substring(0, path.lastIndexOf(47) + 1);
                path = path + newClass.getSimpleName() + ".class";
                URI newUrl = new URI(path);
                File file = new File(newUrl);
                FileOutputStream fp = new FileOutputStream(file);
                fp.write(newClass.toBytecode());
                fp.close();
            } else {
                newClass.toClass();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void addInfoField(Instrumentor instrumentor, String infoClassName, String infoName, int modifiers, CtClass addTo, boolean weak, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        if (weak) {
            TransformerCommon.addWeakReferenceInfoField(instrumentor, infoClassName, infoName, modifiers, addTo, init);
        } else {
            TransformerCommon.addStrongReferenceInfoField(instrumentor, infoClassName, infoName, modifiers, addTo, init);
        }
    }

    private static void addWeakReferenceInfoField(Instrumentor instrumentor, String infoClassName, String infoName, int modifiers, CtClass addTo, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        CtClass type = instrumentor.forName(WEAK_REFERENCE);
        CtField field = new CtField(type, infoName, addTo);
        field.setModifiers(modifiers);
        addTo.addField(field, init);
    }

    private static void addStrongReferenceInfoField(Instrumentor instrumentor, String infoClassName, String infoName, int modifiers, CtClass addTo, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        CtClass type = instrumentor.forName(infoClassName);
        CtField field = new CtField(type, infoName, addTo);
        field.setModifiers(modifiers);
        addTo.addField(field, init);
    }

    protected static String infoFromWeakReference(String infoClassName, String localName, String infoName) {
        return infoClassName + " " + localName + " = (" + infoClassName + ")" + infoName + ".get();";
    }

    public static CtClass makeNestedClass(CtClass outer, String name, boolean isStatic, int modifiers, CtClass superClass) throws CannotCompileException {
        CtClass inner = TransformerCommon.makeNestedClass(outer, name, true);
        inner.setModifiers(modifiers);
        inner.setSuperclass(superClass);
        return inner;
    }

    public static CtClass makeNestedClass(CtClass outer, String name, boolean isStatic) throws CannotCompileException {
        TransformerCommon.registerGeneratedClass(outer.getClassPool(), outer.getName() + "$" + name);
        CtClass inner = outer.makeNestedClass(name, true);
        return inner;
    }

    public static CtClass makeClass(ClassPool pool, String name) {
        TransformerCommon.registerGeneratedClass(pool, name);
        return pool.makeClass(name);
    }

    public static CtClass makeClass(ClassPool pool, String name, CtClass superClass) {
        TransformerCommon.registerGeneratedClass(pool, name);
        return pool.makeClass(name, superClass);
    }

    private static void registerGeneratedClass(ClassPool pool, String name) {
        try {
            ((AOPClassPool)pool).registerGeneratedClass(name);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

