/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.crypto;

import com.pointbase.buffer.bufferRange;

public class cryptoMD5 {
    private static final int size = 16;
    private int[] buf = new int[4];
    private long i;
    private byte[] in = new byte[64];
    private static final byte[] PADDING = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;

    public void update(byte by) {
        byte[] byArray = new byte[]{by};
        this.update(byArray, 0, byArray.length);
    }

    public String digest() {
        this.finish();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 16) {
            stringBuffer.append(Integer.toHexString(bufferRange.fixByte((byte)this.in[n])));
            ++n;
        }
        this.init();
        return stringBuffer.toString().toUpperCase();
    }

    private static final int F(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static final int G(int n, int n2, int n3) {
        return n & n3 | n2 & ~n3;
    }

    private static final int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static final int I(int n, int n2, int n3) {
        return n2 ^ (n | ~n3);
    }

    private static final int ROTATE_LEFT(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static final int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += cryptoMD5.F(n2, n3, n4) + n5 + n7;
        n = cryptoMD5.ROTATE_LEFT(n, n6);
        return n += n2;
    }

    private static final int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += cryptoMD5.G(n2, n3, n4) + n5 + n7;
        n = cryptoMD5.ROTATE_LEFT(n, n6);
        return n += n2;
    }

    private static final int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += cryptoMD5.H(n2, n3, n4) + n5 + n7;
        n = cryptoMD5.ROTATE_LEFT(n, n6);
        return n += n2;
    }

    private static final int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += cryptoMD5.I(n2, n3, n4) + n5 + n7;
        n = cryptoMD5.ROTATE_LEFT(n, n6);
        return n += n2;
    }

    private void init() {
        this.i = 0L;
        this.buf[0] = 1732584193;
        this.buf[1] = -271733879;
        this.buf[2] = -1732584194;
        this.buf[3] = 271733878;
        int n = 0;
        while (n < 64) {
            this.in[n] = 0;
            ++n;
        }
    }

    public cryptoMD5() {
        this.init();
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = (int)(this.i >> 3 & 0x3FL);
        this.i += (long)(n2 << 3);
        while (n2-- != 0) {
            this.in[n3++] = byArray[n++];
            if (n3 != 64) continue;
            int[] nArray = new int[16];
            int n4 = 0;
            int n5 = 0;
            while (n4 < 16) {
                nArray[n4] = (this.in[n5 + 3] & 0xFF) << 24 | (this.in[n5 + 2] & 0xFF) << 16 | (this.in[n5 + 1] & 0xFF) << 8 | this.in[n5] & 0xFF;
                ++n4;
                n5 += 4;
            }
            this.Transform(nArray);
            n3 = 0;
        }
    }

    private void finish() {
        int[] nArray = new int[16];
        nArray[14] = (int)(this.i & 0xFFFFFFFFFFFFFFFFL);
        nArray[15] = (int)(this.i >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        int n = (int)(this.i >> 3 & 0x3FL);
        int n2 = n < 56 ? 56 - n : 120 - n;
        this.update(PADDING, 0, n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < 14) {
            nArray[n3] = (this.in[n4 + 3] & 0xFF) << 24 | (this.in[n4 + 2] & 0xFF) << 16 | (this.in[n4 + 1] & 0xFF) << 8 | this.in[n4] & 0xFF;
            ++n3;
            n4 += 4;
        }
        this.Transform(nArray);
        n3 = 0;
        n4 = 0;
        while (n3 < 4) {
            this.in[n4] = (byte)(this.buf[n3] & 0xFF);
            this.in[n4 + 1] = (byte)(this.buf[n3] >> 8 & 0xFF);
            this.in[n4 + 2] = (byte)(this.buf[n3] >> 16 & 0xFF);
            this.in[n4 + 3] = (byte)(this.buf[n3] >> 24 & 0xFF);
            ++n3;
            n4 += 4;
        }
    }

    private void Transform(int[] nArray) {
        int n = this.buf[0];
        int n2 = this.buf[1];
        int n3 = this.buf[2];
        int n4 = this.buf[3];
        n = cryptoMD5.FF(n, n2, n3, n4, nArray[0], 7, -680876936);
        n4 = cryptoMD5.FF(n4, n, n2, n3, nArray[1], 12, -389564586);
        n3 = cryptoMD5.FF(n3, n4, n, n2, nArray[2], 17, 606105819);
        n2 = cryptoMD5.FF(n2, n3, n4, n, nArray[3], 22, -1044525330);
        n = cryptoMD5.FF(n, n2, n3, n4, nArray[4], 7, -176418897);
        n4 = cryptoMD5.FF(n4, n, n2, n3, nArray[5], 12, 1200080426);
        n3 = cryptoMD5.FF(n3, n4, n, n2, nArray[6], 17, -1473231341);
        n2 = cryptoMD5.FF(n2, n3, n4, n, nArray[7], 22, -45705983);
        n = cryptoMD5.FF(n, n2, n3, n4, nArray[8], 7, 1770035416);
        n4 = cryptoMD5.FF(n4, n, n2, n3, nArray[9], 12, -1958414417);
        n3 = cryptoMD5.FF(n3, n4, n, n2, nArray[10], 17, -42063);
        n2 = cryptoMD5.FF(n2, n3, n4, n, nArray[11], 22, -1990404162);
        n = cryptoMD5.FF(n, n2, n3, n4, nArray[12], 7, 1804603682);
        n4 = cryptoMD5.FF(n4, n, n2, n3, nArray[13], 12, -40341101);
        n3 = cryptoMD5.FF(n3, n4, n, n2, nArray[14], 17, -1502002290);
        n2 = cryptoMD5.FF(n2, n3, n4, n, nArray[15], 22, 1236535329);
        n = cryptoMD5.GG(n, n2, n3, n4, nArray[1], 5, -165796510);
        n4 = cryptoMD5.GG(n4, n, n2, n3, nArray[6], 9, -1069501632);
        n3 = cryptoMD5.GG(n3, n4, n, n2, nArray[11], 14, 643717713);
        n2 = cryptoMD5.GG(n2, n3, n4, n, nArray[0], 20, -373897302);
        n = cryptoMD5.GG(n, n2, n3, n4, nArray[5], 5, -701558691);
        n4 = cryptoMD5.GG(n4, n, n2, n3, nArray[10], 9, 38016083);
        n3 = cryptoMD5.GG(n3, n4, n, n2, nArray[15], 14, -660478335);
        n2 = cryptoMD5.GG(n2, n3, n4, n, nArray[4], 20, -405537848);
        n = cryptoMD5.GG(n, n2, n3, n4, nArray[9], 5, 568446438);
        n4 = cryptoMD5.GG(n4, n, n2, n3, nArray[14], 9, -1019803690);
        n3 = cryptoMD5.GG(n3, n4, n, n2, nArray[3], 14, -187363961);
        n2 = cryptoMD5.GG(n2, n3, n4, n, nArray[8], 20, 1163531501);
        n = cryptoMD5.GG(n, n2, n3, n4, nArray[13], 5, -1444681467);
        n4 = cryptoMD5.GG(n4, n, n2, n3, nArray[2], 9, -51403784);
        n3 = cryptoMD5.GG(n3, n4, n, n2, nArray[7], 14, 1735328473);
        n2 = cryptoMD5.GG(n2, n3, n4, n, nArray[12], 20, -1926607734);
        n = cryptoMD5.HH(n, n2, n3, n4, nArray[5], 4, -378558);
        n4 = cryptoMD5.HH(n4, n, n2, n3, nArray[8], 11, -2022574463);
        n3 = cryptoMD5.HH(n3, n4, n, n2, nArray[11], 16, 1839030562);
        n2 = cryptoMD5.HH(n2, n3, n4, n, nArray[14], 23, -35309556);
        n = cryptoMD5.HH(n, n2, n3, n4, nArray[1], 4, -1530992060);
        n4 = cryptoMD5.HH(n4, n, n2, n3, nArray[4], 11, 1272893353);
        n3 = cryptoMD5.HH(n3, n4, n, n2, nArray[7], 16, -155497632);
        n2 = cryptoMD5.HH(n2, n3, n4, n, nArray[10], 23, -1094730640);
        n = cryptoMD5.HH(n, n2, n3, n4, nArray[13], 4, 681279174);
        n4 = cryptoMD5.HH(n4, n, n2, n3, nArray[0], 11, -358537222);
        n3 = cryptoMD5.HH(n3, n4, n, n2, nArray[3], 16, -722521979);
        n2 = cryptoMD5.HH(n2, n3, n4, n, nArray[6], 23, 76029189);
        n = cryptoMD5.HH(n, n2, n3, n4, nArray[9], 4, -640364487);
        n4 = cryptoMD5.HH(n4, n, n2, n3, nArray[12], 11, -421815835);
        n3 = cryptoMD5.HH(n3, n4, n, n2, nArray[15], 16, 530742520);
        n2 = cryptoMD5.HH(n2, n3, n4, n, nArray[2], 23, -995338651);
        n = cryptoMD5.II(n, n2, n3, n4, nArray[0], 6, -198630844);
        n4 = cryptoMD5.II(n4, n, n2, n3, nArray[7], 10, 1126891415);
        n3 = cryptoMD5.II(n3, n4, n, n2, nArray[14], 15, -1416354905);
        n2 = cryptoMD5.II(n2, n3, n4, n, nArray[5], 21, -57434055);
        n = cryptoMD5.II(n, n2, n3, n4, nArray[12], 6, 1700485571);
        n4 = cryptoMD5.II(n4, n, n2, n3, nArray[3], 10, -1894986606);
        n3 = cryptoMD5.II(n3, n4, n, n2, nArray[10], 15, -1051523);
        n2 = cryptoMD5.II(n2, n3, n4, n, nArray[1], 21, -2054922799);
        n = cryptoMD5.II(n, n2, n3, n4, nArray[8], 6, 1873313359);
        n4 = cryptoMD5.II(n4, n, n2, n3, nArray[15], 10, -30611744);
        n3 = cryptoMD5.II(n3, n4, n, n2, nArray[6], 15, -1560198380);
        n2 = cryptoMD5.II(n2, n3, n4, n, nArray[13], 21, 1309151649);
        n = cryptoMD5.II(n, n2, n3, n4, nArray[4], 6, -145523070);
        n4 = cryptoMD5.II(n4, n, n2, n3, nArray[11], 10, -1120210379);
        n3 = cryptoMD5.II(n3, n4, n, n2, nArray[2], 15, 718787259);
        n2 = cryptoMD5.II(n2, n3, n4, n, nArray[9], 21, -343485551);
        this.buf[0] = this.buf[0] + n;
        this.buf[1] = this.buf[1] + n2;
        this.buf[2] = this.buf[2] + n3;
        this.buf[3] = this.buf[3] + n4;
    }

    public static void main(String[] stringArray) {
        cryptoMD5 cryptoMD52 = new cryptoMD5();
        cryptoMD52.update(stringArray[0].getBytes(), 0, stringArray[0].getBytes().length);
        System.out.println(cryptoMD52.digest());
    }
}

