/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.collxn;

import com.pointbase.collxn.HashtableEntry;
import com.pointbase.collxn.collxnHashtableEnumerator;
import com.pointbase.collxn.collxnICollection;
import com.pointbase.collxn.collxnIEnumerator;
import com.pointbase.dbexcp.dbexcpException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class collxnHashtable
implements Serializable,
collxnICollection {
    private transient HashtableEntry[] table;
    private transient int count;
    private int threshold;
    private boolean m_isRehashing = false;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public collxnHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public collxnHashtable(int n) {
        this(n, 0.75f);
    }

    public collxnHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public int capacity() {
        return this.table.length;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized collxnIEnumerator keys() {
        return new collxnHashtableEnumerator(this.table, true);
    }

    public synchronized collxnIEnumerator elements() {
        return new collxnHashtableEnumerator(this.table, false);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (n-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n];
            while (hashtableEntry != null) {
                if (hashtableEntry.value.equals(object)) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    protected synchronized HashtableEntry getEntry(HashtableEntry hashtableEntry) {
        Object object = hashtableEntry.key;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry2 = hashtableEntryArray[n2];
        while (hashtableEntry2 != null) {
            if (hashtableEntry2.hash == n && hashtableEntry2.key.equals(object)) {
                return hashtableEntry2;
            }
            hashtableEntry2 = hashtableEntry2.next;
        }
        return null;
    }

    protected void rehash() {
        this.m_isRehashing = true;
        int n = this.table.length;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
        this.m_isRehashing = false;
    }

    public boolean isRehashing() {
        return this.m_isRehashing;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                Object object3 = hashtableEntry.value;
                hashtableEntry.value = object2;
                return object3;
            }
            hashtableEntry = hashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        HashtableEntry hashtableEntry2 = new HashtableEntry();
        hashtableEntry2.hash = n;
        hashtableEntry2.key = object;
        hashtableEntry2.value = object2;
        hashtableEntry2.next = hashtableEntryArray[n2];
        hashtableEntryArray[n2] = hashtableEntry2;
        ++this.count;
        return null;
    }

    protected synchronized HashtableEntry putEntry(HashtableEntry hashtableEntry) {
        if (hashtableEntry == null) {
            throw new NullPointerException();
        }
        Object object = hashtableEntry.key;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry2 = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry3 = null;
        while (hashtableEntry2 != null) {
            if (hashtableEntry2.hash == n && hashtableEntry2.key.equals(object)) {
                HashtableEntry hashtableEntry4 = hashtableEntry2;
                hashtableEntry.hash = n;
                hashtableEntry.next = hashtableEntry2.next;
                if (hashtableEntry3 != null) {
                    hashtableEntry3.next = hashtableEntry;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry;
                }
                return hashtableEntry4;
            }
            hashtableEntry3 = hashtableEntry2;
            hashtableEntry2 = hashtableEntry2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.putEntry(hashtableEntry);
        }
        hashtableEntry.hash = n;
        hashtableEntry.next = hashtableEntryArray[n2];
        hashtableEntryArray[n2] = hashtableEntry;
        ++this.count;
        return null;
    }

    public synchronized Object remove(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public HashtableEntry removeEntry(HashtableEntry hashtableEntry) {
        Object object = hashtableEntry.key;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry2 = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry3 = null;
        while (hashtableEntry2 != null) {
            if (hashtableEntry2.hash == n && hashtableEntry2.key.equals(object)) {
                if (hashtableEntry3 != null) {
                    hashtableEntry3.next = hashtableEntry2.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry2.next;
                }
                --this.count;
                return hashtableEntry2;
            }
            hashtableEntry3 = hashtableEntry2;
            hashtableEntry2 = hashtableEntry2.next;
        }
        return null;
    }

    public synchronized void clear() {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (--n >= 0) {
            hashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            collxnIEnumerator collxnIEnumerator2 = this.keys();
            collxnIEnumerator collxnIEnumerator3 = this.elements();
            stringBuffer.append("{");
            int n2 = 0;
            while (n2 <= n) {
                String string = collxnIEnumerator2.nextElement().toString();
                String string2 = collxnIEnumerator3.nextElement().toString();
                stringBuffer.append(string + "=" + string2);
                if (n2 < n) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            stringBuffer.append("}");
        }
        catch (dbexcpException dbexcpException2) {
            stringBuffer.append(" **** ");
            stringBuffer.append(dbexcpException2.toString());
        }
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            HashtableEntry hashtableEntry = this.table[n];
            while (hashtableEntry != null) {
                objectOutputStream.writeObject(hashtableEntry.key);
                objectOutputStream.writeObject(hashtableEntry.value);
                hashtableEntry = hashtableEntry.next;
            }
            --n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new HashtableEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }
}

