/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
import org.jboss.ws.core.server.MimeHeaderSource;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.server.ServletHeaderSource;
import org.jboss.ws.core.server.ServletRequestContext;
import org.jboss.ws.core.server.WSDLRequestHandler;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.SOAPConnectionImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.utils.ThreadLocalAssociation;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestHandlerImpl
implements RequestHandler {
    private static final Logger log = Logger.getLogger(RequestHandlerImpl.class);
    private ServerConfig serverConfig;
    private MessageFactoryImpl msgFactory;

    RequestHandlerImpl() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        this.msgFactory = new MessageFactoryImpl();
    }

    public void handleHttpRequest(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        String method = req.getMethod();
        if (method.equals("POST")) {
            this.doPost(endpoint, req, res, context);
        } else if (method.equals("GET")) {
            this.doGet(endpoint, req, res, context);
        } else {
            throw new WSException("Unsupported method: " + method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGet(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        if (req.getParameter("wsdl") != null || req.getParameter("WSDL") != null) {
            res.setContentType("text/xml");
            ServletOutputStream out = res.getOutputStream();
            try {
                ServletRequestContext reqContext = new ServletRequestContext(context, req, res);
                this.handleWSDLRequest(endpoint, (OutputStream)out, reqContext);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ioex) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Cannot close output stream", (Throwable)ioex);
                    }
                    log.debug((Object)"Cannot close output stream");
                }
            }
        } else {
            res.setStatus(405);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            ((Writer)out).write("HTTP GET not supported");
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        log.debug((Object)("doPost: " + req.getRequestURI()));
        ServletInputStream in = req.getInputStream();
        ServletOutputStream out = res.getOutputStream();
        ClassLoader classLoader = endpoint.getService().getDeployment().getRuntimeClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Deployment has no classloader associated");
        }
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            ServletRequestContext reqContext = new ServletRequestContext(context, req, res);
            this.handleRequest(endpoint, (InputStream)in, (OutputStream)out, reqContext);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
            try {
                out.close();
            }
            catch (IOException ioex) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Cannot close output stream", (Throwable)ioex);
                }
                log.debug((Object)"Cannot close output stream");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(Endpoint endpoint, InputStream inStream, OutputStream outStream, InvocationContext invContext) {
        CommonMessageContext msgContext;
        log.debug((Object)("handleRequest: " + endpoint.getName()));
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
        if (sepMetaData == null) {
            throw new IllegalStateException("Cannot obtain endpoint meta data");
        }
        EndpointMetaData.Type type = sepMetaData.getType();
        if (type == EndpointMetaData.Type.JAXRPC) {
            msgContext = new SOAPMessageContextJAXRPC();
            invContext.addAttachment(javax.xml.rpc.handler.MessageContext.class, (Object)msgContext);
        } else {
            msgContext = new SOAPMessageContextJAXWS();
            msgContext.put("javax.xml.ws.handler.message.outbound", (Object)new Boolean(false));
            msgContext.put("javax.xml.ws.binding.attachments.inbound", (Object)new HashMap());
            invContext.addAttachment(MessageContext.class, (Object)msgContext);
        }
        HttpServletResponse httpResponse = null;
        ServletHeaderSource headerSource = null;
        if (invContext instanceof ServletRequestContext) {
            ServletRequestContext reqContext = (ServletRequestContext)invContext;
            ServletContext servletContext = reqContext.getServletContext();
            HttpServletRequest httpRequest = reqContext.getHttpServletRequest();
            httpResponse = reqContext.getHttpServletResponse();
            headerSource = new ServletHeaderSource(httpRequest, httpResponse);
            if (type == EndpointMetaData.Type.JAXRPC) {
                msgContext.put("javax.xml.ws.servlet.context", (Object)servletContext);
                msgContext.put("javax.xml.ws.servlet.request", (Object)httpRequest);
                msgContext.put("javax.xml.ws.servlet.response", (Object)httpResponse);
            } else {
                msgContext.put("javax.xml.ws.http.request.headers", (Object)headerSource.getHeaderMap());
                msgContext.put("javax.xml.ws.http.request.method", (Object)httpRequest.getMethod());
                msgContext.put("javax.xml.ws.http.request.querystring", (Object)httpRequest.getQueryString());
                msgContext.put("javax.xml.ws.http.request.pathinfo", (Object)httpRequest.getPathInfo());
                msgContext.put("javax.xml.ws.servlet.context", (Object)servletContext);
                msgContext.put("javax.xml.ws.servlet.request", (Object)httpRequest);
                msgContext.put("javax.xml.ws.servlet.response", (Object)httpResponse);
            }
        }
        MessageContextAssociation.pushMessageContext(msgContext);
        msgContext.setEndpointMetaData(sepMetaData);
        try {
            MessageAbstraction resMessage = this.processRequest(endpoint, headerSource, invContext, inStream);
            msgContext = MessageContextAssociation.peekMessageContext();
            Map headers = (Map)msgContext.get("javax.xml.ws.http.response.headers");
            if (headerSource != null && headers != null) {
                headerSource.setHeaderMap(headers);
            }
            Integer code = (Integer)msgContext.get("javax.xml.ws.http.response.code");
            if (httpResponse != null && code != null) {
                httpResponse.setStatus(code.intValue());
            }
            boolean isFault = false;
            if (resMessage instanceof SOAPMessage) {
                SOAPPart part = ((SOAPMessage)resMessage).getSOAPPart();
                if (part == null) {
                    throw new SOAPException("Cannot obtain SOAPPart from response message");
                }
                SOAPEnvelope soapEnv = part.getEnvelope();
                boolean bl = isFault = soapEnv != null && soapEnv.getBody().hasFault();
                if (httpResponse != null && isFault) {
                    httpResponse.setStatus(500);
                }
            }
            if (outStream != null) {
                this.sendResponse(outStream, msgContext, isFault);
            }
        }
        catch (Exception ex) {
            WSException.rethrow(ex);
        }
        finally {
            MessageContextAssociation.popMessageContext();
            ThreadLocalAssociation.clear();
        }
    }

    private void sendResponse(OutputStream outputStream, CommonMessageContext msgContext, boolean isFault) throws SOAPException, IOException {
        MessageAbstraction resMessage = msgContext.getMessageAbstraction();
        String wsaTo = null;
        AddressingProperties outProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
        if (outProps != null && outProps.getTo() != null) {
            AddressingConstantsImpl ADDR = new AddressingConstantsImpl();
            wsaTo = outProps.getTo().getURI().toString();
            if (wsaTo.equals(ADDR.getAnonymousURI())) {
                wsaTo = null;
            }
        }
        if (wsaTo != null) {
            log.debug((Object)("Sending response to addressing destination: " + wsaTo));
            new SOAPConnectionImpl().callOneWay((SOAPMessage)resMessage, wsaTo);
        } else {
            resMessage.writeTo(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageAbstraction processRequest(Endpoint ep, MimeHeaderSource headerSource, InvocationContext reqContext, InputStream inputStream) throws BindingException {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
        if (sepMetaData == null) {
            throw new IllegalStateException("Cannot obtain endpoint meta data");
        }
        long beginProcessing = 0L;
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            MessageAbstraction reqMessage;
            Endpoint.EndpointState state = ep.getState();
            if (state != Endpoint.EndpointState.STARTED) {
                QName faultCode = Constants.SOAP11_FAULT_CODE_SERVER;
                String faultString = "Endpoint cannot handle requests in state: " + state;
                throw new CommonSOAPFaultException(faultCode, faultString);
            }
            log.debug((Object)("BEGIN handleRequest: " + ep.getName()));
            beginProcessing = this.initRequestMetrics(ep);
            MimeHeaders headers = headerSource != null ? headerSource.getMimeHeaders() : null;
            String bindingID = sepMetaData.getBindingId();
            if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
                reqMessage = new HTTPMessageImpl(headers, inputStream);
            } else {
                this.msgFactory.setServiceMode(sepMetaData.getServiceMode());
                this.msgFactory.setStyle(sepMetaData.getStyle());
                reqMessage = (SOAPMessageImpl)this.msgFactory.createMessage(headers, inputStream);
            }
            msgContext.setMessageAbstraction(reqMessage);
            MessageTrace.traceMessage("Incoming Request Message", reqMessage);
            ClassLoader classLoader = sepMetaData.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            ServiceEndpointInvoker epInvoker = (ServiceEndpointInvoker)ep.getAttachment(ServiceEndpointInvoker.class);
            if (epInvoker == null) {
                throw new IllegalStateException("Cannot obtain ServiceEndpointInvoker");
            }
            epInvoker.invoke(reqContext);
            msgContext = MessageContextAssociation.peekMessageContext();
            MessageAbstraction resMessage = msgContext.getMessageAbstraction();
            if (resMessage != null) {
                this.postProcessResponse(headerSource, resMessage);
            }
            MessageAbstraction messageAbstraction = resMessage;
            return messageAbstraction;
        }
        catch (Exception ex) {
            MessageAbstraction resMessage = msgContext.getMessageAbstraction();
            if (resMessage == null || !resMessage.isFaultMessage()) {
                CommonBindingProvider bindingProvider = new CommonBindingProvider(sepMetaData);
                CommonBinding binding = bindingProvider.getCommonBinding();
                resMessage = binding.bindFaultMessage(ex);
            }
            if (resMessage != null) {
                this.postProcessResponse(headerSource, resMessage);
            }
            MessageAbstraction messageAbstraction = resMessage;
            return messageAbstraction;
        }
        finally {
            try {
                MessageAbstraction resMessage = msgContext.getMessageAbstraction();
                if (resMessage != null) {
                    if (resMessage.isFaultMessage()) {
                        this.processFaultMetrics(ep, beginProcessing);
                    } else {
                        this.processResponseMetrics(ep, beginProcessing);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)"Cannot process metrics", (Throwable)ex);
            }
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
            log.debug((Object)("END handleRequest: " + ep.getName()));
        }
    }

    private long initRequestMetrics(Endpoint endpoint) {
        long beginTime = 0L;
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            beginTime = metrics.processRequestMessage();
        }
        return beginTime;
    }

    private void processResponseMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processResponseMessage(beginTime);
        }
    }

    private void processFaultMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processFaultMessage(beginTime);
        }
    }

    private void postProcessResponse(MimeHeaderSource headerSource, MessageAbstraction resMessage) {
        try {
            if (headerSource != null && resMessage instanceof SOAPMessage) {
                XOPContext.eagerlyCreateAttachments();
                ((SOAPMessage)resMessage).saveChanges();
                headerSource.setMimeHeaders(resMessage.getMimeHeaders());
            }
            MessageTrace.traceMessage("Outgoing Response Message", resMessage);
        }
        catch (Exception ex) {
            WSException.rethrow("Faild to post process response message", ex);
        }
    }

    public void handleWSDLRequest(Endpoint endpoint, OutputStream outputStream, InvocationContext context) {
        log.debug((Object)("handleWSDLRequest: " + endpoint.getName()));
        ServerEndpointMetaData epMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
        if (epMetaData == null) {
            throw new IllegalStateException("Cannot obtain endpoint meta data");
        }
        ServletRequestContext reqContext = (ServletRequestContext)context;
        HttpServletRequest req = reqContext.getHttpServletRequest();
        try {
            String resPath = req.getParameter("resource");
            URL reqURL = new URL(req.getRequestURL().toString());
            String wsdlHost = reqURL.getProtocol() + "://" + reqURL.getHost();
            if (reqURL.getPort() != -1) {
                wsdlHost = wsdlHost + ":" + reqURL.getPort();
            }
            if (!"jbossws.undefined.host".equals(this.serverConfig.getWebServiceHost())) {
                wsdlHost = this.serverConfig.getWebServiceHost();
            }
            log.debug((Object)("WSDL request, using host: " + wsdlHost));
            WSDLRequestHandler wsdlRequestHandler = new WSDLRequestHandler(epMetaData);
            Document document = wsdlRequestHandler.getDocumentForPath(reqURL, wsdlHost, resPath);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            new DOMWriter((Writer)writer).setPrettyprint(true).print((Node)document.getDocumentElement());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (IOException ex) {
            throw new WSException(ex);
        }
    }

    private void handleException(Exception ex) throws ServletException {
        log.error((Object)"Error processing web service request", (Throwable)ex);
        if (ex instanceof JAXRPCException) {
            throw (JAXRPCException)ex;
        }
        throw new ServletException((Throwable)ex);
    }
}

