/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import org.jboss.ws.WSException;
import org.jboss.wsf.common.IOUtils;

public class BufferedStreamSource
extends StreamSource {
    private byte[] bytes;
    private char[] chars;

    public BufferedStreamSource(StreamSource source) {
        try {
            InputStream ins = source.getInputStream();
            if (ins != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                IOUtils.copyStream((OutputStream)baos, (InputStream)ins);
                this.bytes = baos.toByteArray();
            }
            Reader rd = source.getReader();
            if (ins == null && rd != null) {
                char[] auxbuf = new char[1024];
                CharArrayWriter wr = new CharArrayWriter(auxbuf.length);
                int r = rd.read(auxbuf);
                while (r > 0) {
                    wr.write(auxbuf, 0, r);
                    r = rd.read(auxbuf);
                }
                this.chars = wr.toCharArray();
            }
        }
        catch (IOException ex) {
            WSException.rethrow(ex);
        }
    }

    public BufferedStreamSource(byte[] bytes) {
        this.bytes = bytes;
    }

    public InputStream getInputStream() {
        return this.bytes != null ? new ByteArrayInputStream(this.bytes) : null;
    }

    public Reader getReader() {
        return this.chars != null ? new CharArrayReader(this.chars) : null;
    }

    public void setInputStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public void setReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String retStr = null;
        if (this.bytes != null) {
            try {
                retStr = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                WSException.rethrow(e);
            }
        } else if (this.chars != null) {
            retStr = new String(this.chars);
        }
        return "" + retStr;
    }
}

