/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.net.sockets.DefaultSocketFactory;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.ThreadPool;
import org.jnp.interfaces.Naming;
import org.jnp.server.MainMBean;
import org.jnp.server.NamingBean;

public class Main
implements MainMBean {
    protected NamingBean theServer;
    protected MarshalledObject serverStub;
    protected boolean isStubExported;
    protected ServerSocket serverSocket;
    protected RMIClientSocketFactory clientSocketFactory;
    protected RMIServerSocketFactory serverSocketFactory;
    protected ServerSocketFactory jnpServerSocketFactory;
    protected String clientSocketFactoryName;
    protected String serverSocketFactoryName;
    protected String jnpServerSocketFactoryName;
    protected InetAddress bindAddress;
    protected InetAddress rmiBindAddress;
    protected int backlog = 50;
    protected int port = 1099;
    protected int rmiPort = 0;
    protected boolean InstallGlobalService = true;
    protected boolean UseGlobalService = true;
    protected Logger log;
    protected ThreadPool lookupPool;

    public static void main(String[] args) throws Exception {
        new Main().start();
    }

    public Main() {
        this("org.jboss.naming.Naming");
    }

    public Main(String categoryName) {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream is = loader.getResourceAsStream("jnp.properties");
            System.getProperties().load(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPort(Integer.getInteger("jnp.port", this.getPort()));
        this.setRmiPort(Integer.getInteger("jnp.rmiPort", this.getRmiPort()));
        this.log = Logger.getLogger((String)categoryName);
    }

    public NamingBean getNamingInfo() {
        return this.theServer;
    }

    public void setNamingInfo(NamingBean info) {
        this.theServer = info;
    }

    public ThreadPool getLookupPool() {
        return this.lookupPool;
    }

    public void setLookupPool(ThreadPool lookupPool) {
        this.lookupPool = lookupPool;
    }

    public void setNamingProxy(Object proxy) throws IOException {
        this.serverStub = new MarshalledObject<Object>(proxy);
    }

    public void setRmiPort(int p) {
        this.rmiPort = p;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public String getRmiBindAddress() {
        String address = null;
        if (this.rmiBindAddress != null) {
            address = this.rmiBindAddress.getHostAddress();
        }
        return address;
    }

    public void setRmiBindAddress(String host) throws UnknownHostException {
        this.rmiBindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    public boolean getInstallGlobalService() {
        return this.InstallGlobalService;
    }

    public void setInstallGlobalService(boolean flag) {
        this.InstallGlobalService = flag;
    }

    public boolean getUseGlobalService() {
        return this.UseGlobalService;
    }

    public void setUseGlobalService(boolean flag) {
        this.UseGlobalService = flag;
    }

    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.clientSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.clientSocketFactoryName);
        this.clientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
    }

    public RMIClientSocketFactory getClientSocketFactoryBean() {
        return this.clientSocketFactory;
    }

    public void setClientSocketFactoryBean(RMIClientSocketFactory factory) {
        this.clientSocketFactory = factory;
    }

    public String getServerSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.serverSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.serverSocketFactoryName);
        this.serverSocketFactory = (RMIServerSocketFactory)clazz.newInstance();
    }

    public RMIServerSocketFactory getServerSocketFactoryBean() {
        return this.serverSocketFactory;
    }

    public void setServerSocketFactoryBean(RMIServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public String getJNPServerSocketFactory() {
        return this.jnpServerSocketFactoryName;
    }

    public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.jnpServerSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.jnpServerSocketFactoryName);
        this.jnpServerSocketFactory = (ServerSocketFactory)clazz.newInstance();
    }

    public ServerSocketFactory getJNPServerSocketFactoryBean() {
        return this.jnpServerSocketFactory;
    }

    public void setJNPServerSocketFactoryBean(ServerSocketFactory factory) {
        this.jnpServerSocketFactory = factory;
    }

    public Naming getNamingInstance() {
        return this.theServer.getNamingInstance();
    }

    public void start() throws Exception {
        this.initCustomSocketFactories();
        if (this.serverStub == null && this.port >= 0) {
            this.initJnpInvoker();
        }
        if (this.serverStub != null) {
            this.initBootstrapListener();
        }
    }

    public void stop() {
        try {
            if (this.serverSocket != null) {
                ServerSocket s = this.serverSocket;
                this.serverSocket = null;
                s.close();
            }
            if (this.isStubExported) {
                UnicastRemoteObject.unexportObject(this.theServer.getNamingInstance(), false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception during shutdown", (Throwable)e);
        }
    }

    protected void initJnpInvoker() throws IOException {
        this.log.debug((Object)("Creating NamingServer stub, theServer=" + this.theServer + ",rmiPort=" + this.rmiPort + ",clientSocketFactory=" + this.clientSocketFactory + ",serverSocketFactory=" + this.serverSocketFactory));
        Remote stub = UnicastRemoteObject.exportObject(this.getNamingInstance(), this.rmiPort, this.clientSocketFactory, this.serverSocketFactory);
        this.log.debug((Object)("NamingServer stub: " + stub));
        this.serverStub = new MarshalledObject<Remote>(stub);
    }

    protected void initBootstrapListener() {
        try {
            if (this.jnpServerSocketFactory == null) {
                this.jnpServerSocketFactory = ServerSocketFactory.getDefault();
            }
            this.serverSocket = this.jnpServerSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddress);
            if (this.port == 0) {
                this.port = this.serverSocket.getLocalPort();
            }
            String msg = "JNDI bootstrap JNP=" + this.bindAddress + ":" + this.port + ", RMI=" + this.bindAddress + ":" + this.rmiPort + ", backlog=" + this.backlog;
            msg = this.clientSocketFactory == null ? msg + ", no client SocketFactory" : msg + ", Client SocketFactory=" + this.clientSocketFactory.toString();
            msg = this.serverSocketFactory == null ? msg + ", no server SocketFactory" : msg + ", Server SocketFactory=" + this.serverSocketFactory.toString();
            this.log.debug((Object)msg);
        }
        catch (IOException e) {
            this.log.error((Object)("Could not start on port " + this.port), (Throwable)e);
        }
        if (this.lookupPool == null) {
            this.lookupPool = new BasicThreadPool("NamingBootstrap Pool");
        }
        AcceptHandler handler = new AcceptHandler();
        this.lookupPool.run((Runnable)handler);
    }

    protected void initCustomSocketFactories() {
        Object[] args;
        Method m;
        Class[] parameterTypes;
        InetAddress addr;
        InetAddress inetAddress = addr = this.rmiBindAddress != null ? this.rmiBindAddress : this.bindAddress;
        if (this.clientSocketFactory != null && addr != null) {
            try {
                Class<?> csfClass = this.clientSocketFactory.getClass();
                parameterTypes = new Class[]{String.class};
                m = csfClass.getMethod("setBindAddress", parameterTypes);
                args = new Object[]{addr.getHostAddress()};
                m.invoke((Object)this.clientSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                this.log.warn((Object)"Socket factory does not support setBindAddress(String)");
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to setBindAddress=" + addr + " on socket factory"), (Throwable)e);
            }
        }
        try {
            if (this.serverSocketFactory == null) {
                this.serverSocketFactory = new DefaultSocketFactory(addr);
            } else if (addr != null) {
                try {
                    Class<?> ssfClass = this.serverSocketFactory.getClass();
                    parameterTypes = new Class[]{String.class};
                    m = ssfClass.getMethod("setBindAddress", parameterTypes);
                    args = new Object[]{addr.getHostAddress()};
                    m.invoke((Object)this.serverSocketFactory, args);
                }
                catch (NoSuchMethodException e) {
                    this.log.warn((Object)"Socket factory does not support setBindAddress(String)");
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to setBindAddress=" + addr + " on socket factory"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"operation failed", (Throwable)e);
            this.serverSocketFactory = null;
        }
    }

    private class BootstrapRequestHandler
    implements Runnable {
        private Socket socket;

        BootstrapRequestHandler(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                OutputStream os = this.socket.getOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(Main.this.serverStub);
                out.close();
            }
            catch (IOException ex) {
                Main.this.log.debug((Object)("Error writing response to " + this.socket.getInetAddress()), (Throwable)ex);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class AcceptHandler
    implements Runnable {
        private AcceptHandler() {
        }

        public void run() {
            boolean trace = Main.this.log.isTraceEnabled();
            while (Main.this.serverSocket != null) {
                Socket socket = null;
                try {
                    socket = Main.this.serverSocket.accept();
                    if (trace) {
                        Main.this.log.trace((Object)("Accepted bootstrap client: " + socket));
                    }
                    BootstrapRequestHandler handler = new BootstrapRequestHandler(socket);
                    Main.this.lookupPool.run((Runnable)handler);
                }
                catch (IOException e) {
                    if (Main.this.serverSocket == null) {
                        return;
                    }
                    Main.this.log.error((Object)"Naming accept handler stopping", (Throwable)e);
                }
                catch (Throwable e) {
                    Main.this.log.error((Object)"Unexpected exception during accept", e);
                }
            }
        }
    }
}

