/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class FieldInfoImpl
extends AnnotationHolder
implements FieldInfo {
    private static final long serialVersionUID = 3546084661584539959L;
    protected String name;
    protected Field field;
    protected TypeInfo type;
    protected int modifiers;
    protected ClassInfo declaringClass;
    protected int hash = -1;

    public FieldInfoImpl() {
    }

    public FieldInfoImpl(AnnotationValue[] annotationValueArray, String string, TypeInfo typeInfo, int n, ClassInfo classInfo) {
        super(annotationValueArray);
        this.name = string;
        this.type = typeInfo;
        this.modifiers = n;
        this.declaringClass = classInfo;
        this.calculateHash();
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    protected void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("name=").append(this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof FieldInfoImpl)) {
            return false;
        }
        FieldInfoImpl fieldInfoImpl = (FieldInfoImpl)object;
        if (!this.declaringClass.equals(fieldInfoImpl.declaringClass)) {
            return false;
        }
        return this.name.equals(fieldInfoImpl.name);
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int n = this.name.hashCode();
        this.hash = n = 29 * n + this.declaringClass.hashCode();
    }
}

