/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import org.apache.batik.gvt.font.UnicodeRange;

public class Kern {
    private int[] firstGlyphCodes;
    private int[] secondGlyphCodes;
    private UnicodeRange[] firstUnicodeRanges;
    private UnicodeRange[] secondUnicodeRanges;
    private float kerningAdjust;

    public Kern(int[] firstGlyphCodes, int[] secondGlyphCodes, UnicodeRange[] firstUnicodeRanges, UnicodeRange[] secondUnicodeRanges, float adjustValue) {
        this.firstGlyphCodes = firstGlyphCodes;
        this.secondGlyphCodes = secondGlyphCodes;
        this.firstUnicodeRanges = firstUnicodeRanges;
        this.secondUnicodeRanges = secondUnicodeRanges;
        this.kerningAdjust = adjustValue;
    }

    public boolean matchesFirstGlyph(int glyphCode, String glyphUnicode) {
        int i = 0;
        while (i < this.firstGlyphCodes.length) {
            if (this.firstGlyphCodes[i] == glyphCode) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.firstUnicodeRanges.length) {
            if (this.firstUnicodeRanges[i2].contains(glyphUnicode)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int glyphCode, String glyphUnicode) {
        int i = 0;
        while (i < this.secondGlyphCodes.length) {
            if (this.secondGlyphCodes[i] == glyphCode) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.secondUnicodeRanges.length) {
            if (this.secondUnicodeRanges[i2].contains(glyphUnicode)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public float getAdjustValue() {
        return this.kerningAdjust;
    }
}

