/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.context.View;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.PageServer;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class MultiViewServer
implements Server {
    private int viewCount = 0;
    private Map views;
    private ViewQueue asynchronouslyUpdatedViews;
    private String sessionID;
    private Configuration configuration;
    private SessionDispatcher.Monitor sessionMonitor;
    private HttpSession session;
    private Server server;
    private ResourceDispatcher resourceDispatcher;

    public MultiViewServer(HttpSession session, String sessionID, SessionDispatcher.Monitor sessionMonitor, Map views, ViewQueue asynchronouslyUpdatedViews, Configuration configuration, ResourceDispatcher resourceDispatcher) {
        this.session = session;
        this.sessionID = sessionID;
        this.sessionMonitor = sessionMonitor;
        this.views = views;
        this.asynchronouslyUpdatedViews = asynchronouslyUpdatedViews;
        this.configuration = configuration;
        this.resourceDispatcher = resourceDispatcher;
        this.server = new PageServer();
    }

    public void service(Request request) throws Exception {
        View view;
        if (request.containsParameter("rvn")) {
            String redirectViewNumber = request.getParameter("rvn");
            view = (View)this.views.get(redirectViewNumber);
            if (view == null) {
                view = new View(redirectViewNumber, this.sessionID, request, this.asynchronouslyUpdatedViews, this.configuration, this.sessionMonitor, this.resourceDispatcher);
                this.views.put(redirectViewNumber, view);
                ContextEventRepeater.viewNumberRetrieved(this.session, this.sessionID, Integer.parseInt(redirectViewNumber));
            } else {
                view.updateOnPageRequest(request);
                view.switchToNormalMode();
            }
        } else {
            String viewNumber = String.valueOf(++this.viewCount);
            view = new View(viewNumber, this.sessionID, request, this.asynchronouslyUpdatedViews, this.configuration, this.sessionMonitor, this.resourceDispatcher);
            this.views.put(viewNumber, view);
            ContextEventRepeater.viewNumberRetrieved(this.session, this.sessionID, Integer.parseInt(viewNumber));
        }
        this.sessionMonitor.touchSession();
        this.server.service(request);
        view.switchToPushMode();
        view.release();
    }

    public void shutdown() {
        this.server.shutdown();
    }
}

