/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.equalvalidator;

import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;
import org.apache.myfaces.validator.ValidatorBase;

public class EqualValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.validator.Equal";
    public static final String EQUAL_MESSAGE_ID = "org.apache.myfaces.Equal.INVALID";
    private String _for = null;

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        UIComponent foreignComp = uiComponent.getParent().findComponent(this._for);
        if (foreignComp == null) {
            throw new FacesException("Unable to find component '" + this._for + "' (calling findComponent on component '" + uiComponent.getId() + "')");
        }
        if (!(foreignComp instanceof EditableValueHolder)) {
            throw new FacesException("Component '" + foreignComp.getId() + "' does not implement EditableValueHolder");
        }
        EditableValueHolder foreignEditableValueHolder = (EditableValueHolder)foreignComp;
        if (foreignEditableValueHolder.isRequired() && foreignEditableValueHolder.getValue() == null) {
            return;
        }
        Object[] args = new Object[]{value.toString(), foreignEditableValueHolder.getValue() == null ? foreignComp.getId() : foreignEditableValueHolder.getValue().toString()};
        if (foreignEditableValueHolder.getValue() == null || !foreignEditableValueHolder.getValue().toString().equals(value.toString())) {
            String message = this.getMessage();
            if (null == message) {
                message = EQUAL_MESSAGE_ID;
            }
            throw new ValidatorException(MessageUtils.getMessage(FacesMessage.SEVERITY_ERROR, message, args));
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[6];
        values[0] = super.saveState(context);
        values[1] = this._for;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._for = (String)values[1];
    }

    public String getFor() {
        return this._for;
    }

    public void setFor(String string) {
        this._for = string;
    }
}

