/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.ClassLoaderUtils;

public class Configuration {
    private static final String DEFAULT_CONFIG_NAME = "cactus";
    private static final String CACTUS_CONFIG_PROPERTY = "cactus.config";
    public static final String CACTUS_CONTEXT_URL_PROPERTY = "cactus.contextURL";
    private static final String CACTUS_CONNECTION_HELPER_CLASSNAME_PROPERTY = "cactus.connectionHelper.classname";
    public static String DEFAULT_CACTUS_CONNECTION_HELPER_CLASSNAME = (class$org$apache$cactus$client$HttpClientConnectionHelper == null ? (class$org$apache$cactus$client$HttpClientConnectionHelper = Configuration.class$("org.apache.cactus.client.HttpClientConnectionHelper")) : class$org$apache$cactus$client$HttpClientConnectionHelper).getName();
    private static boolean isInitialized;
    static Class class$org$apache$cactus$util$Configuration;
    static Class class$org$apache$cactus$client$HttpClientConnectionHelper;

    public static final void initialize() {
        if (!isInitialized) {
            ResourceBundle config;
            String configOverride = System.getProperty(CACTUS_CONFIG_PROPERTY);
            if (configOverride == null) {
                try {
                    config = ClassLoaderUtils.loadPropertyResourceBundle(DEFAULT_CONFIG_NAME, class$org$apache$cactus$util$Configuration == null ? (class$org$apache$cactus$util$Configuration = Configuration.class$("org.apache.cactus.util.Configuration")) : class$org$apache$cactus$util$Configuration);
                }
                catch (MissingResourceException e) {
                    return;
                }
            }
            try {
                config = new PropertyResourceBundle(new FileInputStream(configOverride));
            }
            catch (IOException e) {
                throw new ChainedRuntimeException("Cannot read cactus configuration file [" + configOverride + "]", e);
            }
            Enumeration<String> keys = config.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (System.getProperty(key) != null) continue;
                System.setProperty(key, config.getString(key));
            }
            isInitialized = true;
        }
    }

    public static String getContextURL() {
        Configuration.initialize();
        String contextURL = System.getProperty(CACTUS_CONTEXT_URL_PROPERTY);
        if (contextURL == null) {
            throw new ChainedRuntimeException("Missing Cactus property [cactus.contextURL]");
        }
        return contextURL;
    }

    public static String getConnectionHelper() {
        String connectionHelperClassname = System.getProperty(CACTUS_CONNECTION_HELPER_CLASSNAME_PROPERTY);
        if (connectionHelperClassname == null) {
            connectionHelperClassname = DEFAULT_CACTUS_CONNECTION_HELPER_CLASSNAME;
        }
        return connectionHelperClassname;
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }
}

