/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.jboss.resource.adapter.jdbc.CachedPreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedStatement;

public class WrappedPreparedStatement
extends WrappedStatement
implements PreparedStatement {
    private final PreparedStatement ps;

    public WrappedPreparedStatement(WrappedConnection lc, PreparedStatement ps) {
        super(lc, ps);
        this.ps = ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getUnderlyingStatement() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            if (this.ps instanceof CachedPreparedStatement) {
                PreparedStatement preparedStatement = ((CachedPreparedStatement)this.ps).getUnderlyingPreparedStatement();
                return preparedStatement;
            }
            PreparedStatement preparedStatement = this.ps;
            return preparedStatement;
        }
        finally {
            this.unlock();
        }
    }

    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.checkState();
        try {
            this.ps.setBoolean(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.checkState();
        try {
            this.ps.setByte(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setShort(int parameterIndex, short value) throws SQLException {
        this.checkState();
        try {
            this.ps.setShort(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setInt(int parameterIndex, int value) throws SQLException {
        this.checkState();
        try {
            this.ps.setInt(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setLong(int parameterIndex, long value) throws SQLException {
        this.checkState();
        try {
            this.ps.setLong(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.checkState();
        try {
            this.ps.setFloat(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.checkState();
        try {
            this.ps.setDouble(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.checkState();
        try {
            this.ps.setURL(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.checkState();
        try {
            this.ps.setTime(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setTime(int parameterIndex, Time value, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            this.ps.setTime(parameterIndex, value, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean execute() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                boolean bl = this.ps.execute();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        try {
            return this.ps.getMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                ResultSet resultSet = this.ps.executeQuery();
                ResultSet resultSet2 = this.registerResultSet(resultSet);
                return resultSet2;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    public int executeUpdate() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.checkConfiguredQueryTimeout();
                int n = this.ps.executeUpdate();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.ps.addBatch();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkState();
        try {
            this.ps.setNull(parameterIndex, sqlType);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkState();
        try {
            this.ps.setNull(parameterIndex, sqlType, typeName);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.checkState();
        try {
            this.ps.setBigDecimal(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setString(int parameterIndex, String value) throws SQLException {
        this.checkState();
        try {
            this.ps.setString(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setBytes(int parameterIndex, byte[] value) throws SQLException {
        this.checkState();
        try {
            this.ps.setBytes(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.checkState();
        try {
            this.ps.setDate(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setDate(int parameterIndex, Date value, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            this.ps.setDate(parameterIndex, value, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.checkState();
        try {
            this.ps.setTimestamp(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp value, Calendar calendar) throws SQLException {
        this.checkState();
        try {
            this.ps.setTimestamp(parameterIndex, value, calendar);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.checkState();
        try {
            this.ps.setAsciiStream(parameterIndex, stream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.checkState();
        try {
            this.ps.setUnicodeStream(parameterIndex, stream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.checkState();
        try {
            this.ps.setBinaryStream(parameterIndex, stream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void clearParameters() throws SQLException {
        this.checkState();
        try {
            this.ps.clearParameters();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setObject(int parameterIndex, Object value, int sqlType, int scale) throws SQLException {
        this.checkState();
        try {
            this.ps.setObject(parameterIndex, value, sqlType, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setObject(int parameterIndex, Object value, int sqlType) throws SQLException {
        this.checkState();
        try {
            this.ps.setObject(parameterIndex, value, sqlType);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.checkState();
        try {
            this.ps.setObject(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkState();
        try {
            this.ps.setCharacterStream(parameterIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setRef(int parameterIndex, Ref value) throws SQLException {
        this.checkState();
        try {
            this.ps.setRef(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        this.checkState();
        try {
            this.ps.setBlob(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setClob(int parameterIndex, Clob value) throws SQLException {
        this.checkState();
        try {
            this.ps.setClob(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setArray(int parameterIndex, Array value) throws SQLException {
        this.checkState();
        try {
            this.ps.setArray(parameterIndex, value);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkState();
        try {
            return this.ps.getParameterMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }
}

