/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util.asm;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.Attribute;
import org.drools.asm.ClassReader;
import org.drools.asm.ClassVisitor;
import org.drools.asm.FieldVisitor;
import org.drools.asm.MethodVisitor;

public class ClassFieldInspector {
    private final List methods = new ArrayList();
    private final Map fieldNames = new HashMap();
    private final Map fieldTypes = new HashMap();
    private final Map methodNames = new HashMap();
    private final Set nonGetters = new HashSet();

    public ClassFieldInspector(Class clazz) throws IOException {
        String string = this.getResourcePath(clazz);
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream != null) {
            this.processClassWithByteCode(clazz, inputStream);
        } else {
            this.processClassWithoutByteCode(clazz);
        }
    }

    private void processClassWithByteCode(Class clazz, InputStream inputStream) throws IOException {
        Class<?>[] classArray;
        ClassReader classReader = new ClassReader(inputStream);
        ClassFieldVisitor classFieldVisitor = new ClassFieldVisitor(clazz, this);
        classReader.accept(classFieldVisitor, false);
        if (clazz.getSuperclass() != null) {
            classArray = this.getResourcePath(clazz.getSuperclass());
            InputStream inputStream2 = clazz.getResourceAsStream((String)classArray);
            if (inputStream2 != null) {
                this.processClassWithByteCode(clazz.getSuperclass(), inputStream2);
            } else {
                this.processClassWithoutByteCode(clazz.getSuperclass());
            }
        }
        if (clazz.isInterface()) {
            classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                String string = this.getResourcePath(classArray[i]);
                InputStream inputStream3 = clazz.getResourceAsStream(string);
                if (inputStream3 != null) {
                    this.processClassWithByteCode(classArray[i], inputStream3);
                    continue;
                }
                this.processClassWithoutByteCode(classArray[i]);
            }
        }
    }

    private void processClassWithoutByteCode(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if ((methodArray[i].getModifiers() & 1) <= 0 || methodArray[i].getParameterTypes().length != 0 || methodArray[i].getName().equals("<init>") || methodArray[i].getReturnType() == Void.TYPE) continue;
            int n = this.methods.size();
            this.addToMapping(methodArray[i], n);
        }
    }

    private String getResourcePath(Class clazz) {
        return "/" + clazz.getName().replace('.', '/') + ".class";
    }

    public List getPropertyGetters() {
        return this.methods;
    }

    public Map getFieldNames() {
        return this.fieldNames;
    }

    public Map getFieldTypes() {
        return this.fieldTypes;
    }

    public Map getGetterMethods() {
        return this.methodNames;
    }

    private void addToMapping(Method method, int n) {
        String string;
        int n2 = (string = method.getName()).startsWith("is") ? 2 : (string.startsWith("get") ? 3 : 0);
        String string2 = this.calcFieldName(string, n2);
        if (this.fieldNames.containsKey(string2)) {
            if (n2 != 0 && this.nonGetters.contains(string2)) {
                this.removeOldField(string2);
                this.storeField(method, n, string2);
                this.nonGetters.remove(string2);
            }
        } else {
            this.storeField(method, n, string2);
            if (n2 == 0) {
                this.nonGetters.add(string2);
            }
        }
    }

    private void removeOldField(String string) {
        this.fieldNames.remove(string);
        this.fieldTypes.remove(string);
        this.methods.remove(this.methodNames.get(string));
        this.methodNames.remove(string);
    }

    private void storeField(Method method, int n, String string) {
        this.fieldNames.put(string, new Integer(n));
        this.fieldTypes.put(string, method.getReturnType());
        this.methodNames.put(string, method);
        this.methods.add(method);
    }

    private String calcFieldName(String string, int n) {
        string = string.substring(n);
        return Introspector.decapitalize(string);
    }

    static class ClassFieldAnnotationVisitor
    implements AnnotationVisitor {
        ClassFieldAnnotationVisitor() {
        }

        public void visit(String string, Object object) {
        }

        public void visitEnum(String string, String string2, String string3) {
        }

        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return new ClassFieldAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String string) {
            return new ClassFieldAnnotationVisitor();
        }

        public void visitEnd() {
        }
    }

    static class ClassFieldVisitor
    implements ClassVisitor {
        private Class clazz;
        private ClassFieldInspector inspector;

        ClassFieldVisitor(Class clazz, ClassFieldInspector classFieldInspector) {
            this.clazz = clazz;
            this.inspector = classFieldInspector;
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if ((n & 1) > 0 && string2.startsWith("()") && !string.equals("<init>")) {
                try {
                    Method method = this.clazz.getMethod(string, null);
                    if (method.getReturnType() != Void.TYPE) {
                        int n2 = this.inspector.methods.size();
                        this.inspector.addToMapping(method, n2);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException("Error in getting field access method.");
                }
            }
            return null;
        }

        public void visit(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        }

        public void visitInnerClass(String string, String string2, String string3, int n) {
        }

        public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        }

        public void visitAttribute(Attribute attribute) {
        }

        public void visitEnd() {
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        }

        public void visitSource(String string, String string2) {
        }

        public void visitOuterClass(String string, String string2, String string3) {
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            return new ClassFieldAnnotationVisitor();
        }

        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            return null;
        }
    }
}

