/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldConstraint;
import org.drools.spi.FieldExtractor;
import org.drools.spi.FieldValue;
import org.drools.spi.Tuple;

public class LiteralConstraint
implements FieldConstraint {
    private static final long serialVersionUID = 257543929585046195L;
    private final FieldValue field;
    private final FieldExtractor extractor;
    private final Evaluator evaluator;
    private static final Declaration[] requiredDeclarations = new Declaration[0];

    public LiteralConstraint(FieldValue fieldValue, FieldExtractor fieldExtractor, Evaluator evaluator) {
        this.field = fieldValue;
        this.extractor = fieldExtractor;
        this.evaluator = evaluator;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public FieldValue getField() {
        return this.field;
    }

    public FieldExtractor getFieldExtractor() {
        return this.extractor;
    }

    public Declaration[] getRequiredDeclarations() {
        return requiredDeclarations;
    }

    public boolean isAllowed(InternalFactHandle internalFactHandle, Tuple tuple, WorkingMemory workingMemory) {
        return this.evaluator.evaluate(this.extractor.getValue(internalFactHandle.getObject()), this.field.getValue());
    }

    public String toString() {
        return "[LiteralConstraint fieldExtractor=" + this.extractor + " evaluator=" + this.evaluator + " value=" + this.field.getValue() + "]";
    }

    public int hashCode() {
        return this.field.hashCode() * 17 ^ this.extractor.hashCode() * 11 ^ this.evaluator.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != LiteralConstraint.class) {
            return false;
        }
        LiteralConstraint literalConstraint = (LiteralConstraint)object;
        return this.field.equals(literalConstraint.field) && this.extractor.equals(literalConstraint.extractor) && this.evaluator.equals(literalConstraint.evaluator);
    }
}

