/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.metamata.AbstractMetamataTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;

public class MParse
extends AbstractMetamataTask {
    private File target = null;
    private boolean verbose = false;
    private boolean debugparser = false;
    private boolean debugscanner = false;
    private boolean cleanup = false;

    public void setTarget(File target) {
        this.target = target;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void setDebugscanner(boolean flag) {
        this.debugscanner = flag;
    }

    public void setDebugparser(boolean flag) {
        this.debugparser = flag;
    }

    public void setCleanup(boolean value) {
        this.cleanup = value;
    }

    public MParse() {
        this.cmdl.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.cmdl.setClassname("com.metamata.jj.MParse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            this.setUp();
            ExecuteStreamHandler handler = this.createStreamHandler();
            this._execute(handler);
        }
        finally {
            this.cleanUp();
        }
    }

    protected ExecuteStreamHandler createStreamHandler() {
        return new LogStreamHandler((Task)this, 2, 2);
    }

    protected void setUp() throws BuildException {
        this.checkOptions();
        File[] jars = this.getMetamataLibs();
        Path classPath = this.cmdl.createClasspath(this.getProject());
        for (int i = 0; i < jars.length; ++i) {
            classPath.createPathElement().setLocation(jars[i]);
        }
        Commandline.Argument vmArgs = this.cmdl.createVmArgument();
        vmArgs.setValue("-Dmetamata.home=" + this.metamataHome.getAbsolutePath());
        Vector opts = this.getOptions();
        Object[] options = new String[opts.size()];
        opts.copyInto(options);
        this.optionsFile = this.createTmpFile();
        this.generateOptionsFile(this.optionsFile, (String[])options);
        Commandline.Argument args = this.cmdl.createArgument();
        args.setLine("-arguments " + this.optionsFile.getAbsolutePath());
    }

    protected void _execute(ExecuteStreamHandler handler) throws BuildException {
        String pathname = this.target.getAbsolutePath();
        int pos = pathname.length() - ".jj".length();
        File javaFile = new File(pathname = pathname.substring(0, pos) + ".java");
        if (javaFile.exists() && this.target.lastModified() < javaFile.lastModified()) {
            this.getProject().log("Target is already build - skipping (" + this.target + ")");
            return;
        }
        Execute process = new Execute(handler);
        this.log(this.cmdl.describeCommand(), 3);
        process.setCommandline(this.cmdl.getCommandline());
        try {
            if (process.execute() != 0) {
                throw new BuildException("Metamata task failed.");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to launch Metamata task: ", (Throwable)e);
        }
    }

    protected void cleanUp() {
        if (this.optionsFile != null) {
            this.optionsFile.delete();
            this.optionsFile = null;
        }
        if (this.cleanup) {
            String name = this.target.getName();
            int pos = name.length() - ".jj".length();
            name = "__jj" + name.substring(0, pos) + ".sunjj";
            File sunjj = new File(this.target.getParent(), name);
            if (sunjj.exists()) {
                this.getProject().log("Removing stale file: " + sunjj.getName());
                sunjj.delete();
            }
        }
    }

    protected File[] getMetamataLibs() {
        Vector<File> files = new Vector<File>();
        files.addElement(new File(this.metamataHome, "lib/metamata.jar"));
        files.addElement(new File(this.metamataHome, "bin/lib/JavaCC.zip"));
        Object[] array = new File[files.size()];
        files.copyInto(array);
        return array;
    }

    protected void checkOptions() throws BuildException {
        if (this.metamataHome == null || !this.metamataHome.exists()) {
            throw new BuildException("'metamatahome' must point to Metamata home directory.");
        }
        this.metamataHome = this.getProject().resolveFile(this.metamataHome.getPath());
        File[] jars = this.getMetamataLibs();
        for (int i = 0; i < jars.length; ++i) {
            if (jars[i].exists()) continue;
            throw new BuildException(jars[i] + " does not exist. Check your metamata installation.");
        }
        if (this.target == null || !this.target.isFile() || !this.target.getName().endsWith(".jj")) {
            throw new BuildException("Invalid target: " + this.target);
        }
        this.target = this.getProject().resolveFile(this.target.getPath());
    }

    protected Vector getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.verbose) {
            options.addElement("-verbose");
        }
        if (this.debugscanner) {
            options.addElement("-ds");
        }
        if (this.debugparser) {
            options.addElement("-dp");
        }
        if (this.classPath != null) {
            options.addElement("-classpath");
            options.addElement(this.classPath.toString());
        }
        if (this.sourcePath != null) {
            options.addElement("-sourcepath");
            options.addElement(this.sourcePath.toString());
        }
        options.addElement(this.target.getAbsolutePath());
        return options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateOptionsFile(File tofile, String[] options) throws BuildException {
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(tofile);
                PrintWriter pw = new PrintWriter(fw);
                for (int i = 0; i < options.length; ++i) {
                    pw.println(options[i]);
                }
                pw.flush();
            }
            catch (IOException e) {
                throw new BuildException("Error while writing options file " + tofile, (Throwable)e);
            }
            Object var7_7 = null;
            if (fw == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        fw.close();
        return;
    }
}

