/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.taglib;

import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;
import org.ajax4jsf.framework.taglib.SimpleActionMethodBinding;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UIComponentTagBase
extends UIComponentTag {
    private String _value;
    private String _converter;
    private static final Log log = LogFactory.getLog((Class)UIComponentTagBase.class);
    private static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    private static final Class[] VALUE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};

    public void setConverter(String converter) {
        this._converter = converter;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void release() {
        super.release();
        this._value = null;
        this._converter = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        this.setValueProperty(component, this._value);
        this.setConverterProperty(component, this._converter);
    }

    protected void setCharterProperty(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, new Character(value.charAt(0)));
            }
        }
    }

    protected void setIntegerProperty(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Integer.valueOf(value));
            }
        }
    }

    protected void setLongProperty(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Long.valueOf(value));
            }
        }
    }

    protected void setFloatProperty(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Float.valueOf(value));
            }
        }
    }

    protected void setDoubleProperty(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Double.valueOf(value));
            }
        }
    }

    protected void setStringProperty(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, value);
            }
        }
    }

    protected void setBooleanProperty(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Boolean.valueOf(value));
            }
        }
    }

    protected void setValueProperty(UIComponent component, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding("value", vb);
            } else if (component instanceof UICommand) {
                ((UICommand)component).setValue((Object)value);
            } else if (component instanceof UIParameter) {
                ((UIParameter)component).setValue((Object)value);
            } else if (component instanceof UISelectBoolean) {
                ((UISelectBoolean)component).setValue((Object)Boolean.valueOf(value));
            } else if (component instanceof UIGraphic) {
                ((UIGraphic)component).setValue((Object)value);
            } else if (component instanceof ValueHolder) {
                ((ValueHolder)component).setValue((Object)value);
            } else {
                component.getAttributes().put("value", value);
            }
        }
    }

    protected void setConverterProperty(UIComponent component, String value) {
        if (value != null) {
            if (component instanceof ValueHolder) {
                if (UIComponentTagBase.isValueReference((String)value)) {
                    ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                    component.setValueBinding("converter", vb);
                } else {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    Converter converter = facesContext.getApplication().createConverter(value);
                    ((ValueHolder)component).setConverter(converter);
                }
            } else {
                log.error((Object)Messages.getMessage("NO_VALUE_HOLDER_ERROR", component.getClass().getName()));
            }
        }
    }

    protected void setValidatorProperty(UIComponent component, String validator) {
        if (validator != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException(Messages.getMessage("NO_EDITABLE_VALUE_HOLDER_ERROR", component.getId()));
            }
            if (UIComponentTagBase.isValueReference((String)validator)) {
                MethodBinding mb = this.getFacesContext().getApplication().createMethodBinding(validator, VALIDATOR_ARGS);
                ((EditableValueHolder)component).setValidator(mb);
            } else {
                log.error((Object)Messages.getMessage("INVALID_VALIDATION_EXPRESSION", component.getId(), validator));
            }
        }
    }

    protected void setActionProperty(UIComponent component, String action) {
        if (action != null) {
            if (!(component instanceof ActionSource)) {
                throw new IllegalArgumentException(Messages.getMessage("NO_ACTION_SOURCE_ERROR", component.getClientId(this.getFacesContext())));
            }
            SimpleActionMethodBinding mb = UIComponentTagBase.isValueReference((String)action) ? this.getFacesContext().getApplication().createMethodBinding(action, null) : new SimpleActionMethodBinding(action);
            ((ActionSource)component).setAction((MethodBinding)mb);
        }
    }

    protected void setActionListenerProperty(UIComponent component, String actionListener) {
        if (actionListener != null) {
            if (!(component instanceof ActionSource)) {
                throw new IllegalArgumentException(Messages.getMessage("NO_ACTION_SOURCE_ERROR", component.getClientId(this.getFacesContext())));
            }
            if (UIComponentTagBase.isValueReference((String)actionListener)) {
                MethodBinding mb = this.getFacesContext().getApplication().createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                ((ActionSource)component).setActionListener(mb);
            } else {
                log.error((Object)Messages.getMessage("INVALID_ACTION_LISTENER", component.getClientId(this.getFacesContext()), actionListener));
            }
        }
    }

    protected void setValueChangedListenerProperty(UIComponent component, String valueChangedListener) {
        if (valueChangedListener != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException(Messages.getMessage("NO_EDITABLE_VALUE_HOLDER_ERROR", component.getClientId(this.getFacesContext())));
            }
            if (UIComponentTagBase.isValueReference((String)valueChangedListener)) {
                MethodBinding mb = this.getFacesContext().getApplication().createMethodBinding(valueChangedListener, VALUE_LISTENER_ARGS);
                ((EditableValueHolder)component).setValueChangeListener(mb);
            } else {
                log.error((Object)Messages.getMessage("INVALID_VALUE_CHANGE_LISTENER", component.getClientId(this.getFacesContext()), valueChangedListener));
            }
        }
    }

    protected void setValueBinding(UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagBase.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                throw new IllegalArgumentException(Messages.getMessage("NO_VALUE_REFERENCE_ERROR", new Object[]{component.getId(), propName, value}));
            }
        }
    }
}

