/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.ajax.AjaxChildrenEncoder;
import org.ajax4jsf.framework.ajax.AjaxOutput;
import org.ajax4jsf.framework.renderer.AjaxComponentRendererBase;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AjaxChildrenRenderer
extends AjaxComponentRendererBase {
    public static final Log log = LogFactory.getLog((Class)AjaxChildrenRenderer.class);
    public static final String[] SPECIAL_COMPONENTS_TYPES = new String[]{"org.ajax4jsf.ajax.Bundle", "org.apache.myfaces.AliasBean", "org.apache.myfaces.AliasBeansScope"};
    private static final String SPECIAL_TYPES_PARAMETER = "org.ajax4jsf.CONTROL_COMPONENTS";
    private Set _specialComponentTypes = null;

    public void encodeAjaxChild(FacesContext context, UIComponent component, String path, Set ids, Set renderedAreas) throws IOException {
        this.encodeAjaxChildren(context, component, path, ids, renderedAreas);
    }

    public void encodeAjaxChildren(FacesContext context, UIComponent component, String path, Set ids, Set renderedAreas) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("ENCODE_CHILD_AJAX_INFO", path, component.getId()));
        }
        String currentPath = path;
        if (component instanceof NamingContainer) {
            currentPath = currentPath + component.getId() + ':';
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent element = (UIComponent)it.next();
            this.encodeAjaxComponent(context, element, currentPath, ids, renderedAreas);
        }
    }

    public void encodeAjaxComponent(FacesContext context, UIComponent component, String currentPath, Set ids, Set renderedAreas) throws IOException {
        if (component.isRendered()) {
            boolean found = false;
            if (!ids.isEmpty()) {
                String elementId = component.getId();
                String absoluteId = currentPath + elementId;
                if (ids.contains(absoluteId) || ids.contains(elementId)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("RENDER_AJAX_AREA_INFO", absoluteId));
                    }
                    found = true;
                }
            }
            if (!found && component instanceof AjaxOutput && ((AjaxOutput)component).isAjaxRendered()) {
                found = true;
            }
            if (!found) {
                if (component instanceof AjaxChildrenEncoder) {
                    ((AjaxChildrenEncoder)component).encodeAjaxChild(context, currentPath, ids, renderedAreas);
                } else {
                    boolean special = this.isSpecialElement(context, component);
                    if (special) {
                        component.encodeBegin(context);
                    }
                    this.encodeAjaxChildren(context, component, currentPath, ids, renderedAreas);
                    if (special) {
                        component.encodeEnd(context);
                    }
                }
            } else {
                renderedAreas.add(component.getClientId(context));
                this.renderChild(context, component);
            }
        }
    }

    private boolean isSpecialElement(FacesContext context, UIComponent component) {
        boolean result;
        if (this._specialComponentTypes == null) {
            this._specialComponentTypes = new HashSet(10);
            for (int i = 0; i < SPECIAL_COMPONENTS_TYPES.length; ++i) {
                this._specialComponentTypes.add(SPECIAL_COMPONENTS_TYPES[i]);
            }
            String special = context.getExternalContext().getInitParameter(SPECIAL_TYPES_PARAMETER);
            if (null != special) {
                String[] split = special.split(",");
                for (int i = 0; i < split.length; ++i) {
                    this._specialComponentTypes.add(split[i]);
                }
            }
        }
        try {
            String componentType = (String)component.getClass().getField("COMPONENT_TYPE").get(null);
            result = this._specialComponentTypes.contains(componentType);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

