/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax.xmlfilter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.framework.ajax.xmlfilter.BaseFilter;
import org.ajax4jsf.framework.ajax.xmlfilter.FilterServletResponseWrapper;
import org.ajax4jsf.framework.ajax.xmlfilter.HtmlParser;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseXMLFilter {
    private static final Log log = LogFactory.getLog((Class)BaseXMLFilter.class);
    public static final String RESPONSE_WRAPPER_ATTRIBUTE = "com.exade.vcp.Filter.ResponseWrapper";
    private String mimetype = "text/xml";
    private String publicid = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private String systemid = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private String namespace = "http://www.w3.org/1999/xhtml";
    private static final String MIME_TYPE_PARAMETER = "mime-type";
    private static final String PUBLICID_PARAMETER = "publicid";
    private static final String SYSTEMID_PARAMETER = "systemid";
    private static final String NAMESPACE_PARAMETER = "namespace";
    private boolean forcexml = false;
    private static final String FORCEXML_PARAMETER = "forceparser";
    public BaseFilter filter;

    public void setFilter(BaseFilter filter) {
        this.filter = filter;
    }

    public void init(FilterConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init XML filter service with class " + this.getClass().getName()));
        }
        if ("false".equalsIgnoreCase(config.getInitParameter(FORCEXML_PARAMETER))) {
            this.forcexml = false;
        }
        if ("true".equalsIgnoreCase(config.getInitParameter(FORCEXML_PARAMETER))) {
            this.forcexml = true;
        }
        this.setMimetype((String)this.nz(config.getInitParameter(MIME_TYPE_PARAMETER), "text/xml"));
        this.setPublicid((String)this.nz(config.getInitParameter(PUBLICID_PARAMETER), this.getPublicid()));
        this.setSystemid((String)this.nz(config.getInitParameter(SYSTEMID_PARAMETER), this.getSystemid()));
        this.setNamespace((String)this.nz(config.getInitParameter(NAMESPACE_PARAMETER), this.getNamespace()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doXmlFilter(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Writer output;
        if (log.isDebugEnabled()) {
            log.debug((Object)"XML filter service start processing request");
        }
        FilterServletResponseWrapper servletResponseWrapper = this.getWrapper(response);
        request.setAttribute(RESPONSE_WRAPPER_ATTRIBUTE, (Object)servletResponseWrapper);
        chain.doFilter((ServletRequest)request, (ServletResponse)servletResponseWrapper);
        HtmlParser parser = null;
        String redirectLocation = servletResponseWrapper.getRedirectLocation();
        String characterEncoding = servletResponseWrapper.getCharacterEncoding();
        if (null != redirectLocation) {
            if (this.isAjaxRequest((ServletRequest)request)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create AJAX redirect response to url: " + redirectLocation));
                }
                response.reset();
                Iterator iter = servletResponseWrapper.getCookies().iterator();
                while (iter.hasNext()) {
                    Cookie cookie = (Cookie)iter.next();
                    response.addCookie(cookie);
                }
                Map headers = servletResponseWrapper.getHeaders();
                Iterator iter2 = headers.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry header = iter2.next();
                    response.setHeader((String)header.getKey(), (String)header.getValue());
                }
                response.setHeader("Ajax-Response", "redirect");
                response.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0, no-store");
                response.setHeader("Expires", "0");
                response.setHeader("Pragma", "no-cache");
                response.setContentType(this.getMimetype() + ";charset=UTF-8");
                response.setHeader("Location", redirectLocation);
                Writer output2 = this.createResponseWriter(response, "UTF-8");
                output2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta name=\"Ajax-Response\" content=\"redirect\" /><meta name=\"Location\" content=\"" + redirectLocation + "\" />" + "</head></html>");
                output2.flush();
                response.flushBuffer();
            } else {
                response.sendRedirect(redirectLocation);
            }
            return;
        }
        if ("true".equals(servletResponseWrapper.getHeaders().get("Ajax-Response"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Process response to well-formed XML for AJAX XMLHttpRequest parser");
            }
            response.setHeader("Cache-Control", "no-cache, must-revalidate, max_age=0, no-store");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            String outputEncoding = "UTF-8";
            String contentType = this.getMimetype() + ";charset=" + outputEncoding;
            response.setContentType(contentType);
            parser = this.getParser(this.getMimetype(), true);
            if (null == parser) {
                throw new ServletException(Messages.getMessage("PARSER_NOT_INSTANTIATED_ERROR", contentType));
            }
            output = this.createResponseWriter(response, outputEncoding);
            parser.setDoctype(this.getPublicid());
            parser.setInputEncoding(characterEncoding);
            parser.setOutputEncoding(outputEncoding);
            parser.setViewState((String)request.getAttribute("org.ajax4jsf.view.serializedstate"));
        } else {
            String contentType = servletResponseWrapper.getContentType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("create HTML/XML parser for content type: " + contentType));
            }
            if (contentType != null) {
                if (contentType.indexOf("charset") < 0 && null != characterEncoding) {
                    contentType = contentType + ";charset=" + characterEncoding;
                }
                parser = this.getParser(contentType, false);
                response.setContentType(contentType);
            }
            if (null == parser) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Parser not have support for the such content type, send response as-is");
                }
                if (servletResponseWrapper.isUseWriter()) {
                    Writer output3 = this.createResponseWriter(response, characterEncoding);
                    servletResponseWrapper.sendContent(output3);
                } else if (servletResponseWrapper.isUseStream()) {
                    ServletOutputStream out = response.getOutputStream();
                    servletResponseWrapper.sendContent(out);
                }
                return;
            }
            output = this.createResponseWriter(response, characterEncoding);
            parser.setInputEncoding(characterEncoding);
            parser.setOutputEncoding(characterEncoding);
        }
        try {
            parser.setScripts((Set)request.getAttribute("org.ajax4jsf.framework.HEADER_SCRIPTS"));
            parser.setStyles((Set)request.getAttribute("org.ajax4jsf.framework.HEADER_STYLES"));
            long startTimeMills = System.currentTimeMillis();
            servletResponseWrapper.parseContent(output, parser);
            if (log.isDebugEnabled()) {
                startTimeMills = System.currentTimeMillis() - startTimeMills;
                log.debug((Object)Messages.getMessage("PARSING_TIME_INFO", "" + startTimeMills));
            }
        }
        catch (Exception e) {
            throw new ServletException(Messages.getMessage("JTIDY_PARSING_ERROR"), (Throwable)e);
        }
        finally {
            this.reuseParser(parser);
        }
    }

    protected FilterServletResponseWrapper getWrapper(HttpServletResponse response) throws ServletException {
        return new FilterServletResponseWrapper(response);
    }

    protected boolean isAjaxRequest(ServletRequest request) {
        try {
            return null != request.getParameter("AJAXREQUEST");
        }
        catch (Exception e) {
            return false;
        }
    }

    private Writer createResponseWriter(HttpServletResponse response, String characterEncoding) throws IOException, UnsupportedEncodingException {
        Writer output;
        try {
            output = response.getWriter();
        }
        catch (IllegalStateException e) {
            output = null != characterEncoding ? new OutputStreamWriter((OutputStream)response.getOutputStream(), characterEncoding) : new OutputStreamWriter((OutputStream)response.getOutputStream());
        }
        return output;
    }

    protected abstract void reuseParser(HtmlParser var1);

    protected abstract HtmlParser getParser(String var1, boolean var2);

    protected void setPublicid(String publicid) {
        this.publicid = publicid;
    }

    public String getPublicid() {
        return this.publicid;
    }

    protected void setSystemid(String systemid) {
        this.systemid = systemid;
    }

    public String getSystemid() {
        return this.systemid;
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    protected String getMimetype() {
        return this.mimetype;
    }

    public boolean isForcexml() {
        return this.forcexml;
    }

    protected void setForcexml(boolean forcexml) {
        this.forcexml = forcexml;
    }

    private Object nz(Object param, Object def) {
        return param != null ? param : def;
    }
}

