/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.access;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.access.InvalidInvocationException;
import org.springframework.jmx.access.InvocationFailureException;
import org.springframework.jmx.access.MBeanInfoRetrievalException;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.jmx.support.ObjectNameManager;

public class MBeanClientInterceptor
implements MethodInterceptor,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MBeanServerConnection server;
    private JMXServiceURL serviceUrl;
    private String agentId;
    private boolean connectOnStartup = true;
    private ObjectName objectName;
    private boolean useStrictCasing = true;
    private JMXConnector connector;
    private Map allowedAttributes;
    private Map allowedOperations;
    private final Map signatureCache = new HashMap();

    public void setServer(MBeanServerConnection server) {
        this.server = server;
    }

    public void setServiceUrl(String url) throws MalformedURLException {
        this.serviceUrl = new JMXServiceURL(url);
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setConnectOnStartup(boolean connectOnStartup) {
        this.connectOnStartup = connectOnStartup;
    }

    public void setObjectName(Object objectName) throws MalformedObjectNameException {
        this.objectName = ObjectNameManager.getInstance(objectName);
    }

    public void setUseStrictCasing(boolean useStrictCasing) {
        this.useStrictCasing = useStrictCasing;
    }

    public void afterPropertiesSet() throws MBeanServerNotFoundException, MBeanInfoRetrievalException {
        if (this.connectOnStartup) {
            if (this.server == null) {
                this.connect();
            }
            this.retrieveMBeanInfo();
        }
    }

    private void connect() throws MBeanServerNotFoundException {
        if (this.serviceUrl != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting to remote MBeanServer at URL [" + this.serviceUrl + "]"));
            }
            try {
                this.connector = JMXConnectorFactory.connect(this.serviceUrl);
                this.server = this.connector.getMBeanServerConnection();
            }
            catch (IOException ex) {
                throw new MBeanServerNotFoundException("Could not connect to remote MBeanServer at URL [" + this.serviceUrl + "]", ex);
            }
        } else {
            this.logger.debug((Object)"Attempting to locate local MBeanServer");
            this.server = this.locateMBeanServer(this.agentId);
        }
    }

    protected MBeanServer locateMBeanServer(String agentId) throws MBeanServerNotFoundException {
        return JmxUtils.locateMBeanServer(agentId);
    }

    private void retrieveMBeanInfo() throws MBeanServerNotFoundException, MBeanInfoRetrievalException {
        try {
            MBeanInfo info = this.server.getMBeanInfo(this.objectName);
            MBeanAttributeInfo[] attributeInfo = info.getAttributes();
            this.allowedAttributes = new HashMap(attributeInfo.length);
            for (int x = 0; x < attributeInfo.length; ++x) {
                this.allowedAttributes.put(attributeInfo[x].getName(), attributeInfo[x]);
            }
            MBeanOperationInfo[] operationInfo = info.getOperations();
            this.allowedOperations = new HashMap(operationInfo.length);
            for (int x = 0; x < operationInfo.length; ++x) {
                MBeanOperationInfo opInfo = operationInfo[x];
                this.allowedOperations.put(new MethodCacheKey(opInfo.getName(), JmxUtils.parameterInfoToTypes(opInfo.getSignature())), opInfo);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new MBeanInfoRetrievalException("Unable to locate class specified in method signature", ex);
        }
        catch (IntrospectionException ex) {
            throw new MBeanInfoRetrievalException("Unable to obtain MBean info for bean [" + this.objectName + "]", ex);
        }
        catch (InstanceNotFoundException ex) {
            throw new MBeanInfoRetrievalException("Unable to obtain MBean info for bean [" + this.objectName + "]: it is likely that this bean was unregistered during the proxy creation process", ex);
        }
        catch (ReflectionException ex) {
            throw new MBeanInfoRetrievalException("Unable to read MBean info for bean [ " + this.objectName + "]", ex);
        }
        catch (IOException ex) {
            throw new MBeanInfoRetrievalException("An IOException occurred when communicating with the MBeanServer. It is likely that you are communicating with a remote MBeanServer. Check the inner exception for exact details.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.connectOnStartup) {
            MBeanClientInterceptor mBeanClientInterceptor = this;
            synchronized (mBeanClientInterceptor) {
                if (this.server == null) {
                    this.logger.debug((Object)"Lazily establishing MBeanServer connection");
                    this.connect();
                }
                if (this.allowedAttributes == null) {
                    this.logger.debug((Object)"Lazily initializing MBeanInfo cache");
                    this.retrieveMBeanInfo();
                }
            }
        }
        try {
            PropertyDescriptor pd = BeanUtils.findPropertyForMethod(invocation.getMethod());
            if (pd != null) {
                return this.invokeAttribute(pd, invocation);
            }
            return this.invokeOperation(invocation.getMethod(), invocation.getArguments());
        }
        catch (JMException ex) {
            throw new InvocationFailureException("JMX access failed", ex);
        }
        catch (IOException ex) {
            throw new InvocationFailureException("JMX access failed", ex);
        }
    }

    private Object invokeAttribute(PropertyDescriptor pd, MethodInvocation invocation) throws JMException, IOException {
        String attributeName = JmxUtils.getAttributeName(pd, this.useStrictCasing);
        MBeanAttributeInfo inf = (MBeanAttributeInfo)this.allowedAttributes.get(attributeName);
        if (inf == null) {
            throw new InvalidInvocationException("Attribute '" + pd.getName() + "' is not exposed on the management interface");
        }
        if (invocation.getMethod().equals(pd.getReadMethod())) {
            if (inf.isReadable()) {
                return this.server.getAttribute(this.objectName, attributeName);
            }
            throw new InvalidInvocationException("Attribute '" + attributeName + "' is not readable");
        }
        if (invocation.getMethod().equals(pd.getWriteMethod())) {
            if (inf.isWritable()) {
                this.server.setAttribute(this.objectName, new Attribute(attributeName, invocation.getArguments()[0]));
                return null;
            }
            throw new InvalidInvocationException("Attribute '" + attributeName + "' is not writable");
        }
        throw new IllegalStateException("Method [" + invocation.getMethod() + "] is neither a bean property getter nor a setter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeOperation(Method method, Object[] args) throws JMException, IOException {
        MethodCacheKey key = new MethodCacheKey(method.getName(), method.getParameterTypes());
        MBeanOperationInfo info = (MBeanOperationInfo)this.allowedOperations.get(key);
        if (info == null) {
            throw new InvalidInvocationException("Operation '" + method.getName() + "' is not exposed on the management interface");
        }
        String[] signature = null;
        Map map = this.signatureCache;
        synchronized (map) {
            signature = (String[])this.signatureCache.get(method);
            if (signature == null) {
                signature = JmxUtils.getMethodSignature(method);
                this.signatureCache.put(method, signature);
            }
        }
        return this.server.invoke(this.objectName, method.getName(), args, signature);
    }

    public void destroy() throws Exception {
        if (this.connector != null) {
            this.connector.close();
        }
    }

    private static class MethodCacheKey {
        private final String name;
        private final Class[] parameters;

        public MethodCacheKey(String name, Class[] parameters) {
            this.name = name;
            this.parameters = parameters == null ? new Class[0] : parameters;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            MethodCacheKey otherKey = null;
            if (other instanceof MethodCacheKey) {
                otherKey = (MethodCacheKey)other;
                return this.name.equals(otherKey.name) && Arrays.equals(this.parameters, otherKey.parameters);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

