/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ApplicationConfig;
import org.apache.struts.util.MessageResources;

public class Action {
    public static final String ACTION_SERVLET_KEY = "org.apache.struts.action.ACTION_SERVLET";
    public static final String APPLICATION_KEY = "org.apache.struts.action.APPLICATION";
    public static final String DATA_SOURCE_KEY = "org.apache.struts.action.DATA_SOURCE";
    public static final String ERROR_KEY = "org.apache.struts.action.ERROR";
    public static final String EXCEPTION_KEY = "org.apache.struts.action.EXCEPTION";
    public static final String FORM_BEANS_KEY = "org.apache.struts.action.FORM_BEANS";
    public static final String FORWARDS_KEY = "org.apache.struts.action.FORWARDS";
    public static final String LOCALE_KEY = "org.apache.struts.action.LOCALE";
    public static final String MAPPING_KEY = "org.apache.struts.action.mapping.instance";
    public static final String MAPPINGS_KEY = "org.apache.struts.action.MAPPINGS";
    public static final String MESSAGE_KEY = "org.apache.struts.action.ACTION_MESSAGE";
    public static final String MESSAGES_KEY = "org.apache.struts.action.MESSAGE";
    public static final String MULTIPART_KEY = "org.apache.struts.action.mapping.multipartclass";
    public static final String PLUG_INS_KEY = "org.apache.struts.action.PLUG_INS";
    public static final String REQUEST_PROCESSOR_KEY = "org.apache.struts.action.REQUEST_PROCESSOR";
    public static final String SERVLET_KEY = "org.apache.struts.action.SERVLET_MAPPING";
    public static final String TRANSACTION_TOKEN_KEY = "org.apache.struts.action.TOKEN";
    protected static Locale defaultLocale;
    protected ActionServlet servlet = null;

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws Exception {
        return this.perform(mapping, form, request, response);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.perform(mapping, form, request, response);
    }

    public ActionForward perform(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            return this.perform(mapping, form, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return null;
    }

    protected String generateToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        try {
            byte[] id = session.getId().getBytes();
            byte[] now = new Long(System.currentTimeMillis()).toString().getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id);
            md.update(now);
            return this.toHex(md.digest());
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    protected DataSource getDataSource(HttpServletRequest request) {
        return this.getDataSource(request, DATA_SOURCE_KEY);
    }

    protected DataSource getDataSource(HttpServletRequest request, String key) {
        ServletContext context = this.getServlet().getServletContext();
        ApplicationConfig appConfig = (ApplicationConfig)request.getAttribute(APPLICATION_KEY);
        if (appConfig == null) {
            appConfig = (ApplicationConfig)context.getAttribute(APPLICATION_KEY);
        }
        return (DataSource)context.getAttribute(key + appConfig.getPrefix());
    }

    protected Locale getLocale(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute(LOCALE_KEY);
        if (locale == null) {
            locale = defaultLocale;
        }
        return locale;
    }

    protected MessageResources getResources() {
        return (MessageResources)this.servlet.getServletContext().getAttribute(MESSAGES_KEY);
    }

    protected MessageResources getResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute(MESSAGES_KEY);
    }

    protected MessageResources getResources(HttpServletRequest request, String key) {
        ServletContext context = this.getServlet().getServletContext();
        ApplicationConfig appConfig = (ApplicationConfig)request.getAttribute(APPLICATION_KEY);
        if (appConfig == null) {
            appConfig = (ApplicationConfig)context.getAttribute(APPLICATION_KEY);
        }
        return (MessageResources)context.getAttribute(key + appConfig.getPrefix());
    }

    protected boolean isCancelled(HttpServletRequest request) {
        return request.getParameter("org.apache.struts.taglib.html.CANCEL") != null || request.getParameter("org.apache.struts.taglib.html.CANCEL.x") != null;
    }

    protected boolean isTokenValid(HttpServletRequest request) {
        return this.isTokenValid(request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTokenValid(HttpServletRequest request, boolean reset) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            String token;
            String saved;
            block8: {
                block7: {
                    saved = (String)session.getAttribute(TRANSACTION_TOKEN_KEY);
                    if (saved != null) break block7;
                    boolean bl = false;
                    return bl;
                }
                if (reset) {
                    session.removeAttribute(TRANSACTION_TOKEN_KEY);
                }
                if ((token = request.getParameter("org.apache.struts.taglib.html.TOKEN")) != null) break block8;
                boolean bl = false;
                return bl;
            }
            boolean bl = saved.equals(token);
            return bl;
        }
    }

    protected void resetToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute(TRANSACTION_TOKEN_KEY);
    }

    protected void saveErrors(HttpServletRequest request, ActionErrors errors) {
        if (errors == null || errors.empty()) {
            request.removeAttribute(ERROR_KEY);
            return;
        }
        request.setAttribute(ERROR_KEY, (Object)errors);
    }

    protected void saveMessages(HttpServletRequest request, ActionMessages messages) {
        if (messages == null || messages.empty()) {
            request.removeAttribute(MESSAGE_KEY);
            return;
        }
        request.setAttribute(MESSAGE_KEY, (Object)messages);
    }

    protected void saveToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String token = this.generateToken(request);
        if (token != null) {
            session.setAttribute(TRANSACTION_TOKEN_KEY, (Object)token);
        }
    }

    protected void setLocale(HttpServletRequest request, Locale locale) {
        HttpSession session = request.getSession();
        if (locale == null) {
            locale = defaultLocale;
        }
        session.setAttribute(LOCALE_KEY, (Object)locale);
    }

    protected String toHex(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        String s = null;
        int i = 0;
        while (i < buffer.length) {
            s = Integer.toHexString(buffer[i] & 0xFF);
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    static {
        ACTION_SERVLET_KEY = ACTION_SERVLET_KEY;
        APPLICATION_KEY = APPLICATION_KEY;
        DATA_SOURCE_KEY = DATA_SOURCE_KEY;
        ERROR_KEY = ERROR_KEY;
        EXCEPTION_KEY = EXCEPTION_KEY;
        FORM_BEANS_KEY = FORM_BEANS_KEY;
        FORWARDS_KEY = FORWARDS_KEY;
        LOCALE_KEY = LOCALE_KEY;
        MAPPING_KEY = MAPPING_KEY;
        MAPPINGS_KEY = MAPPINGS_KEY;
        MESSAGE_KEY = MESSAGE_KEY;
        MESSAGES_KEY = MESSAGES_KEY;
        MULTIPART_KEY = MULTIPART_KEY;
        PLUG_INS_KEY = PLUG_INS_KEY;
        REQUEST_PROCESSOR_KEY = REQUEST_PROCESSOR_KEY;
        SERVLET_KEY = SERVLET_KEY;
        TRANSACTION_TOKEN_KEY = TRANSACTION_TOKEN_KEY;
        defaultLocale = Locale.getDefault();
    }
}

