/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbcext.ClientConnectionSapDB;
import com.sap.dbtech.jdbcext.ConnectionListenerBag;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import javax.sql.PooledConnection;

public class PooledConnectionSapDB
extends ConnectionListenerBag
implements PooledConnection {
    Connection physicalConnection;
    WeakReference lastClientConnection;

    PooledConnectionSapDB(Connection connection) {
        this.physicalConnection = connection;
        this.lastClientConnection = null;
    }

    private void sendErrorEvent(SQLException sQLException) {
        super.sendErrorEvent(this, sQLException);
    }

    private void sendCloseEvent() {
        super.sendCloseEvent(this);
    }

    private PooledConnectionSapDB self() {
        return this;
    }

    public synchronized Connection getConnection() throws SQLException {
        PooledClientConnectionSapDB pooledClientConnectionSapDB;
        Object var1_1 = null;
        if (this.lastClientConnection != null) {
            Object t = this.lastClientConnection.get();
            var1_1 = t;
            if (t != null) {
                pooledClientConnectionSapDB = var1_1;
                ConnectionSapDB connectionSapDB = null;
                try {
                    connectionSapDB = (ConnectionSapDB)this.physicalConnection;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (connectionSapDB != null) {
                    Iterator iterator = connectionSapDB.getOpenStatements().getall();
                    while (iterator.hasNext()) {
                        Statement statement = (Statement)iterator.next();
                        statement.close();
                    }
                    connectionSapDB.reinitialize();
                }
                pooledClientConnectionSapDB.rollback();
                pooledClientConnectionSapDB.closed = true;
            }
        }
        pooledClientConnectionSapDB = new PooledClientConnectionSapDB();
        this.lastClientConnection = new WeakReference<PooledClientConnectionSapDB>(pooledClientConnectionSapDB);
        return pooledClientConnectionSapDB;
    }

    public synchronized void close() throws SQLException {
        this.physicalConnection.close();
    }

    private class PooledClientConnectionSapDB
    extends ClientConnectionSapDB {
        boolean closed = false;

        private PooledClientConnectionSapDB() {
        }

        public Connection getPhysicalConnection() {
            return PooledConnectionSapDB.this.physicalConnection;
        }

        public void exceptionOccurred(SQLException sQLException) {
            PooledConnectionSapDB.this.sendErrorEvent(sQLException);
        }

        private ConnectionSapDB getSapDBConnection(Connection connection) {
            ConnectionSapDB connectionSapDB = null;
            try {
                connectionSapDB = (ConnectionSapDB)PooledConnectionSapDB.this.physicalConnection;
                return connectionSapDB;
            }
            catch (ClassCastException classCastException) {
                try {
                    com.sap.dbtech.jdbc.trace.Connection connection2 = (com.sap.dbtech.jdbc.trace.Connection)PooledConnectionSapDB.this.physicalConnection;
                    connectionSapDB = (ConnectionSapDB)connection2.getInner();
                    return connectionSapDB;
                }
                catch (ClassCastException classCastException2) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            PooledConnectionSapDB pooledConnectionSapDB = PooledConnectionSapDB.this.self();
            synchronized (pooledConnectionSapDB) {
                ConnectionSapDB connectionSapDB = this.getSapDBConnection(PooledConnectionSapDB.this.physicalConnection);
                if (connectionSapDB != null) {
                    Iterator iterator = connectionSapDB.getOpenStatements().getall();
                    while (iterator.hasNext()) {
                        Statement statement = (Statement)iterator.next();
                        statement.close();
                    }
                    connectionSapDB.reinitialize();
                }
                if (!this.getAutoCommit()) {
                    this.rollback();
                }
                this.closed = true;
                PooledConnectionSapDB.this.sendCloseEvent();
            }
        }

        public boolean isClosed() throws SQLException {
            if (this.closed) {
                return true;
            }
            return super.isClosed();
        }

        public void finalize() {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

