/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.xml;

import cirrus.hibernate.Databinder;
import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.persister.ClassPersister;
import cirrus.hibernate.proxy.HibernateProxy;
import cirrus.hibernate.proxy.HibernateProxyHelper;
import cirrus.hibernate.proxy.LazyInitializer;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.BagType;
import cirrus.hibernate.type.ListType;
import cirrus.hibernate.type.MapType;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.SetType;
import cirrus.hibernate.type.Type;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;

public class XMLDatabinder
implements Databinder {
    private SessionFactoryImplementor factory;
    private List objects = new ArrayList();
    private Set associatedObjects;
    private Set processedObjects;
    private Transformer transform;
    private boolean initializeLazy = false;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$xml$XMLDatabinder == null ? (class$cirrus$hibernate$xml$XMLDatabinder = XMLDatabinder.class$("cirrus.hibernate.xml.XMLDatabinder")) : class$cirrus$hibernate$xml$XMLDatabinder));
    static /* synthetic */ Class class$cirrus$hibernate$xml$XMLDatabinder;

    public XMLDatabinder(SessionFactoryImplementor factory, Transformer transform) {
        this.factory = factory;
        this.transform = transform;
    }

    private ClassPersister getPersister(Class clazz) throws MappingException {
        return this.factory.getPersister(clazz);
    }

    public void setInitializeLazy(boolean initializeLazy) {
        this.initializeLazy = initializeLazy;
    }

    private Document toJDOMDocument() throws HibernateException {
        this.associatedObjects = new HashSet();
        this.processedObjects = new HashSet();
        Element root = new Element("hibernate-generic");
        root.setAttribute("datetime", Hibernate.TIMESTAMP.toXML(new Date(), this.factory));
        Document doc = new Document(root);
        Iterator iter = null;
        while (true) {
            iter = this.objects.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                Element objectElem = new Element("object");
                root.addContent(objectElem);
                object = this.maybeInitializeIfProxy(object, objectElem);
                if (object == null) continue;
                String className = object.getClass().getName();
                objectElem.setAttribute("class", StringHelper.unqualify(className));
                objectElem.setAttribute("package", StringHelper.qualifier(className));
                ClassPersister persister = this.getPersister(object.getClass());
                if (persister.hasIdentifierProperty()) {
                    Type idType = persister.getIdentifierType();
                    String idValue = idType.toXML(persister.getIdentifier(object), this.factory);
                    Element idElem = new Element("uid");
                    idElem.setAttribute("name", persister.getIdentifierPropertyName());
                    idElem.setAttribute("type", idType.getName());
                    idElem.addContent(idValue);
                    objectElem.addContent(idElem);
                }
                Type[] types = persister.getPropertyTypes();
                Object[] values = persister.getPropertyValues(object);
                String[] names = persister.getPropertyNames();
                int i = 0;
                while (i < types.length) {
                    objectElem.addContent(this.renderProperty(names[i], types[i], values[i], "component", "property", "collection", true));
                    ++i;
                }
            }
            if (this.associatedObjects.size() == 0) break;
            this.processedObjects.addAll(this.objects);
            this.objects = new ArrayList(this.associatedObjects);
            this.associatedObjects = new HashSet();
        }
        return doc;
    }

    private Object maybeInitializeIfProxy(Object object, Element element) throws HibernateException {
        if (!(object instanceof HibernateProxy)) {
            return object;
        }
        LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
        if (li.isUninitialized() && !this.initializeLazy) {
            element.setAttribute("proxy", "uninitialized");
            element.setAttribute("uid", li.getIdentifier().toString());
            return null;
        }
        if (li.isUninitialized()) {
            element.setAttribute("proxy", "now-initialized");
        } else {
            element.setAttribute("proxy", "initialized");
        }
        try {
            return li.getImplementation();
        }
        catch (SQLException sqle) {
            throw new HibernateException("SQL Exception initializing proxy", sqle);
        }
    }

    public String toGenericXML() throws HibernateException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setNewlines(true);
        outputter.setIndent(true);
        return outputter.outputString(this.toJDOMDocument());
    }

    private Element renderProperty(String name, Type type, Object value, String componentName, String propertyName, String collectionName, boolean doType) throws HibernateException {
        if (type.isComponentType()) {
            AbstractComponentType componenttype = (AbstractComponentType)type;
            Element componentElem = new Element(componentName);
            if (name != null) {
                componentElem.setAttribute("name", name);
            }
            if (doType) {
                componentElem.setAttribute("class", type.getName());
            }
            if (value != null) {
                String[] properties = componenttype.getPropertyNames();
                Object[] subvalues = componenttype.getPropertyValues(value);
                Type[] subtypes = componenttype.getSubtypes();
                int j = 0;
                while (j < properties.length) {
                    componentElem.addContent(this.renderProperty(properties[j], subtypes[j], subvalues[j], "component", "property", "collection", true));
                    ++j;
                }
            }
            return componentElem;
        }
        if (type.isPersistentCollectionType()) {
            PersistentCollectionType collectiontype = (PersistentCollectionType)type;
            String role = collectiontype.getRole();
            CollectionPersister persister = this.factory.getCollectionPersister(role);
            Element collectionElem = new Element(collectionName);
            if (name != null) {
                collectionElem.setAttribute("name", name);
            }
            if (persister.isArray()) {
                collectionElem.setName("array");
            } else if (doType) {
                collectionElem.setAttribute("class", type.getName());
            }
            Type elemType = persister.getElementType();
            collectionElem.setAttribute("element-type", elemType.getName());
            if (persister.isToplevel()) {
                collectionElem.setAttribute("role", StringHelper.unqualify(role, "/"));
            }
            if (value != null) {
                if (persister.isArray()) {
                    collectionElem.setAttribute("index-type", "integer");
                    int length = Array.getLength(value);
                    int i = 0;
                    while (i < length) {
                        Element elemElement = this.renderProperty(null, elemType, Array.get(value, i), "composite-element", "element", "subcollection", false);
                        elemElement.setAttribute("index", Integer.toString(i));
                        collectionElem.addContent(elemElement);
                        ++i;
                    }
                } else {
                    PersistentCollection persistentCollection = (PersistentCollection)value;
                    if (persister.isLazy() && !this.initializeLazy && !persistentCollection.wasInitialized()) {
                        collectionElem.setAttribute("lazy", "uninitialized");
                    } else {
                        if (persistentCollection.wasInitialized()) {
                            collectionElem.setAttribute("lazy", "initialized");
                        } else {
                            collectionElem.setAttribute("lazy", "now-initialized");
                        }
                        if (type instanceof ListType) {
                            collectionElem.setAttribute("index-type", "integer");
                            Iterator iter = ((List)value).iterator();
                            int i = 0;
                            while (iter.hasNext()) {
                                Element elemElement = this.renderProperty(null, elemType, iter.next(), "composite-element", "element", "subcollection", false);
                                elemElement.setAttribute("index", Integer.toString(i++));
                                collectionElem.addContent(elemElement);
                            }
                        } else if (type instanceof SetType || type instanceof BagType) {
                            Iterator iter = ((Collection)value).iterator();
                            while (iter.hasNext()) {
                                Element elemElement = this.renderProperty(null, elemType, iter.next(), "composite-element", "element", "subcollection", false);
                                collectionElem.addContent(elemElement);
                            }
                        } else if (type instanceof MapType) {
                            Type indexType = persister.getIndexType();
                            collectionElem.setAttribute("index-type", indexType.getName());
                            Iterator iter = ((Map)value).entrySet().iterator();
                            while (iter.hasNext()) {
                                Map.Entry e = iter.next();
                                Object idx = e.getKey();
                                Element elemElement = this.renderProperty(null, elemType, e.getValue(), "composite-element", "element", "subcollection", false);
                                elemElement.setAttribute("index", indexType.toXML(idx, this.factory));
                                collectionElem.addContent(elemElement);
                            }
                        }
                    }
                }
            }
            return collectionElem;
        }
        if (type.isEntityType()) {
            Element referenceElem = new Element(propertyName);
            if (name != null) {
                referenceElem.setAttribute("name", name);
            }
            if ((value = this.maybeInitializeIfProxy(value, referenceElem)) != null) {
                if (this.getPersister(value.getClass()).hasIdentifierProperty()) {
                    referenceElem.setAttribute("uid", type.toXML(value, this.factory));
                }
                String className = value.getClass().getName();
                referenceElem.setAttribute("class", StringHelper.unqualify(className));
                referenceElem.setAttribute("package", StringHelper.qualifier(className));
                if (!this.processedObjects.contains(value) && !this.objects.contains(value)) {
                    this.associatedObjects.add(value);
                }
            }
            if (doType) {
                referenceElem.setAttribute("type", type.getName());
            }
            return referenceElem;
        }
        Element propertyElem = new Element(propertyName);
        if (name != null) {
            propertyElem.setAttribute("name", name);
        }
        if (value != null) {
            propertyElem.addContent(type.toXML(value, this.factory));
        }
        if (doType) {
            propertyElem.setAttribute("type", type.getName());
        }
        return propertyElem;
    }

    public String toXML() throws HibernateException, TransformerException {
        StreamSource source = new StreamSource(new StringReader(this.toGenericXML()));
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        this.transform.setErrorListener(new ErrorListener(){

            public void warning(TransformerException te) throws TransformerException {
                log.warn((Object)("problem transforming to Custom XML: " + te.getMessageAndLocation()), (Throwable)te);
            }

            public void error(TransformerException te) throws TransformerException {
                log.error((Object)("problem transforming to Custom XML: " + te.getMessageAndLocation()), (Throwable)te);
            }

            public void fatalError(TransformerException te) throws TransformerException {
                this.error(te);
            }
        });
        this.transform.transform(source, result);
        return writer.toString();
    }

    public org.w3c.dom.Document toDOM() throws HibernateException, TransformerException {
        StreamSource source = new StreamSource(new StringReader(this.toGenericXML()));
        DOMResult result = new DOMResult();
        this.transform.transform(source, result);
        return (org.w3c.dom.Document)result.getNode();
    }

    public Databinder bind(Object object) {
        this.objects.add(object);
        return this;
    }

    public Databinder bindAll(Collection objects) {
        objects.addAll(objects);
        return this;
    }

    public org.w3c.dom.Document toGenericDOM() throws HibernateException {
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(this.toJDOMDocument());
        }
        catch (JDOMException jde) {
            throw new HibernateException("JDOM Exception", jde);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

