/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.type;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.ArrayHolder;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.type.PersistentCollectionType;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;

public class ArrayType
extends PersistentCollectionType {
    private final Class elementClass;
    private final Class arrayClass;

    public ArrayType(String role, boolean nested, Class elementClass) {
        super(role, nested);
        this.elementClass = elementClass;
        this.arrayClass = Array.newInstance(elementClass, 0).getClass();
    }

    public Class returnedClass() {
        return this.arrayClass;
    }

    protected PersistentCollection instantiate(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        return new ArrayHolder(session, persister);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        super.nullSafeSet(st, session.getArrayHolder(value), index, session);
    }

    public Iterator getElementsIterator(Object collection) {
        return Arrays.asList((Object[])collection).iterator();
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        return session.getLoadedID(session.getArrayHolder(value));
    }

    public PersistentCollection wrap(SessionImplementor session, Object array) {
        return new ArrayHolder(session, array);
    }

    public boolean isArrayType() {
        return true;
    }
}

