/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.query;

import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.ScrollableResults;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.ArrayHelper;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.impl.IteratorImpl;
import cirrus.hibernate.impl.QueryImpl;
import cirrus.hibernate.impl.ScrollableResultsImpl;
import cirrus.hibernate.loader.Loader;
import cirrus.hibernate.persister.Loadable;
import cirrus.hibernate.persister.Queryable;
import cirrus.hibernate.query.ParserHelper;
import cirrus.hibernate.query.PreprocessingParser;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTranslator
extends Loader {
    private static final HashSet dontSpace = new HashSet();
    private final HashMap typeMap = new HashMap();
    private final HashMap collections = new HashMap();
    private final HashMap names = new HashMap();
    private ArrayList returnTypes = new ArrayList();
    private final ArrayList fromTypes = new ArrayList();
    private final ArrayList scalarTypes = new ArrayList();
    private final HashMap namedParameters = new HashMap();
    private final List scalarSelectTokens = new ArrayList();
    private final List whereTokens = new ArrayList();
    private final List havingTokens = new ArrayList();
    private final StringBuffer joins = new StringBuffer(40);
    private final List orderByTokens = new ArrayList();
    private final List groupByTokens = new ArrayList();
    private final Set identifierSpaces = new HashSet();
    private Queryable[] persisters;
    private Type[] types;
    private String[][] scalarColumnNames;
    protected SessionFactoryImplementor factory;
    private Map replacements;
    private int count = 0;
    private int parameterCount = 0;
    private String queryString;
    private boolean distinct = false;
    private String fromWhereString;
    private String selectPropertiesString;
    private String selectIDString;
    private String scalarSelectString;
    protected boolean compiled;
    private boolean hasScalars;
    private QueryTranslator superQuery;
    private String[] suffixes;
    private static final Log log;
    private static final int[] NO_INTS;
    private final Map pathAliases = new HashMap();
    private final Map pathJoins = new HashMap();
    static /* synthetic */ Class class$cirrus$hibernate$query$QueryTranslator;

    void compile(QueryTranslator superquery, String queryString) throws QueryException, MappingException {
        this.factory = superquery.factory;
        this.replacements = superquery.replacements;
        this.superQuery = superquery;
        this.hasScalars = true;
        this.compile(queryString);
    }

    public synchronized void compile(SessionFactoryImplementor factory, String queryString, Map replacements, boolean scalar) throws QueryException, MappingException {
        if (!this.compiled) {
            this.factory = factory;
            this.replacements = replacements;
            this.hasScalars = scalar;
            this.compile(queryString);
        }
    }

    protected void compile(String queryString) throws QueryException, MappingException {
        this.queryString = queryString;
        log.trace((Object)"compiling query");
        try {
            ParserHelper.parse(new PreprocessingParser(this.replacements), queryString, " \n\r\f\t,()=<>&|+-=/*'^![]#~", this);
            this.renderSQL();
        }
        catch (QueryException qe) {
            qe.setQueryString(queryString);
            throw qe;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.debug((Object)"unexpected query compilation problem", (Throwable)e);
            QueryException qe = new QueryException("Incorrect query syntax", e);
            qe.setQueryString(queryString);
            throw qe;
        }
        this.compiled = true;
    }

    public Loadable[] getPersisters() {
        return this.persisters;
    }

    public Type[] getReturnTypes() {
        return this.types;
    }

    protected boolean hasScalarValues() {
        return this.types.length != this.persisters.length;
    }

    public String[][] getScalarColumnNames() {
        return this.scalarColumnNames;
    }

    private void logQuery(String hql, String sql) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HQL: " + hql));
            log.debug((Object)("SQL: " + sql));
        }
    }

    protected String getSQLString() {
        String result = new StringBuffer(50).append(this.selectPropertiesString).append(this.fromWhereString).toString();
        this.logQuery(this.queryString, result);
        return result;
    }

    protected String getSelectIdentifiersSQL() {
        String result = new StringBuffer(50).append(this.selectIDString).append(this.fromWhereString).toString();
        this.logQuery(this.queryString, result);
        return result;
    }

    protected String getScalarSelectSQL() {
        String result = new StringBuffer(50).append(this.scalarSelectString).append(this.fromWhereString).toString();
        this.logQuery(this.queryString, result);
        return result;
    }

    private String prefix(String s) {
        if (s.length() > 3) {
            return s.substring(0, 3).toLowerCase();
        }
        return s.toLowerCase();
    }

    private int nextCount() {
        int n;
        if (this.superQuery == null) {
            int n2 = this.count;
            n = n2;
            this.count = n2 + 1;
        } else {
            int n3 = this.superQuery.count;
            n = n3;
            this.superQuery.count = n3 + 1;
        }
        return n;
    }

    String createNameFor(Class type) {
        String typeName = type.getName();
        return this.prefix(StringHelper.unqualify(typeName)) + this.nextCount() + '_';
    }

    String createNameForCollection(String role) {
        return this.prefix(StringHelper.unqualify(role, "/")) + this.nextCount() + '_';
    }

    String getType(String name) {
        String type = (String)this.typeMap.get(name);
        if (type == null && this.superQuery != null) {
            type = this.superQuery.getType(name);
        }
        return type;
    }

    String getRole(String name) {
        String role = (String)this.collections.get(name);
        if (role == null && this.superQuery != null) {
            role = this.superQuery.getRole(name);
        }
        return role;
    }

    boolean isName(String name) {
        return this.typeMap.containsKey(name) || this.collections.containsKey(name) || this.superQuery != null && this.superQuery.isName(name);
    }

    Queryable getPersisterForName(String name) throws QueryException {
        String typeName = this.getType(name);
        if (typeName == null) {
            return this.getPersister(((EntityType)this.getCollectionPersister(this.getRole(name)).getElementType()).getPersistentClass());
        }
        Queryable persister = this.getPersister(typeName);
        if (persister == null) {
            throw new QueryException("persistent class not found: " + typeName);
        }
        return persister;
    }

    /*
     * Unable to fully structure code
     */
    Queryable getPersister(String className) {
        imports = this.factory.getImports();
        try {
            return (Queryable)this.factory.getPersister(className);
        }
        catch (Exception e) {
            i = 0;
            ** while (i < imports.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return (Queryable)this.factory.getPersister(imports[i] + '.' + className);
            }
            catch (Exception ex) {
                ++i;
            }
            continue;
        }
lbl12:
        // 1 sources

        return null;
    }

    Queryable getPersister(Class clazz) throws QueryException {
        try {
            return (Queryable)this.factory.getPersister(clazz);
        }
        catch (Exception e) {
            throw new QueryException("persistent class not found: " + clazz.getName());
        }
    }

    CollectionPersister getCollectionPersister(String role) throws QueryException {
        try {
            return this.factory.getCollectionPersister(role);
        }
        catch (Exception e) {
            throw new QueryException("collection role not found: " + role);
        }
    }

    void addType(String name, String type) {
        this.typeMap.put(name, type);
        this.names.put(type, name);
    }

    void addCollection(String name, String role) {
        this.collections.put(name, role);
    }

    void addFromType(String name, String type) {
        this.addType(name, type);
        this.fromTypes.add(name);
    }

    void addReturnType(String name) {
        this.returnTypes.add(name);
    }

    void addScalarType(Type type) {
        this.scalarTypes.add(type);
    }

    void appendWhereToken(String token) {
        this.whereTokens.add(token);
    }

    void appendHavingToken(String token) {
        this.havingTokens.add(token);
    }

    void appendOrderByToken(String token) {
        this.orderByTokens.add(token);
    }

    void appendGroupByToken(String token) {
        this.groupByTokens.add(token);
    }

    void appendScalarSelectToken(String token) throws QueryException {
        this.scalarSelectTokens.add(token);
    }

    void appendScalarSelectTokens(String[] tokens) throws QueryException {
        this.scalarSelectTokens.add(tokens);
    }

    void addJoin(String token) {
        if (this.joins.length() == 0 && token.length() != 0) {
            this.joins.append(token.substring(5));
        } else {
            this.joins.append(token);
        }
    }

    void addNamedParameter(String name) {
        if (this.superQuery != null) {
            this.superQuery.addNamedParameter(name);
        }
        Integer loc = new Integer(++this.parameterCount);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((ArrayList)o).add(loc);
        }
    }

    protected int[] getNamedParameterLocs(String name) throws QueryException {
        Object o = this.namedParameters.get(name);
        if (o == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name);
            qe.setQueryString(this.queryString);
            throw qe;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return ArrayHelper.toIntArray((ArrayList)o);
    }

    public Collection getNamedParameters() {
        return this.namedParameters.keySet();
    }

    public static String scalarName(int x, int y) {
        return "" + 'x' + x + '_' + y + '_';
    }

    private void renderSQL() throws QueryException, MappingException {
        Serializable p;
        if (this.returnTypes.size() == 0 && this.scalarTypes.size() == 0) {
            this.returnTypes = this.fromTypes;
        }
        int size = this.returnTypes.size();
        this.persisters = new Queryable[size];
        this.suffixes = new String[size];
        int i = 0;
        while (i < size) {
            String name = (String)this.returnTypes.get(i);
            if (!this.isName(name)) {
                throw new QueryException("unknown type: " + name);
            }
            this.persisters[i] = this.getPersisterForName(name);
            this.suffixes[i] = size == 1 ? "" : Integer.toString(i);
            ++i;
        }
        String selectPerhapsDistinct = "SELECT ";
        if (this.distinct) {
            selectPerhapsDistinct = selectPerhapsDistinct + "DISTINCT ";
        }
        String selectScalars = this.renderScalarSelect();
        this.scalarSelectString = selectPerhapsDistinct + selectScalars;
        String selectIdentifiers = this.renderIdentifierSelect();
        this.selectIDString = selectPerhapsDistinct + selectIdentifiers + this.renderOrderByPropertiesSelect();
        this.selectPropertiesString = selectPerhapsDistinct + selectIdentifiers + this.renderPropertiesSelect();
        this.fromWhereString = this.renderFromClause() + this.renderWhereClause();
        if (this.scalarTypes.size() != size) {
            if (size != 0) {
                this.selectPropertiesString = this.selectPropertiesString + ", ";
            }
            this.selectPropertiesString = this.selectPropertiesString + selectScalars;
        }
        int scalarSize = this.scalarTypes.size();
        this.types = new Type[scalarSize];
        int i2 = 0;
        while (i2 < scalarSize) {
            this.types[i2] = (Type)this.scalarTypes.get(i2);
            ++i2;
        }
        this.scalarColumnNames = QueryTranslator.generateColumnNames(this.types, this.factory);
        Iterator<Object> iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            p = this.getCollectionPersister((String)iter.next());
            this.addIdentifierSpace((Serializable)((Object)((CollectionPersister)p).getQualifiedTableName()));
        }
        iter = this.typeMap.keySet().iterator();
        while (iter.hasNext()) {
            p = this.getPersisterForName((String)iter.next());
            this.addIdentifierSpace(p.getIdentifierSpace());
        }
    }

    private String renderIdentifierSelect() {
        StringBuffer buf = new StringBuffer(40);
        int size = this.returnTypes.size();
        int k = 0;
        while (k < size) {
            String name = (String)this.returnTypes.get(k);
            String suffix = size == 1 ? "" : Integer.toString(k);
            buf.append(this.persisters[k].selectIdentifierString(name, suffix));
            if (k != size - 1) {
                buf.append(", ");
            }
            ++k;
        }
        return buf.toString();
    }

    private String renderOrderByPropertiesSelect() {
        StringBuffer buf = new StringBuffer(10);
        Iterator iter = this.orderByTokens.iterator();
        while (iter.hasNext()) {
            String token = (String)iter.next();
            if (token.lastIndexOf(".") <= 0) continue;
            buf.append(", ").append(token);
        }
        return buf.toString();
    }

    private String renderPropertiesSelect() {
        StringBuffer buf = new StringBuffer(40);
        int size = this.returnTypes.size();
        int k = 0;
        while (k < size) {
            String suffix = size == 1 ? "" : Integer.toString(k);
            String name = (String)this.returnTypes.get(k);
            buf.append(this.persisters[k].propertySelectClauseFragment(name, suffix));
            ++k;
        }
        return buf.toString();
    }

    private String renderScalarSelect() {
        boolean isSubselect = this.superQuery != null;
        StringBuffer buf = new StringBuffer(20);
        if (this.scalarTypes.size() == 0) {
            int size = this.returnTypes.size();
            int k = 0;
            while (k < size) {
                this.scalarTypes.add(Hibernate.association(this.persisters[k].getMappedClass()));
                String[] names = this.persisters[k].getIdentifierColumnNames();
                int i = 0;
                while (i < names.length) {
                    buf.append(this.returnTypes.get(k)).append('.').append(names[i]);
                    if (!isSubselect) {
                        buf.append(" as ").append(QueryTranslator.scalarName(k, i));
                    }
                    if (i != names.length - 1 || k != size - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                ++k;
            }
        } else {
            Iterator iter = this.scalarSelectTokens.iterator();
            int c = 0;
            boolean nolast = false;
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next instanceof String) {
                    String token = (String)next;
                    String lc = token.toLowerCase();
                    if (lc.equals(", ")) {
                        if (nolast) {
                            nolast = false;
                        } else if (!isSubselect) {
                            buf.append(" as ").append(QueryTranslator.scalarName(c++, 0));
                        }
                    }
                    buf.append(token);
                    if (!lc.equals("distinct") && !lc.equals("all")) continue;
                    buf.append(' ');
                    continue;
                }
                nolast = true;
                String[] tokens = (String[])next;
                int i = 0;
                while (i < tokens.length) {
                    buf.append(tokens[i]);
                    if (!isSubselect) {
                        buf.append(" as ").append(QueryTranslator.scalarName(c, i));
                    }
                    if (i != tokens.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                ++c;
            }
            if (!isSubselect && !nolast) {
                buf.append(" as ").append(QueryTranslator.scalarName(c++, 0));
            }
        }
        return buf.toString();
    }

    private String renderFromClause() throws QueryException, MappingException {
        StringBuffer buf = new StringBuffer(120).append(" FROM");
        Iterator<Object> iter = this.typeMap.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Queryable p = this.getPersisterForName(name);
            buf.append(' ').append(p.fromClauseFragment(name, true));
            if (!iter.hasNext() && this.collections.size() == 0) continue;
            buf.append(',');
        }
        iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            buf.append(' ');
            Map.Entry entry = (Map.Entry)iter.next();
            String name = (String)entry.getKey();
            String role = (String)entry.getValue();
            CollectionPersister p = this.getCollectionPersister(role);
            buf.append(p.getQualifiedTableName()).append(' ').append(name);
            if (!iter.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private String renderWhereClause() throws QueryException, MappingException {
        boolean hasPart3;
        Iterator iter = this.typeMap.keySet().iterator();
        StringBuffer inClassWheres = new StringBuffer(50);
        boolean first = true;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Queryable p = this.getPersisterForName(name);
            this.addIdentifierSpace(p.getIdentifierSpace());
            String where = p.getQueryWhereClause(name);
            if (where == null) continue;
            if (!first) {
                inClassWheres.append(" AND ");
            }
            first = false;
            inClassWheres.append(where);
        }
        StringBuffer buf = new StringBuffer(120);
        StringBuffer whereTokenBuf = new StringBuffer(40);
        this.appendTokens(whereTokenBuf, this.whereTokens.iterator());
        String part1 = inClassWheres.toString().trim();
        String part2 = this.joins.toString().trim();
        String part3 = whereTokenBuf.toString().trim();
        boolean hasPart1 = part1.length() != 0;
        boolean hasPart2 = part2.length() != 0;
        boolean bl = hasPart3 = part3.length() != 0;
        if (hasPart1 || hasPart2 || hasPart3) {
            buf.append(" WHERE ");
        }
        if (hasPart1) {
            buf.append(part1);
        }
        if (hasPart1 && hasPart2) {
            buf.append(" AND ");
        }
        if (hasPart2) {
            buf.append(part2);
        }
        if (hasPart3) {
            if (hasPart1 || hasPart2) {
                buf.append(" AND (");
            }
            buf.append(part3);
            if (hasPart1 || hasPart2) {
                buf.append(')');
            }
        }
        if (this.groupByTokens.size() != 0) {
            buf.append(" GROUP BY ");
            this.appendTokens(buf, this.groupByTokens.iterator());
        }
        if (this.havingTokens.size() != 0) {
            buf.append(" HAVING ");
            this.appendTokens(buf, this.havingTokens.iterator());
        }
        if (this.orderByTokens.size() != 0) {
            buf.append(" ORDER BY ");
            this.appendTokens(buf, this.orderByTokens.iterator());
        }
        return buf.toString();
    }

    private void appendTokens(StringBuffer buf, Iterator iter) {
        boolean lastSpaceable = true;
        while (iter.hasNext()) {
            boolean spaceable;
            String token = (String)iter.next();
            boolean bl = spaceable = !dontSpace.contains(token);
            if (spaceable && lastSpaceable) {
                buf.append(' ');
            }
            lastSpaceable = spaceable;
            buf.append(token);
        }
    }

    public Set getQuerySpaces() {
        return this.identifierSpaces;
    }

    public boolean supportsScalars() {
        return this.hasScalars;
    }

    void addIdentifierSpace(Serializable table) {
        this.identifierSpaces.add(table);
        if (this.superQuery != null) {
            this.superQuery.addIdentifierSpace(table);
        }
    }

    void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    protected CollectionPersister getCollectionPersister() {
        return null;
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    protected void addFromCollection(String elementName, String collectionRole) throws QueryException {
        Type collectionElementType = this.getCollectionPersister(collectionRole).getElementType();
        if (!collectionElementType.isEntityType()) {
            throw new QueryException("collection of values in filter: " + elementName);
        }
        EntityType elemType = (EntityType)collectionElementType;
        this.addFromType(elementName, elemType.getPersistentClass().getName());
        CollectionPersister persister = this.getCollectionPersister(collectionRole);
        String[] keyColumnNames = persister.getKeyColumnNames();
        if (keyColumnNames.length != 1) {
            throw new QueryException("composite-key collection in filter: " + collectionRole);
        }
        StringBuffer join = new StringBuffer(25);
        join.append(" and ");
        if (persister.isOneToMany()) {
            join.append(elementName).append('.').append(keyColumnNames[0]).append(" = ?");
        } else {
            String collectionName = this.createNameForCollection(collectionRole);
            this.addCollection(collectionName, collectionRole);
            join.append(collectionName).append('.').append(keyColumnNames[0]).append(" = ?");
            String[] idColumnNames = this.getPersisterForName(elementName).getIdentifierColumnNames();
            String[] eltColumnNames = persister.getElementColumnNames();
            int i = 0;
            while (i < idColumnNames.length) {
                join.append(" and ").append(collectionName).append('.').append(eltColumnNames[i]).append('=').append(elementName).append('.').append(idColumnNames[i]);
                ++i;
            }
        }
        this.addJoin(join.toString());
    }

    String getPathAlias(String path) {
        return (String)this.pathAliases.get(path);
    }

    String getPathJoin(String path) {
        return (String)this.pathJoins.get(path);
    }

    void addPathAliasAndJoin(String path, String alias, String join) {
        this.pathAliases.put(path, alias);
        this.pathJoins.put(path, join);
    }

    protected void bindNamedParameters(PreparedStatement ps, Map namedParams, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                QueryImpl.TypedValue typedval = (QueryImpl.TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                int i = 0;
                while (i < locs.length) {
                    typedval.type.nullSafeSet(ps, typedval.value, locs[i], session);
                    ++i;
                }
            }
        }
    }

    public Iterator iterate(Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams, SessionImplementor session) throws HibernateException, SQLException {
        PreparedStatement st = this.prepareQueryStatement(this.getScalarSelectSQL(), values, types, selection, false, session);
        try {
            this.bindNamedParameters(st, namedParams, session);
            this.setMaxRows(st, selection);
            ResultSet rs = st.executeQuery();
            this.advance(rs, selection, session);
            return new IteratorImpl(rs, session, this.getReturnTypes(), this.getScalarColumnNames());
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            session.getBatcher().closeQueryStatement(st);
            throw sqle;
        }
    }

    public ScrollableResults scroll(Object[] values, Type[] types, QueryImpl.RowSelection selection, Map namedParams, SessionImplementor session) throws HibernateException, SQLException {
        PreparedStatement st = this.prepareQueryStatement(this.getScalarSelectSQL(), values, types, selection, true, session);
        try {
            this.bindNamedParameters(st, namedParams, session);
            this.setMaxRows(st, selection);
            ResultSet rs = st.executeQuery();
            this.advance(rs, selection, session);
            return new ScrollableResultsImpl(rs, session, this.getReturnTypes());
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            session.getBatcher().closeQueryStatement(st);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findIdentifiers(Object[] values, Type[] types, SessionImplementor session) throws SQLException, HibernateException {
        Loadable[] persisters = this.getPersisters();
        int size = persisters.length;
        String[][] aliases = new String[size][];
        int i = 0;
        while (i < size) {
            String suffix = size == 1 ? null : Integer.toString(i);
            aliases[i] = StringHelper.suffix(persisters[i].getIdentifierColumnNames(), suffix);
            StringHelper.unQuoteInPlace(aliases[i]);
            ++i;
        }
        ArrayList<Serializable[]> list = new ArrayList<Serializable[]>();
        PreparedStatement st = this.prepareQueryStatement(this.getSelectIdentifiersSQL(), values, types, null, false, session);
        try {
            try {
                ResultSet rs = st.executeQuery();
                try {
                    while (rs.next()) {
                        Serializable id = null;
                        Serializable[] ids = null;
                        if (size > 1) {
                            ids = new Serializable[size];
                        }
                        int i2 = 0;
                        while (i2 < size) {
                            id = (Serializable)persisters[i2].getIdentifierType().nullSafeGet(rs, aliases[i2], session, null);
                            if (size > 1) {
                                ids[i2] = id;
                            }
                            ++i2;
                        }
                        list.add((Serializable[])(size > 1 ? ids : id));
                    }
                    Object var15_15 = null;
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var17_18 = null;
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            session.getBatcher().closeQueryStatement(st);
            throw throwable;
        }
        session.getBatcher().closeQueryStatement(st);
        return list;
    }

    public static String[] concreteQueries(String query, SessionFactoryImplementor factory) {
        StringTokenizer tokens = new StringTokenizer(query, ", ");
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        int count = 0;
        boolean check = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("class".equals(token.toLowerCase())) {
                check = true;
                continue;
            }
            if (!check) continue;
            check = false;
            Class clazz = QueryTranslator.getImportedClass(token, factory);
            if (clazz == null) continue;
            String[] implementors = factory.getImplementors(clazz);
            String placeholder = "$clazz" + count + "$";
            query = StringHelper.replaceOnce(query, token, placeholder);
            if (implementors == null) continue;
            placeholders.add(placeholder);
            replacements.add(implementors);
        }
        return StringHelper.multiply(query, placeholders.iterator(), replacements.iterator());
    }

    /*
     * Unable to fully structure code
     */
    private static Class getImportedClass(String name, SessionFactoryImplementor factory) {
        try {
            return ReflectHelper.classForName(name);
        }
        catch (Exception e) {
            imports = factory.getImports();
            i = 0;
            ** while (i < imports.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return ReflectHelper.classForName(imports[i] + '.' + name);
            }
            catch (Exception ex) {
                ++i;
            }
            continue;
        }
lbl12:
        // 1 sources

        return null;
    }

    private static String[][] generateColumnNames(Type[] types, SessionFactoryImplementor f) throws MappingException {
        String[][] names = new String[types.length][];
        int i = 0;
        while (i < types.length) {
            int span = types[i].getColumnSpan(f);
            names[i] = new String[span];
            int j = 0;
            while (j < span) {
                names[i][j] = QueryTranslator.scalarName(i, j);
                ++j;
            }
            ++i;
        }
        return names;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dontSpace.add(".");
        dontSpace.add("+");
        dontSpace.add("-");
        dontSpace.add("/");
        dontSpace.add("*");
        dontSpace.add("<");
        dontSpace.add(">");
        dontSpace.add("=");
        dontSpace.add("#");
        dontSpace.add("~");
        dontSpace.add("|");
        dontSpace.add("&");
        dontSpace.add("<=");
        dontSpace.add(">=");
        dontSpace.add("=>");
        dontSpace.add("=<");
        dontSpace.add("!=");
        dontSpace.add("<>");
        dontSpace.add("!#");
        dontSpace.add("!~");
        dontSpace.add("!<");
        dontSpace.add("!>");
        dontSpace.add("(");
        dontSpace.add(")");
        log = LogFactory.getLog((Class)(class$cirrus$hibernate$query$QueryTranslator == null ? (class$cirrus$hibernate$query$QueryTranslator = QueryTranslator.class$("cirrus.hibernate.query.QueryTranslator")) : class$cirrus$hibernate$query$QueryTranslator));
        NO_INTS = new int[0];
    }
}

