/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.query;

import cirrus.hibernate.QueryException;
import cirrus.hibernate.query.Parser;
import cirrus.hibernate.query.ParserHelper;
import cirrus.hibernate.query.PathExpressionParser;
import cirrus.hibernate.query.QueryTranslator;

public class FromParser
implements Parser {
    private boolean expectingIn;
    private boolean expectingComma;
    private boolean fromClass;
    private String name;
    private PathExpressionParser peParser = new PathExpressionParser();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void token(String token, QueryTranslator q) throws QueryException {
        String lcToken = token.toLowerCase();
        if (lcToken.equals("class")) {
            this.fromClass = true;
            return;
        } else if (this.expectingIn) {
            if (!lcToken.equals("in")) throw new QueryException("IN expected but found: " + token);
            this.expectingIn = false;
            return;
        } else if (this.expectingComma) {
            if (!token.equals(",")) throw new QueryException(", or WHERE expected but found: " + token);
            this.expectingComma = false;
            this.fromClass = false;
            return;
        } else if (this.name == null) {
            this.name = token;
            this.expectingIn = true;
            return;
        } else {
            if (this.fromClass) {
                q.addFromType(this.name, token);
            } else {
                ParserHelper.parse(this.peParser, token, ".", q);
                this.peParser.addFromCollection(q, this.name);
            }
            this.name = null;
            this.expectingComma = true;
        }
    }

    public void start(QueryTranslator q) {
        this.expectingIn = false;
        this.expectingComma = false;
        this.name = null;
        this.fromClass = false;
    }

    public void end(QueryTranslator q) {
    }
}

