/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.persister;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.LockMode;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.StaleObjectStateException;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.engine.Versioning;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.loader.EntityLoader;
import cirrus.hibernate.loader.SimpleEntityLoader;
import cirrus.hibernate.loader.UniqueEntityLoader;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.Component;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.Property;
import cirrus.hibernate.map.Subclass;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.map.Value;
import cirrus.hibernate.persister.AbstractEntityPersister;
import cirrus.hibernate.persister.Queryable;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.DiscriminatorType;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.Type;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityPersister
extends AbstractEntityPersister
implements Queryable {
    private final SessionFactoryImplementor factory;
    private final transient String qualifiedTableName;
    private final transient String[] tableNames;
    private final transient String deleteString;
    private final transient String insertString;
    private final transient String updateString;
    private final transient String identityInsertString;
    private final transient int[] propertyColumnSpans;
    private final transient boolean[] definedOnSubclass;
    private final transient String[][] propertyColumnNames;
    private final transient String[][] subclassPropertyColumnNameClosure;
    private final transient String discriminatorColumnName;
    private final transient String[] columnNames;
    private final transient String[] subclassColumnClosure;
    private final transient Type[] subclassPropertyTypeClosure;
    private final transient Class[] subclassClosure;
    private final transient boolean hasColumns;
    private final transient int[] joinedFetch;
    private final transient HashMap subclassesByDiscriminatorValue = new HashMap();
    private final transient DiscriminatorType discriminatorType;
    private final transient String discriminatorSQLString;
    protected final transient Map loaders = new HashMap();
    protected final transient Map lockers = new HashMap();
    private static final String[] STRING_ARRAY = new String[0];
    private static final Type[] TYPE_ARRAY = new Type[0];
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$persister$EntityPersister == null ? (class$cirrus$hibernate$persister$EntityPersister = EntityPersister.class$("cirrus.hibernate.persister.EntityPersister")) : class$cirrus$hibernate$persister$EntityPersister));
    static /* synthetic */ Class class$cirrus$hibernate$persister$EntityPersister;

    public void postInstantiate(SessionFactoryImplementor factory) throws MappingException {
        HashMap<String, Type> mods = new HashMap<String, Type>();
        Iterator iter = this.typesByPropertyPath.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            Type type = (Type)e.getValue();
            if (!type.isEntityType()) continue;
            String path = (String)e.getKey();
            String[] columns = (String[])this.columnNamesByPropertyPath.get(path);
            if (columns.length == 0) {
                columns = this.getIdentifierColumnNames();
            }
            EntityType etype = (EntityType)type;
            Type idType = factory.getIdentifierType(etype.getPersistentClass());
            String idpath = path + '.' + "id";
            mods.put(idpath, idType);
            this.columnNamesByPropertyPath.put(idpath, columns);
            if (!idType.isComponentType()) continue;
            AbstractComponentType actype = (AbstractComponentType)idType;
            String[] props = actype.getPropertyNames();
            int i = 0;
            while (i < props.length) {
                String subidpath = idpath + '.' + props[i];
                this.columnNamesByPropertyPath.put(subidpath, new String[]{columns[i]});
                mods.put(subidpath, actype.getSubtypes()[i]);
                ++i;
            }
        }
        this.typesByPropertyPath.putAll(mods);
        EntityLoader loader = new EntityLoader(this, factory);
        this.loaders.put(LockMode.NONE, loader);
        this.loaders.put(LockMode.READ, loader);
        String selectForUpdate = factory.getDialect().supportsForUpdate() ? this.generateSelectForUpdateString() : this.generateSelectString();
        this.loaders.put(LockMode.UPGRADE, new SimpleEntityLoader(this, selectForUpdate, LockMode.UPGRADE));
        String selectForUpdateNowait = factory.getDialect().supportsForUpdateNowait() ? this.generateSelectForUpdateNowaitString() : selectForUpdate;
        this.loaders.put(LockMode.UPGRADE_NOWAIT, new SimpleEntityLoader(this, selectForUpdateNowait, LockMode.UPGRADE_NOWAIT));
    }

    public boolean isDefinedOnSubclass(int i) {
        return this.definedOnSubclass[i];
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    public int enableJoinedFetch(int i) {
        return this.joinedFetch[i];
    }

    public String[] getSubclassColumnClosure() {
        return this.subclassColumnClosure;
    }

    public Type getSubclassPropertyType(int i) {
        return this.subclassPropertyTypeClosure[i];
    }

    public int countSubclassProperties() {
        return this.subclassPropertyTypeClosure.length;
    }

    public String getTableName() {
        return this.qualifiedTableName;
    }

    public String[] getSubclassPropertyColumnNames(int i) {
        return this.subclassPropertyColumnNameClosure[i];
    }

    public String[] getPropertyColumnNames(int i) {
        return this.propertyColumnNames[i];
    }

    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    public String getDiscriminatorSQLString() {
        return this.discriminatorSQLString;
    }

    public Class[] getSubclassClosure() {
        return this.subclassClosure;
    }

    public Class getSubclassForDiscriminatorValue(Object value) {
        return (Class)this.subclassesByDiscriminatorValue.get(value);
    }

    public Serializable getIdentifierSpace() {
        return this.qualifiedTableName;
    }

    public Serializable[] getPropertySpaces(Object instance) {
        return this.tableNames;
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected final String sqlDelete() {
        return this.deleteString;
    }

    protected final String sqlInsert() {
        return this.insertString;
    }

    protected final String sqlIdentityInsert() {
        return this.identityInsertString;
    }

    protected final String sqlUpdate() {
        return this.updateString;
    }

    protected String generateDeleteString() {
        StringBuffer buf = new StringBuffer("delete from ").append(this.getTableName()).append(" where ").append(StringHelper.join(" = ? and ", this.getIdentifierColumnNames())).append(" = ?");
        if (this.isVersioned()) {
            buf.append(" and ").append(this.getVersionColumnName()).append(" = ?");
        }
        return buf.toString();
    }

    protected String generateInsertString(boolean identityInsert) {
        String identityColumnInsertString = this.dialect.getIdentityInsertString();
        String[] columnNames = this.getColumnNames();
        boolean hasPropertyColumns = columnNames.length > 0;
        boolean insertIdentifierColumns = !identityInsert || identityColumnInsertString != null;
        String commaAfterProperties = hasPropertyColumns && (insertIdentifierColumns || this.isPolymorphic()) ? ", " : "";
        String commaAfterIdentifiers = insertIdentifierColumns && this.isPolymorphic() ? ", " : "";
        StringBuffer buf = new StringBuffer("insert into ").append(this.getTableName()).append(' ');
        if (!(hasPropertyColumns || insertIdentifierColumns || this.isPolymorphic())) {
            buf.append(this.dialect.getNoColumnsInsertString());
        } else {
            buf.append(" ( ").append(StringHelper.join(", ", columnNames)).append(commaAfterProperties).append(insertIdentifierColumns ? StringHelper.join(", ", this.getIdentifierColumnNames()) : "").append(commaAfterIdentifiers).append(this.isPolymorphic() ? this.getDiscriminatorColumnName() : "").append(" ) values ( ").append(hasPropertyColumns ? StringHelper.repeat("?, ", columnNames.length - 1) : "").append(hasPropertyColumns ? "?" : "").append(commaAfterProperties);
            if (!identityInsert) {
                buf.append(StringHelper.repeat("?, ", this.getIdentifierColumnNames().length - 1)).append("?");
            } else if (identityColumnInsertString != null) {
                buf.append(identityColumnInsertString);
            }
            buf.append(commaAfterIdentifiers);
            if (this.isPolymorphic()) {
                buf.append(this.discriminatorSQLString);
            }
            buf.append(" )");
        }
        return buf.toString();
    }

    protected String generateSelectForUpdateString() {
        return this.generateSelectString() + " for update";
    }

    protected String generateSelectForUpdateNowaitString() {
        return this.generateSelectString() + " for update nowait";
    }

    protected String generateSelectString() {
        String[] subclassColumnClosure = this.getSubclassColumnClosure();
        return new StringBuffer(100).append("select ").append(StringHelper.join(", ", this.getIdentifierColumnNames())).append(this.hasSubclasses() ? ", " + this.getDiscriminatorColumnName() : "").append(subclassColumnClosure.length == 0 ? "" : ", ").append(StringHelper.join(", ", subclassColumnClosure)).append(" from ").append(this.getTableName()).append(" where ").append(StringHelper.join(" = ? and ", this.getIdentifierColumnNames())).append(" = ?").toString();
    }

    protected String generateUpdateString() {
        String[] columnNames = this.getColumnNames();
        StringBuffer setters = new StringBuffer(20);
        int i = 0;
        while (i < columnNames.length) {
            setters.append(columnNames[i]).append(" = ?");
            if (i != columnNames.length - 1) {
                setters.append(", ");
            }
            ++i;
        }
        StringBuffer buf = new StringBuffer(100).append("update ").append(this.getTableName()).append(" set ").append(setters.toString()).append(" where ").append(StringHelper.join(" = ? and ", this.getIdentifierColumnNames())).append(" = ?");
        if (this.isVersioned()) {
            buf.append(" and ").append(this.getVersionColumnName()).append(" = ?");
        }
        return buf.toString();
    }

    protected String generateLockString() {
        StringBuffer buf = new StringBuffer(100).append("select ").append(this.getIdentifierColumnNames()[0]).append(" from ").append(this.getTableName()).append(" where ").append(StringHelper.join(" = ? and ", this.getIdentifierColumnNames())).append(" = ?");
        if (this.isVersioned()) {
            buf.append(" and ").append(this.getVersionColumnName()).append(" = ?");
        }
        return buf.toString();
    }

    protected int dehydrate(Serializable id, Object[] fields, PreparedStatement st, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dehydrating entity: " + this.getClassName() + '#' + id));
        }
        int index = 1;
        int j = 0;
        while (j < this.hydrateSpan) {
            this.getPropertyTypes()[j].nullSafeSet(st, fields[j], index, session);
            index += this.propertyColumnSpans[j];
            ++j;
        }
        if (id != null) {
            this.getIdentifierType().nullSafeSet(st, id, index, session);
            index += this.getIdentifierColumnNames().length;
        }
        return index;
    }

    public Object load(Serializable id, Object optionalObject, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Materializing entity: " + this.getClassName() + '#' + id));
        }
        return ((UniqueEntityLoader)this.loaders.get(lockMode)).load(session, id, optionalObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lock(Serializable id, Object version, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (!lockMode.greaterThan(LockMode.NONE)) return;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Locking entity: " + this.getClassName() + '#' + id));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + version));
            }
        }
        PreparedStatement st = session.getBatcher().prepareStatement((String)this.lockers.get(lockMode));
        try {
            try {
                this.getIdentifierType().nullSafeSet(st, id, 1, session);
                if (this.isVersioned()) {
                    this.getVersionType().nullSafeSet(st, version, 2, session);
                }
                ResultSet rs = st.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new StaleObjectStateException(this.getMappedClass(), id);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var11_12 = null;
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            session.getBatcher().closeStatement(st);
            throw throwable;
        }
        session.getBatcher().closeStatement(st);
    }

    public void insert(Serializable id, Object[] fields, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + this.getClassName() + '#' + id));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        PreparedStatement statement = session.getBatcher().prepareBatchStatement(this.sqlInsert());
        try {
            this.dehydrate(id, fields, statement, session);
            session.getBatcher().addToBatch(1);
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable insert(Object[] fields, Object object, SessionImplementor session) throws SQLException, HibernateException {
        Serializable serializable;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + this.getClassName() + " (native id)"));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        PreparedStatement statement = session.getBatcher().prepareStatement(this.sqlIdentityInsert());
        try {
            try {
                this.dehydrate(null, fields, statement, session);
                statement.executeUpdate();
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            session.getBatcher().closeStatement(statement);
            throw throwable;
        }
        session.getBatcher().closeStatement(statement);
        PreparedStatement idselect = session.getBatcher().prepareStatement(this.sqlIdentitySelect());
        try {
            Serializable id;
            ResultSet rs = idselect.executeQuery();
            try {
                if (!rs.next()) {
                    throw new HibernateException("The database returned no natively generated identity value");
                }
                id = this.dialect.getIdentityFrom(rs);
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            log.debug((Object)("Natively generated identity: " + id));
            serializable = id;
            Object var11_16 = null;
        }
        catch (SQLException sqle) {
            try {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                session.getBatcher().closeStatement(idselect);
                throw throwable;
            }
        }
        session.getBatcher().closeStatement(idselect);
        return serializable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Serializable id, Object version, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting entity: " + this.getClassName() + '#' + id));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + version));
            }
        }
        PreparedStatement statement = this.isVersioned() ? session.getBatcher().prepareStatement(this.sqlDelete()) : session.getBatcher().prepareBatchStatement(this.sqlDelete());
        try {
            try {
                this.getIdentifierType().nullSafeSet(statement, id, 1, session);
                if (this.isVersioned()) {
                    this.getVersionType().nullSafeSet(statement, version, this.getIdentifierColumnNames().length + 1, session);
                    this.check(statement.executeUpdate(), id);
                }
                session.getBatcher().addToBatch(1);
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!this.isVersioned()) throw throwable;
            session.getBatcher().closeStatement(statement);
            throw throwable;
        }
        if (!this.isVersioned()) return;
        session.getBatcher().closeStatement(statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(Serializable id, Object[] fields, int[] dirtyFields, Object oldVersion, Object object, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating entity: " + this.getClassName() + '#' + id));
            if (this.isVersioned()) {
                log.trace((Object)("Existing version: " + oldVersion + " -> New version: " + fields[this.getVersionProperty()]));
            }
        }
        if (!this.hasColumns) {
            return;
        }
        String sql = this.sqlUpdate();
        PreparedStatement statement = this.isVersioned() ? session.getBatcher().prepareStatement(sql) : session.getBatcher().prepareBatchStatement(sql);
        try {
            try {
                int versionParam = this.dehydrate(id, fields, statement, session);
                if (this.isVersioned()) {
                    this.getVersionType().nullSafeSet(statement, oldVersion, versionParam, session);
                    this.check(statement.executeUpdate(), id);
                }
                session.getBatcher().addToBatch(1);
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!this.isVersioned()) throw throwable;
            session.getBatcher().closeStatement(statement);
            throw throwable;
        }
        if (!this.isVersioned()) return;
        session.getBatcher().closeStatement(statement);
    }

    public EntityPersister(PersistentClass model, SessionFactoryImplementor factory) throws MappingException {
        super(model, factory);
        Object discriminatorValue;
        Class mappedClass = model.getPersistentClass();
        this.factory = factory;
        Table table = model.getRootTable();
        this.qualifiedTableName = table.getQualifiedName(factory.getDefaultSchema());
        this.tableNames = new String[]{this.qualifiedTableName};
        if (model.isPolymorphic()) {
            Value d = model.getDiscriminator();
            if (d == null) {
                throw new MappingException("discriminator mapping required for polymorphic persistence");
            }
            this.discriminatorColumnName = ((Column)d.getColumnIterator().next()).getName();
            try {
                this.discriminatorType = (DiscriminatorType)model.getDiscriminator().getType();
                discriminatorValue = this.discriminatorType.stringToObject(model.getDiscriminatorValue());
                this.discriminatorSQLString = this.discriminatorType.objectToSQLString(discriminatorValue);
            }
            catch (ClassCastException cce) {
                throw new MappingException("Illegal discriminator type: " + model.getDiscriminator().getType().getClass().getName());
            }
            catch (Exception e) {
                throw new MappingException("Could not format discriminator value to SQL string", e);
            }
        } else {
            this.discriminatorColumnName = null;
            this.discriminatorType = null;
            discriminatorValue = null;
            this.discriminatorSQLString = null;
        }
        this.propertyColumnNames = new String[this.hydrateSpan][];
        this.propertyColumnSpans = new int[this.hydrateSpan];
        ArrayList<String> columns = new ArrayList<String>();
        HashSet<Property> thisClassProperties = new HashSet<Property>();
        Iterator iter = model.getPropertyClosureIterator();
        int i = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            this.propertyColumnSpans[i] = prop.getColumnSpan();
            thisClassProperties.add(prop);
            String[] colNames = new String[this.propertyColumnSpans[i]];
            Iterator colIter = prop.getColumnIterator();
            int j = 0;
            while (colIter.hasNext()) {
                String colname = ((Column)colIter.next()).getName();
                colNames[j++] = colname;
                columns.add(colname);
            }
            this.propertyColumnNames[i] = colNames;
            this.initPropertyPaths(prop, "");
            ++i;
        }
        if (model.hasIdentifierProperty() && model.getIdentifierProperty().isComposite()) {
            this.initPropertyPaths(model.getIdentifierProperty(), "");
        }
        this.columnNames = columns.toArray(STRING_ARRAY);
        this.hasColumns = this.columnNames.length != 0;
        columns.clear();
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<String[]> propColumns = new ArrayList<String[]>();
        ArrayList<Integer> joinedFetchesList = new ArrayList<Integer>();
        ArrayList<Boolean> definedBySubclass = new ArrayList<Boolean>();
        iter = model.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            definedBySubclass.add(new Boolean(!thisClassProperties.contains(prop)));
            Iterator colIter = prop.getColumnIterator();
            String[] cols = new String[prop.getColumnSpan()];
            types.add(prop.getType());
            int l = 0;
            while (colIter.hasNext()) {
                Column col = (Column)colIter.next();
                columns.add(col.getName());
                cols[l++] = col.getName();
            }
            propColumns.add(cols);
            joinedFetchesList.add(new Integer(prop.getValue().enableJoinedFetch()));
        }
        this.subclassColumnClosure = columns.toArray(STRING_ARRAY);
        this.subclassPropertyTypeClosure = types.toArray(TYPE_ARRAY);
        this.subclassPropertyColumnNameClosure = (String[][])propColumns.toArray((T[])new String[propColumns.size()][]);
        this.joinedFetch = new int[joinedFetchesList.size()];
        iter = joinedFetchesList.iterator();
        int j = 0;
        while (iter.hasNext()) {
            this.joinedFetch[j++] = (Integer)iter.next();
        }
        this.definedOnSubclass = new boolean[definedBySubclass.size()];
        iter = definedBySubclass.iterator();
        j = 0;
        while (iter.hasNext()) {
            this.definedOnSubclass[j++] = (Boolean)iter.next();
        }
        this.deleteString = this.generateDeleteString();
        this.insertString = this.generateInsertString(false);
        this.identityInsertString = this.isIdentifierAssignedByInsert() ? this.generateInsertString(true) : null;
        this.updateString = this.generateUpdateString();
        String lockString = this.generateLockString();
        this.lockers.put(LockMode.READ, lockString);
        String lockExclusiveString = this.dialect.supportsForUpdate() ? lockString + " for update" : lockString;
        this.lockers.put(LockMode.UPGRADE, lockExclusiveString);
        String lockExclusiveNowaitString = this.dialect.supportsForUpdateNowait() ? lockString + " for update nowait" : lockExclusiveString;
        this.lockers.put(LockMode.UPGRADE_NOWAIT, lockExclusiveNowaitString);
        int subclassSpan = model.getSubclassSpan() + 1;
        this.subclassClosure = new Class[subclassSpan];
        this.subclassClosure[0] = mappedClass;
        if (model.isPolymorphic()) {
            this.subclassesByDiscriminatorValue.put(discriminatorValue, mappedClass);
        }
        iter = model.getSubclassIterator();
        int k = 1;
        while (iter.hasNext()) {
            Subclass sc = (Subclass)iter.next();
            this.subclassClosure[k] = sc.getPersistentClass();
            try {
                if (model.isPolymorphic()) {
                    this.subclassesByDiscriminatorValue.put(this.discriminatorType.stringToObject(sc.getDiscriminatorValue()), sc.getPersistentClass());
                }
            }
            catch (Exception e) {
                throw new MappingException("Error parsing discriminator value", e);
            }
            ++k;
        }
    }

    private void initPropertyPaths(Property prop, String path) {
        Iterator iter;
        path = path + prop.getName();
        if (prop.isComposite()) {
            iter = ((Component)prop.getValue()).getPropertyIterator();
            while (iter.hasNext()) {
                this.typesByPropertyPath.put(path, prop.getType());
                this.initPropertyPaths((Property)iter.next(), path + ".");
            }
        }
        iter = prop.getColumnIterator();
        String[] names = new String[prop.getColumnSpan()];
        int k = 0;
        while (iter.hasNext()) {
            names[k] = ((Column)iter.next()).getName();
            ++k;
        }
        Type type = prop.getType();
        this.typesByPropertyPath.put(path, type);
        this.columnNamesByPropertyPath.put(path, names);
    }

    Object readResolve() throws ObjectStreamException {
        try {
            return this.factory.getPersister(this.getMappedClass());
        }
        catch (MappingException me) {
            throw new InvalidObjectException(me.getMessage());
        }
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public String fromClauseFragment(String name, boolean innerJoin) {
        return this.getTableName() + ' ' + name;
    }

    public String outerJoinsAfterFrom(String name, boolean innerJoin) {
        return "";
    }

    public String outerJoinsAfterWhere(String name, boolean innerJoin) {
        return "";
    }

    public String getQueryWhereClause(String name) throws MappingException {
        if (this.isInherited()) {
            StringBuffer buf = new StringBuffer(40);
            buf.append(name).append('.').append(this.getDiscriminatorColumnName()).append(" in (");
            Class[] subclasses = this.getSubclassClosure();
            int i = 0;
            while (i < subclasses.length) {
                buf.append(((Queryable)this.factory.getPersister(subclasses[i])).getDiscriminatorSQLString());
                if (i < subclasses.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append(") ");
            return buf.toString();
        }
        return null;
    }

    public String[] toColumns(String name, String property) throws QueryException {
        String[] idcols = super.toColumns(name, property);
        if (idcols != null) {
            return idcols;
        }
        String[] cols = this.getPropertyColumnNames(property);
        if (cols == null) {
            throw new QueryException("unresolved property: " + property);
        }
        if (cols.length == 0) {
            cols = this.getIdentifierColumnNames();
        }
        return StringHelper.prefix(cols, name + '.');
    }

    public String[] toColumns(String name, int i) {
        return StringHelper.prefix(this.subclassPropertyColumnNameClosure[i], name + '.');
    }

    public String propertySelectClauseFragment(String name, String suffix) {
        StringBuffer buf = new StringBuffer(30);
        if (this.hasSubclasses()) {
            String discr = this.getDiscriminatorColumnName();
            buf.append(", ").append(name).append('.').append(discr).append(" as ").append(AbstractEntityPersister.aliasColumn(discr, suffix));
        }
        String[] cols = this.getSubclassColumnClosure();
        int i = 0;
        while (i < cols.length) {
            buf.append(", ").append(name).append('.').append(cols[i]).append(" as ").append(AbstractEntityPersister.aliasColumn(cols[i], suffix));
            ++i;
        }
        return buf.toString();
    }

    public String getConcreteClassAlias(String alias) {
        return alias;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

