/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.engine.Mapping;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.type.Type;
import org.w3c.dom.Node;

public class Column {
    private static final int DEFAULT_PROPERTY_LENGTH = 255;
    private int length = 255;
    private Type type;
    private int typeIndex;
    private String name;
    private boolean nullable = true;
    private boolean unique = false;
    private String sqlType;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public Column(Type type, int typeIndex) {
        this.type = type;
        this.typeIndex = typeIndex;
    }

    public Column(Node node, boolean isNullable, Type type, int typeIndex) {
        this(type, typeIndex);
        Node nullNode;
        Node lengthNode = node.getAttributes().getNamedItem("length");
        if (lengthNode != null) {
            this.length = Integer.parseInt(lengthNode.getNodeValue());
        }
        this.nullable = (nullNode = node.getAttributes().getNamedItem("not-null")) != null ? !StringHelper.booleanValue(nullNode.getNodeValue()) : isNullable;
        Node unqNode = node.getAttributes().getNamedItem("unique");
        this.unique = unqNode != null && StringHelper.booleanValue(unqNode.getNodeValue());
        Node typeNode = node.getAttributes().getNamedItem("sql-type");
        this.sqlType = typeNode == null ? null : typeNode.getNodeValue();
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public void setTypeIndex(int typeIndex) {
        this.typeIndex = typeIndex;
    }

    public int getSQLType(Mapping pi) throws MappingException {
        try {
            return this.getType().sqlTypes(pi)[this.getTypeIndex()];
        }
        catch (Exception e) {
            throw new MappingException("Could not determine type for column " + this.name + " of type " + this.type.getClass().getName() + ": " + e.getClass().getName(), e);
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getSqlType(Dialect dialect, Mapping pi) throws HibernateException {
        return this.sqlType == null ? dialect.getTypeName(this.getSQLType(pi), this.getLength()) : this.sqlType;
    }

    public boolean equals(Object object) {
        return object instanceof Column && this.equals((Column)object);
    }

    public boolean equals(Column column) {
        if (null == column) {
            return false;
        }
        if (this == column) {
            return true;
        }
        return this.name.equals(column.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

